/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.chart.demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.Window;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.chart.plot.CombinedXYPlot;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class CombinedXYPlotDemo1
extends ApplicationFrame {
    static /* synthetic */ Class class$org$jfree$data$time$Month;

    public CombinedXYPlotDemo1(String title) {
        super(title);
        JPanel panel = CombinedXYPlotDemo1.createDemoPanel();
        panel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(panel);
    }

    private static JFreeChart createCombinedChart() {
        IntervalXYDataset data1 = CombinedXYPlotDemo1.createDataset1();
        XYLineAndShapeRenderer renderer1 = new XYLineAndShapeRenderer(true, false);
        renderer1.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("d-MMM-yyyy"), (NumberFormat)new DecimalFormat("0.00")));
        renderer1.setSeriesStroke(0, (Stroke)new BasicStroke(4.0f, 1, 2));
        renderer1.setSeriesPaint(0, (Paint)Color.blue);
        DateAxis domainAxis = new DateAxis("Year");
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.02);
        NumberAxis rangeAxis = new NumberAxis("$billion");
        XYPlot plot1 = new XYPlot((XYDataset)data1, null, (ValueAxis)rangeAxis, (XYItemRenderer)renderer1);
        plot1.setBackgroundPaint((Paint)Color.lightGray);
        plot1.setDomainGridlinePaint((Paint)Color.white);
        plot1.setRangeGridlinePaint((Paint)Color.white);
        IntervalXYDataset data2 = CombinedXYPlotDemo1.createDataset2();
        XYBarRenderer renderer2 = new XYBarRenderer(){

            public Paint getItemPaint(int series, int item) {
                XYDataset dataset = this.getPlot().getDataset();
                if (dataset.getYValue(series, item) >= 0.0) {
                    return Color.red;
                }
                return Color.green;
            }
        };
        renderer2.setSeriesPaint(0, (Paint)Color.red);
        renderer2.setDrawBarOutline(false);
        renderer2.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("d-MMM-yyyy"), (NumberFormat)new DecimalFormat("0.00")));
        XYPlot plot2 = new XYPlot((XYDataset)data2, null, (ValueAxis)new NumberAxis("$billion"), (XYItemRenderer)renderer2);
        plot2.setBackgroundPaint((Paint)Color.lightGray);
        plot2.setDomainGridlinePaint((Paint)Color.white);
        plot2.setRangeGridlinePaint((Paint)Color.white);
        CombinedXYPlot cplot = new CombinedXYPlot((ValueAxis)domainAxis, (ValueAxis)rangeAxis);
        cplot.add(plot1, 3);
        cplot.add(plot2, 2);
        cplot.setGap(8.0);
        cplot.setDomainGridlinePaint(Color.white);
        cplot.setDomainGridlinesVisible(true);
        JFreeChart chart = new JFreeChart("CombinedXYPlotDemo1", JFreeChart.DEFAULT_TITLE_FONT, (Plot)cplot, false);
        chart.setBackgroundPaint((Paint)Color.white);
        LegendTitle legend = new LegendTitle((LegendItemSource)cplot);
        chart.addSubtitle((Title)legend);
        return chart;
    }

    private static IntervalXYDataset createDataset1() {
        TimeSeries series1 = new TimeSeries((Comparable)((Object)"Series 1"), class$org$jfree$data$time$Month == null ? (class$org$jfree$data$time$Month = CombinedXYPlotDemo1.class$("org.jfree.data.time.Month")) : class$org$jfree$data$time$Month);
        series1.add((RegularTimePeriod)new Month(1, 2005), 7627.743);
        series1.add((RegularTimePeriod)new Month(2, 2005), 7713.138);
        series1.add((RegularTimePeriod)new Month(3, 2005), 6776.939);
        series1.add((RegularTimePeriod)new Month(4, 2005), 5764.537);
        series1.add((RegularTimePeriod)new Month(5, 2005), 4777.88);
        series1.add((RegularTimePeriod)new Month(6, 2005), 4836.496);
        series1.add((RegularTimePeriod)new Month(7, 2005), 3887.618);
        series1.add((RegularTimePeriod)new Month(8, 2005), 3926.933);
        series1.add((RegularTimePeriod)new Month(9, 2005), 4932.71);
        series1.add((RegularTimePeriod)new Month(10, 2005), 4027.123);
        series1.add((RegularTimePeriod)new Month(11, 2005), 8092.322);
        series1.add((RegularTimePeriod)new Month(12, 2005), 8170.414);
        series1.add((RegularTimePeriod)new Month(1, 2006), 8196.07);
        series1.add((RegularTimePeriod)new Month(2, 2006), 8269.886);
        series1.add((RegularTimePeriod)new Month(3, 2006), 5371.156);
        series1.add((RegularTimePeriod)new Month(4, 2006), 5355.718);
        series1.add((RegularTimePeriod)new Month(5, 2006), 5356.777);
        series1.add((RegularTimePeriod)new Month(6, 2006), 8420.042);
        series1.add((RegularTimePeriod)new Month(7, 2006), 8444.347);
        series1.add((RegularTimePeriod)new Month(8, 2006), 8515.034);
        series1.add((RegularTimePeriod)new Month(9, 2006), 8506.974);
        series1.add((RegularTimePeriod)new Month(10, 2006), 8584.329);
        series1.add((RegularTimePeriod)new Month(11, 2006), 8633.246);
        series1.add((RegularTimePeriod)new Month(12, 2006), 8680.224);
        series1.add((RegularTimePeriod)new Month(1, 2007), 8707.561);
        return new TimeSeriesCollection(series1);
    }

    private static IntervalXYDataset createDataset2() {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        TimeSeries series1 = new TimeSeries((Comparable)((Object)"Series 2"), class$org$jfree$data$time$Month == null ? (class$org$jfree$data$time$Month = CombinedXYPlotDemo1.class$("org.jfree.data.time.Month")) : class$org$jfree$data$time$Month);
        series1.add((RegularTimePeriod)new Month(1, 2005), 1200.0);
        series1.add((RegularTimePeriod)new Month(2, 2005), 1400.0);
        series1.add((RegularTimePeriod)new Month(3, 2005), 1500.0);
        series1.add((RegularTimePeriod)new Month(4, 2005), 1700.0);
        series1.add((RegularTimePeriod)new Month(5, 2005), 1600.0);
        series1.add((RegularTimePeriod)new Month(6, 2005), 2400.0);
        series1.add((RegularTimePeriod)new Month(7, 2005), 2100.0);
        series1.add((RegularTimePeriod)new Month(8, 2005), 2200.0);
        series1.add((RegularTimePeriod)new Month(9, 2005), 800.0);
        series1.add((RegularTimePeriod)new Month(10, 2005), 2350.0);
        series1.add((RegularTimePeriod)new Month(11, 2005), 500.0);
        series1.add((RegularTimePeriod)new Month(12, 2005), 700.0);
        series1.add((RegularTimePeriod)new Month(1, 2006), 900.0);
        series1.add((RegularTimePeriod)new Month(2, 2006), 1500.0);
        series1.add((RegularTimePeriod)new Month(3, 2006), 2100.0);
        series1.add((RegularTimePeriod)new Month(4, 2006), 2200.0);
        series1.add((RegularTimePeriod)new Month(5, 2006), 1900.0);
        series1.add((RegularTimePeriod)new Month(6, 2006), 3000.0);
        series1.add((RegularTimePeriod)new Month(7, 2006), 3780.0);
        series1.add((RegularTimePeriod)new Month(8, 2006), 4000.0);
        series1.add((RegularTimePeriod)new Month(9, 2006), 4500.0);
        series1.add((RegularTimePeriod)new Month(10, 2006), 7000.0);
        series1.add((RegularTimePeriod)new Month(11, 2006), 5500.0);
        series1.add((RegularTimePeriod)new Month(12, 2006), 6000.0);
        series1.add((RegularTimePeriod)new Month(1, 2007), 6500.0);
        dataset.addSeries(series1);
        return dataset;
    }

    public static JPanel createDemoPanel() {
        JFreeChart chart = CombinedXYPlotDemo1.createCombinedChart();
        return new ChartPanel(chart);
    }

    public static void main(String[] args) {
        CombinedXYPlotDemo1 demo = new CombinedXYPlotDemo1("JFreeChart : CombinedXYPlotDemo1");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)demo));
        demo.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

