/*
 * Decompiled with CFR 0.152.
 */
package scimat.project;

import java.io.File;
import java.util.LinkedList;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.FactoryDAO;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.model.upgrade.KnowledgeBaseVersion;
import scimat.project.observer.KnowledgeBaseObserver;
import scimat.project.observer.KnowledgeBaseStateObserver;

public class CurrentProject {
    private String currentProjectPath;
    private KnowledgeBaseManager kbm = null;
    private FactoryDAO factoryDAO;
    private LinkedList<KnowledgeBaseStateObserver> knowledgeBaseStateObservers = new LinkedList();
    private KnowledgeBaseObserver kbObserver = new KnowledgeBaseObserver();

    private CurrentProject() {
    }

    public static CurrentProject getInstance() {
        return CurrentProjectSingleton.INSTANCE;
    }

    public void newProyect(String folderPath, String filePath) throws KnowledgeBaseException {
        if (!this.isKnowledbaseLoaded()) {
            try {
                this.currentProjectPath = folderPath;
                this.kbm = new KnowledgeBaseManager();
                this.kbm.createKnowledgeBase(folderPath + File.separator + filePath);
                this.factoryDAO = new FactoryDAO(this.kbm);
                this.notifyKnowledgeBaseObsever(this.isKnowledbaseLoaded());
                this.kbObserver.fireKnowledgeBaseRefresh();
            }
            catch (KnowledgeBaseException e) {
                this.kbm = null;
                throw e;
            }
        }
    }

    public void loadProyect(String path) throws KnowledgeBaseException {
        if (!this.isKnowledbaseLoaded()) {
            try {
                this.currentProjectPath = path;
                this.kbm = new KnowledgeBaseManager();
                this.kbm.loadKnowledgeBase(path, true);
                this.factoryDAO = new FactoryDAO(this.kbm);
                this.notifyKnowledgeBaseObsever(this.isKnowledbaseLoaded());
                this.kbObserver.fireKnowledgeBaseRefresh();
            }
            catch (KnowledgeBaseException e) {
                this.kbm = null;
                throw e;
            }
        }
    }

    public KnowledgeBaseVersion checkKnowledgeBaseVersion(String path) throws KnowledgeBaseException {
        KnowledgeBaseVersion version = KnowledgeBaseVersion.UNDEFINED;
        if (!this.isKnowledbaseLoaded()) {
            this.currentProjectPath = path;
            KnowledgeBaseManager kbmTmp = new KnowledgeBaseManager();
            kbmTmp.loadKnowledgeBase(path, false);
            if (kbmTmp.checkKnowledgeBaseStructure()) {
                version = KnowledgeBaseVersion.V_1_03;
            } else if (kbmTmp.checkKnowledgeBaseStructureV1_02()) {
                version = KnowledgeBaseVersion.V_1_02;
            } else if (kbmTmp.checkKnowledgeBaseStructureV1_01()) {
                version = KnowledgeBaseVersion.V_1_01;
            }
            kbmTmp.close();
        }
        return version;
    }

    public void close() throws KnowledgeBaseException {
        if (this.isKnowledbaseLoaded()) {
            this.kbm.close();
            this.kbm = null;
            this.factoryDAO = null;
            this.notifyKnowledgeBaseObsever(this.isKnowledbaseLoaded());
        }
    }

    public KnowledgeBaseManager getKnowledgeBase() {
        return this.kbm;
    }

    public KnowledgeBaseObserver getKbObserver() {
        return this.kbObserver;
    }

    public FactoryDAO getFactoryDAO() {
        return this.factoryDAO;
    }

    public String getCurrentProjectPath() {
        return this.currentProjectPath;
    }

    public boolean isKnowledbaseLoaded() {
        return this.kbm != null;
    }

    public void addKnowledgeBaseStateObserver(KnowledgeBaseStateObserver observer) {
        this.knowledgeBaseStateObservers.add(observer);
        observer.knowledgeBaseStateChanged(this.isKnowledbaseLoaded());
    }

    public boolean removeKnowledgeBaseObserver(KnowledgeBaseStateObserver observer) {
        return this.knowledgeBaseStateObservers.remove(observer);
    }

    private void notifyKnowledgeBaseObsever(boolean state) {
        for (int i = 0; i < this.knowledgeBaseStateObservers.size(); ++i) {
            this.knowledgeBaseStateObservers.get(i).knowledgeBaseStateChanged(state);
        }
    }

    private static class CurrentProjectSingleton {
        private static final CurrentProject INSTANCE = new CurrentProject();

        private CurrentProjectSingleton() {
        }
    }
}

