/*
 * Decompiled with CFR 0.152.
 */
package scimat.observabletask;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingWorker;
import scimat.observabletask.InterimResultTaskObserver;
import scimat.observabletask.ProgressTaskObserver;
import scimat.observabletask.StatusTaskObserver;
import scimat.observabletask.TaskStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObservableTask<T, V>
extends SwingWorker<T, V>
implements PropertyChangeListener {
    private LinkedList<InterimResultTaskObserver<V>> _lInterimResultTaskObserver = new LinkedList();
    private LinkedList<ProgressTaskObserver> _lProgressTaskObserver = new LinkedList();
    private LinkedList<StatusTaskObserver> _lStatusTaskObserver = new LinkedList();
    private boolean _sendAllInterimResults = false;
    private boolean _determinateMode = true;
    private TaskStatus _taskStatus = TaskStatus.PENDING;
    private Exception _exception = null;

    public ObservableTask() {
        this.addPropertyChangeListener(this);
    }

    public ObservableTask(boolean sendAllInterimResult) {
        this._sendAllInterimResults = sendAllInterimResult;
        this.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress".equals(evt.getPropertyName())) {
            this.notifyProgressTaskObserver(this.isDeterminateMode(), (Integer)evt.getNewValue());
        }
    }

    public boolean getSendAllInterimResults() {
        return this._sendAllInterimResults;
    }

    public void setSendAllInterimResults(boolean sendAllInterimResults) {
        this._sendAllInterimResults = sendAllInterimResults;
    }

    public Exception getException() {
        return this._exception;
    }

    @Override
    protected void process(List<V> chunks) {
        if (this._sendAllInterimResults) {
            for (V interimResult : chunks) {
                this.notifyInterimResultTaskObserver(interimResult);
            }
        } else {
            this.notifyInterimResultTaskObserver(chunks.get(chunks.size() - 1));
        }
    }

    @Override
    protected void done() {
        super.done();
        if (this.isCancelled()) {
            this.notifyStatusTaskObserver(TaskStatus.CANCELLED);
        } else if (this._exception != null) {
            this.notifyStatusTaskObserver(TaskStatus.EXCEPTION);
        } else {
            this.notifyStatusTaskObserver(TaskStatus.DONE);
        }
    }

    protected boolean isDeterminateMode() {
        return this._determinateMode;
    }

    protected void setDeterminateMode(boolean mode) {
        this._determinateMode = mode;
    }

    protected void setTaskStatus(TaskStatus status) {
        this._taskStatus = status;
        this.notifyStatusTaskObserver(this._taskStatus);
    }

    protected TaskStatus getTaskStatus() {
        return this._taskStatus;
    }

    protected int calculateProgres(long min, long max, long actual) {
        return (int)((double)Math.abs(min - actual) / (double)Math.abs(min - max) * 100.0);
    }

    protected void setException(Exception e) {
        this._exception = e;
    }

    public void addInterimResultTaskObserver(InterimResultTaskObserver<V> observer) {
        this._lInterimResultTaskObserver.add(observer);
    }

    public boolean removeInterimResultTaskObserver(InterimResultTaskObserver<V> observer) {
        return this._lInterimResultTaskObserver.remove(observer);
    }

    private void notifyInterimResultTaskObserver(V interimResult) {
        for (int i = 0; i < this._lInterimResultTaskObserver.size(); ++i) {
            this._lInterimResultTaskObserver.get(i).interimResultChanged(interimResult);
        }
    }

    public void addProgressTaskObserver(ProgressTaskObserver observer) {
        this._lProgressTaskObserver.add(observer);
        this.notifyProgressTaskObserver(this.isDeterminateMode(), this.getProgress());
    }

    public boolean removeProgressTaskObserver(ProgressTaskObserver observer) {
        return this._lProgressTaskObserver.remove(observer);
    }

    private void notifyProgressTaskObserver(boolean mode, int progress) {
        for (int i = 0; i < this._lProgressTaskObserver.size(); ++i) {
            this._lProgressTaskObserver.get(i).progressChanged(mode, progress);
        }
    }

    public void addStatusTaskObserver(StatusTaskObserver observer) {
        this._lStatusTaskObserver.add(observer);
        this.notifyStatusTaskObserver(this.getTaskStatus());
    }

    public boolean removeStatusTaskObserver(StatusTaskObserver observer) {
        return this._lStatusTaskObserver.remove(observer);
    }

    private void notifyStatusTaskObserver(TaskStatus status) {
        for (int i = 0; i < this._lStatusTaskObserver.size(); ++i) {
            this._lStatusTaskObserver.get(i).statusTaskChanged(status);
        }
    }
}

