/*
 * Decompiled with CFR 0.152.
 */
package scimat.model.upgrade;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.sqlite.SQLiteConfig;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.FactoryDAO;
import scimat.model.knowledgebase.exception.IncorrectFormatKnowledgeBaseException;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.model.upgrade.KnowledgeBaseVersion;
import scimat.project.CurrentProject;

public class UpgradeKnowledgeBaseVersion {
    private String newKnowledgeBaseFile;
    private String oldKnowledgeBaseFile;

    public UpgradeKnowledgeBaseVersion(String newKnowledgeBaseFile, String olKnowledgeBaseFile) {
        this.newKnowledgeBaseFile = newKnowledgeBaseFile;
        this.oldKnowledgeBaseFile = olKnowledgeBaseFile;
    }

    public void execute() throws KnowledgeBaseException {
        KnowledgeBaseVersion kbVersion = CurrentProject.getInstance().checkKnowledgeBaseVersion(this.oldKnowledgeBaseFile);
        switch (kbVersion) {
            case V_1_01: {
                this.updgradeFromV1_01();
                break;
            }
            case V_1_02: {
                this.updgradeFromV1_02();
                break;
            }
            case V_1_03: {
                throw new IncorrectFormatKnowledgeBaseException("The knowledge base has a current version.");
            }
            case UNDEFINED: {
                throw new IncorrectFormatKnowledgeBaseException("Incorrect knowledge base format.");
            }
            default: {
                throw new IncorrectFormatKnowledgeBaseException("Incorrect knowledge base format.");
            }
        }
    }

    private void updgradeFromV1_01() throws KnowledgeBaseException {
        KnowledgeBaseManager newKnowledgeBaseManager = null;
        Connection conn = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            Integer referenceSourceID;
            Integer authorID;
            SQLiteConfig config = new SQLiteConfig();
            config.enforceForeignKeys(true);
            conn = DriverManager.getConnection("jdbc:sqlite:" + this.oldKnowledgeBaseFile, config.toProperties());
            newKnowledgeBaseManager = new KnowledgeBaseManager();
            newKnowledgeBaseManager.createKnowledgeBase(this.newKnowledgeBaseFile);
            FactoryDAO newFactoryDAO = new FactoryDAO(newKnowledgeBaseManager);
            stat = conn.prepareStatement("Select idAuthorGroup, groupName, stopGroup FROM AuthorGroup;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getAuthorGroupDAO().addAuthorGroup(rs.getInt("idAuthorGroup"), rs.getString("groupName"), rs.getBoolean("stopGroup"), false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select idAuthorReferenceGroup, groupName,stopGroup FROM AuthorReferenceGroup;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getAuthorReferenceGroupDAO().addAuthorReferenceGroup(rs.getInt("idAuthorReferenceGroup"), rs.getString("groupName"), rs.getBoolean("stopGroup"), false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select idReferenceGroup, groupName, stopGroup FROM ReferenceGroup;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getReferenceGroupDAO().addReferenceGroup(rs.getInt("idReferenceGroup"), rs.getString("groupName"), rs.getBoolean("stopGroup"), false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select idReferenceSourceGroup, groupName, stopGroup FROM ReferenceSourceGroup;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getReferenceSourceGroupDAO().addReferenceSourceGroup(rs.getInt("idReferenceSourceGroup"), rs.getString("groupName"), rs.getBoolean("stopGroup"), false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select idWordGroup, groupName, stopGroup FROM WordGroup;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getWordGroupDAO().addWordGroup(rs.getInt("idWordGroup"), rs.getString("groupName"), rs.getBoolean("stopGroup"), false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select idAffiliation, fullAffiliation FROM Affiliation;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getAffiliationDAO().addAffiliation(rs.getInt("idAffiliation"), rs.getString("fullAffiliation"), false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select idAuthor, authorName, fullAuthorName, AuthorGroup_idAuthorGroup FROM Author;");
            rs = stat.executeQuery();
            while (rs.next()) {
                authorID = rs.getInt("idAuthor");
                newFactoryDAO.getAuthorDAO().addAuthor(authorID, rs.getString("authorName"), rs.getString("fullAuthorName"), false);
                Integer authorGroupID = rs.getInt("AuthorGroup_idAuthorGroup");
                if (rs.wasNull()) continue;
                newFactoryDAO.getAuthorDAO().setAuthorGroup(authorID, authorGroupID, false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select idAuthorReference, authorName, AuthorReferenceGroup_idAuthorReferenceGroup, Author_idAuthor FROM AuthorReference;");
            rs = stat.executeQuery();
            while (rs.next()) {
                Integer authorReferenceID = rs.getInt("idAuthorReference");
                newFactoryDAO.getAuthorReferenceDAO().addAuthorReference(authorReferenceID, rs.getString("authorName"), false);
                Integer authorReferenceGroupID = rs.getInt("AuthorReferenceGroup_idAuthorReferenceGroup");
                if (!rs.wasNull()) {
                    newFactoryDAO.getAuthorReferenceDAO().setAuthorReferenceGroup(authorReferenceID, authorReferenceGroupID, false);
                }
                authorID = rs.getInt("Author_idAuthor");
                if (rs.wasNull()) continue;
                newFactoryDAO.getAuthorReferenceDAO().setAuthor(authorReferenceID, authorID, false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select idJournal, source, conferenceInformation FROM Journal;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getJournalDAO().addJournal(rs.getInt("idJournal"), rs.getString("source"), rs.getString("conferenceInformation"), false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select idPeriod, name, position FROM Period;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getPeriodDAO().addPeriod(rs.getInt("idPeriod"), rs.getString("name"), rs.getInt("position"), false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select idPublishDate, year, date FROM PublishDate;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getPublishDateDAO().addPublishDate(rs.getInt("idPublishDate"), rs.getString("year"), rs.getString("date"), false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select idReferenceSource, source, ReferenceSourceGroup_idReferencesourceGroup FROM ReferenceSource;");
            rs = stat.executeQuery();
            while (rs.next()) {
                referenceSourceID = rs.getInt("idReferenceSource");
                newFactoryDAO.getReferenceSourceDAO().addReferenceSource(referenceSourceID, rs.getString("source"), false);
                Integer referenceSourceGroupID = rs.getInt("ReferenceSourceGroup_idReferencesourceGroup");
                if (rs.wasNull()) continue;
                newFactoryDAO.getReferenceSourceDAO().setReferenceSourceGroup(referenceSourceID, referenceSourceGroupID, false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select idReference, fullReference, ReferenceSource_idReferenceSource, volume, issue, page, doi, format, year, ReferenceGroup_idReferenceGroup FROM Reference;");
            rs = stat.executeQuery();
            while (rs.next()) {
                Integer referenceID = rs.getInt("idReference");
                newFactoryDAO.getReferenceDAO().addReference(rs.getInt("idReference"), rs.getString("fullReference"), rs.getString("volume"), rs.getString("issue"), rs.getString("page"), rs.getString("year"), rs.getString("doi"), rs.getString("format"), false);
                referenceSourceID = rs.getInt("ReferenceSource_idReferenceSource");
                if (!rs.wasNull()) {
                    newFactoryDAO.getReferenceDAO().setReferenceSource(referenceID, referenceSourceID, false);
                }
                Integer referenceGroupID = rs.getInt("ReferenceGroup_idReferenceGroup");
                if (rs.wasNull()) continue;
                newFactoryDAO.getReferenceDAO().setReferenceGroup(referenceID, referenceGroupID, false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select idSubjectCategory, subjectCategoryName FROM SubjectCategory;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getSubjectCategoryDAO().addSubjectCategory(rs.getInt("idSubjectCategory"), rs.getString("subjectCategoryName"), false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select idWord, wordName, WordGroup_idWordGroup FROM Word;");
            rs = stat.executeQuery();
            while (rs.next()) {
                Integer wordID = rs.getInt("idWord");
                newFactoryDAO.getWordDAO().addWord(wordID, rs.getString("wordName"), false);
                Integer wordGroupID = rs.getInt("WordGroup_idWordGroup");
                if (rs.wasNull()) continue;
                newFactoryDAO.getWordDAO().setWordGroup(wordID, wordGroupID, false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select idDocument, title, type, docAbstract, volume, issue, beginPage, endPage, citationsCount, doi, sourceIdentifier, PublishDate_idPublishDate, Journal_idJournal FROM Document;");
            rs = stat.executeQuery();
            while (rs.next()) {
                Integer documentID = rs.getInt("idDocument");
                newFactoryDAO.getDocumentDAO().addDocument(rs.getInt("idDocument"), rs.getString("title"), rs.getString("docAbstract"), rs.getString("type"), rs.getInt("citationsCount"), rs.getString("doi"), rs.getString("sourceIdentifier"), rs.getString("volume"), rs.getString("issue"), rs.getString("beginPage"), rs.getString("endPage"), false);
                Integer publishDateID = rs.getInt("PublishDate_idPublishDate");
                if (!rs.wasNull()) {
                    newFactoryDAO.getDocumentDAO().setPublishDate(documentID, publishDateID, false);
                }
                Integer journalId = rs.getInt("Journal_idJournal");
                if (rs.wasNull()) continue;
                newFactoryDAO.getDocumentDAO().setJournal(documentID, journalId, false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select PublishDate_idPublishDate, Period_idPeriod FROM PublishDate_Period;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getPublishDatePeriodDAO().addPublishDatePeriod(rs.getInt("Period_idPeriod"), rs.getInt("PublishDate_idPublishDate"), false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select Journal_idJournal, SubjectCategory_idSubjectCategory, PublishDate_idPublishDate FROM Journal_SubjectCategory_PublishDate;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getJournalSubjectCategoryPublishDateDAO().addSubjectCategoryToJournal(rs.getInt("SubjectCategory_idSubjectCategory"), rs.getInt("Journal_idJournal"), rs.getInt("PublishDate_idPublishDate"), false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select Author_idAuthor, Document_idDocument, position FROM Document_Author;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getDocumentAuthorDAO().addDocumentAuthor(rs.getInt("Document_idDocument"), rs.getInt("Author_idAuthor"), rs.getInt("position"), false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select Affiliation_idAffiliation, Document_idDocument FROM Document_Affiliation;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getDocumentAffiliationDAO().addDocumentAffiliation(rs.getInt("Document_idDocument"), rs.getInt("Affiliation_idAffiliation"), false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select Document_idDocument, Word_idWord, authorKeyword, sourceKeyword, extractedKeyword FROM Document_Word;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getDocumentWordDAO().addDocumentWord(rs.getInt("Document_idDocument"), rs.getInt("Word_idWord"), rs.getBoolean("authorKeyword"), rs.getBoolean("sourceKeyword"), rs.getBoolean("extractedKeyword"), false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select Reference_idReference, Document_idDocument FROM Document_Reference;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getDocumentReferenceDAO().addDocumentReference(rs.getInt("Document_idDocument"), rs.getInt("Reference_idReference"), false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select AuthorReference_idAuthorReference, Reference_idReference, position FROM AuthorReference_Reference;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getAuthorReferenceReferenceDAO().addAuthorReferenceReference(rs.getInt("Reference_idReference"), rs.getInt("AuthorReference_idAuthorReference"), rs.getInt("position"), false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select Affiliation_idAffiliation, Author_idAuthor FROM Author_Affiliation;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getAuthorAffiliationDAO().addAuthorAffiliation(rs.getInt("Author_idAuthor"), rs.getInt("Affiliation_idAffiliation"), false);
            }
            rs.close();
            stat.close();
            newKnowledgeBaseManager.commit();
            newKnowledgeBaseManager.close();
            conn.close();
        }
        catch (SQLException sqle) {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                throw new KnowledgeBaseException(ex.getCause());
            }
        }
        catch (KnowledgeBaseException kbe) {
            newKnowledgeBaseManager.rollback();
            newKnowledgeBaseManager.close();
            throw kbe;
        }
    }

    private void updgradeFromV1_02() throws KnowledgeBaseException {
        KnowledgeBaseManager newKnowledgeBaseManager = null;
        Connection conn = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            Integer referenceSourceID;
            Integer authorID;
            SQLiteConfig config = new SQLiteConfig();
            config.enforceForeignKeys(true);
            conn = DriverManager.getConnection("jdbc:sqlite:" + this.oldKnowledgeBaseFile, config.toProperties());
            newKnowledgeBaseManager = new KnowledgeBaseManager();
            newKnowledgeBaseManager.createKnowledgeBase(this.newKnowledgeBaseFile);
            FactoryDAO newFactoryDAO = new FactoryDAO(newKnowledgeBaseManager);
            System.out.println("Adding AuthorGroup...");
            stat = conn.prepareStatement("Select idAuthorGroup, groupName, stopGroup FROM AuthorGroup;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getAuthorGroupDAO().addAuthorGroup(rs.getInt("idAuthorGroup"), rs.getString("groupName"), rs.getBoolean("stopGroup"), false);
            }
            rs.close();
            stat.close();
            System.out.println("Adding AuthorReferenceGroup...");
            stat = conn.prepareStatement("Select idAuthorReferenceGroup, groupName,stopGroup FROM AuthorReferenceGroup;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getAuthorReferenceGroupDAO().addAuthorReferenceGroup(rs.getInt("idAuthorReferenceGroup"), rs.getString("groupName"), rs.getBoolean("stopGroup"), false);
            }
            rs.close();
            stat.close();
            System.out.println("Adding ReferenceGroup...");
            stat = conn.prepareStatement("Select idReferenceGroup, groupName, stopGroup FROM ReferenceGroup;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getReferenceGroupDAO().addReferenceGroup(rs.getInt("idReferenceGroup"), rs.getString("groupName"), rs.getBoolean("stopGroup"), false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select idReferenceSourceGroup, groupName, stopGroup FROM ReferenceSourceGroup;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getReferenceSourceGroupDAO().addReferenceSourceGroup(rs.getInt("idReferenceSourceGroup"), rs.getString("groupName"), rs.getBoolean("stopGroup"), false);
            }
            rs.close();
            stat.close();
            System.out.println("Adding WordGroup...");
            stat = conn.prepareStatement("Select idWordGroup, groupName, stopGroup FROM WordGroup;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getWordGroupDAO().addWordGroup(rs.getInt("idWordGroup"), rs.getString("groupName"), rs.getBoolean("stopGroup"), false);
            }
            rs.close();
            stat.close();
            System.out.println("Adding Afiiliation...");
            stat = conn.prepareStatement("Select idAffiliation, fullAffiliation FROM Affiliation;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getAffiliationDAO().addAffiliation(rs.getInt("idAffiliation"), rs.getString("fullAffiliation"), false);
            }
            rs.close();
            stat.close();
            System.out.println("Adding Author...");
            stat = conn.prepareStatement("Select idAuthor, authorName, fullAuthorName, AuthorGroup_idAuthorGroup FROM Author;");
            rs = stat.executeQuery();
            while (rs.next()) {
                authorID = rs.getInt("idAuthor");
                newFactoryDAO.getAuthorDAO().addAuthor(authorID, rs.getString("authorName"), rs.getString("fullAuthorName"), false);
                Integer authorGroupID = rs.getInt("AuthorGroup_idAuthorGroup");
                if (rs.wasNull()) continue;
                newFactoryDAO.getAuthorDAO().setAuthorGroup(authorID, authorGroupID, false);
            }
            rs.close();
            stat.close();
            System.out.println("Adding AuthorReference...");
            stat = conn.prepareStatement("Select idAuthorReference, authorName, AuthorReferenceGroup_idAuthorReferenceGroup, Author_idAuthor FROM AuthorReference;");
            rs = stat.executeQuery();
            while (rs.next()) {
                Integer authorReferenceID = rs.getInt("idAuthorReference");
                newFactoryDAO.getAuthorReferenceDAO().addAuthorReference(authorReferenceID, rs.getString("authorName"), false);
                Integer authorReferenceGroupID = rs.getInt("AuthorReferenceGroup_idAuthorReferenceGroup");
                if (!rs.wasNull()) {
                    newFactoryDAO.getAuthorReferenceDAO().setAuthorReferenceGroup(authorReferenceID, authorReferenceGroupID, false);
                }
                authorID = rs.getInt("Author_idAuthor");
                if (rs.wasNull()) continue;
                newFactoryDAO.getAuthorReferenceDAO().setAuthor(authorReferenceID, authorID, false);
            }
            rs.close();
            stat.close();
            System.out.println("Adding Journal...");
            stat = conn.prepareStatement("Select idJournal, source, conferenceInformation FROM Journal;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getJournalDAO().addJournal(rs.getInt("idJournal"), rs.getString("source"), rs.getString("conferenceInformation"), false);
            }
            rs.close();
            stat.close();
            System.out.println("Adding Period...");
            stat = conn.prepareStatement("Select idPeriod, name, position FROM Period;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getPeriodDAO().addPeriod(rs.getInt("idPeriod"), rs.getString("name"), rs.getInt("position"), false);
            }
            rs.close();
            stat.close();
            stat = conn.prepareStatement("Select idPublishDate, year, date FROM PublishDate;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getPublishDateDAO().addPublishDate(rs.getInt("idPublishDate"), rs.getString("year"), rs.getString("date"), false);
            }
            rs.close();
            stat.close();
            System.out.println("Adding ReferenceSource...");
            stat = conn.prepareStatement("Select idReferenceSource, source, ReferenceSourceGroup_idReferencesourceGroup FROM ReferenceSource;");
            rs = stat.executeQuery();
            while (rs.next()) {
                referenceSourceID = rs.getInt("idReferenceSource");
                newFactoryDAO.getReferenceSourceDAO().addReferenceSource(referenceSourceID, rs.getString("source"), false);
                Integer referenceSourceGroupID = rs.getInt("ReferenceSourceGroup_idReferencesourceGroup");
                if (rs.wasNull()) continue;
                newFactoryDAO.getReferenceSourceDAO().setReferenceSourceGroup(referenceSourceID, referenceSourceGroupID, false);
            }
            rs.close();
            stat.close();
            System.out.println("Adding Reference...");
            stat = conn.prepareStatement("Select idReference, fullReference, ReferenceSource_idReferenceSource, volume, issue, page, doi, format, year, ReferenceGroup_idReferenceGroup FROM Reference;");
            rs = stat.executeQuery();
            while (rs.next()) {
                Integer referenceID = rs.getInt("idReference");
                newFactoryDAO.getReferenceDAO().addReference(rs.getInt("idReference"), rs.getString("fullReference"), rs.getString("volume"), rs.getString("issue"), rs.getString("page"), rs.getString("year"), rs.getString("doi"), rs.getString("format"), false);
                referenceSourceID = rs.getInt("ReferenceSource_idReferenceSource");
                if (!rs.wasNull()) {
                    newFactoryDAO.getReferenceDAO().setReferenceSource(referenceID, referenceSourceID, false);
                }
                Integer referenceGroupID = rs.getInt("ReferenceGroup_idReferenceGroup");
                if (rs.wasNull()) continue;
                newFactoryDAO.getReferenceDAO().setReferenceGroup(referenceID, referenceGroupID, false);
            }
            rs.close();
            stat.close();
            System.out.println("Adding SubjectCategory...");
            stat = conn.prepareStatement("Select idSubjectCategory, subjectCategoryName FROM SubjectCategory;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getSubjectCategoryDAO().addSubjectCategory(rs.getInt("idSubjectCategory"), rs.getString("subjectCategoryName"), false);
            }
            rs.close();
            stat.close();
            System.out.println("Adding Word...");
            stat = conn.prepareStatement("Select idWord, wordName, WordGroup_idWordGroup FROM Word;");
            rs = stat.executeQuery();
            while (rs.next()) {
                Integer wordID = rs.getInt("idWord");
                newFactoryDAO.getWordDAO().addWord(wordID, rs.getString("wordName"), false);
                Integer wordGroupID = rs.getInt("WordGroup_idWordGroup");
                if (rs.wasNull()) continue;
                newFactoryDAO.getWordDAO().setWordGroup(wordID, wordGroupID, false);
            }
            rs.close();
            stat.close();
            System.out.println("Adding Document...");
            stat = conn.prepareStatement("Select idDocument, title, type, docAbstract, volume, issue, beginPage, endPage, citationsCount, doi, sourceIdentifier, PublishDate_idPublishDate, Journal_idJournal FROM Document;");
            rs = stat.executeQuery();
            while (rs.next()) {
                Integer documentID = rs.getInt("idDocument");
                newFactoryDAO.getDocumentDAO().addDocument(rs.getInt("idDocument"), rs.getString("title"), rs.getString("docAbstract"), rs.getString("type"), rs.getInt("citationsCount"), rs.getString("doi"), rs.getString("sourceIdentifier"), rs.getString("volume"), rs.getString("issue"), rs.getString("beginPage"), rs.getString("endPage"), false);
                Integer publishDateID = rs.getInt("PublishDate_idPublishDate");
                if (!rs.wasNull()) {
                    newFactoryDAO.getDocumentDAO().setPublishDate(documentID, publishDateID, false);
                }
                Integer journalId = rs.getInt("Journal_idJournal");
                if (rs.wasNull()) continue;
                newFactoryDAO.getDocumentDAO().setJournal(documentID, journalId, false);
            }
            rs.close();
            stat.close();
            System.out.println("Adding PublishDate to Period...");
            stat = conn.prepareStatement("Select PublishDate_idPublishDate, Period_idPeriod FROM PublishDate_Period;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getPublishDatePeriodDAO().addPublishDatePeriod(rs.getInt("Period_idPeriod"), rs.getInt("PublishDate_idPublishDate"), false);
            }
            rs.close();
            stat.close();
            System.out.println("Adding Journal To SubjectCategory...");
            stat = conn.prepareStatement("Select Journal_idJournal, SubjectCategory_idSubjectCategory, PublishDate_idPublishDate FROM Journal_SubjectCategory_PublishDate;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getJournalSubjectCategoryPublishDateDAO().addSubjectCategoryToJournal(rs.getInt("SubjectCategory_idSubjectCategory"), rs.getInt("Journal_idJournal"), rs.getInt("PublishDate_idPublishDate"), false);
            }
            rs.close();
            stat.close();
            System.out.println("Adding Document to Author...");
            stat = conn.prepareStatement("Select Author_idAuthor, Document_idDocument, position FROM Document_Author;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getDocumentAuthorDAO().addDocumentAuthor(rs.getInt("Document_idDocument"), rs.getInt("Author_idAuthor"), rs.getInt("position"), false);
            }
            rs.close();
            stat.close();
            System.out.println("Adding Document to Affiliation...");
            stat = conn.prepareStatement("Select Affiliation_idAffiliation, Document_idDocument FROM Document_Affiliation;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getDocumentAffiliationDAO().addDocumentAffiliation(rs.getInt("Document_idDocument"), rs.getInt("Affiliation_idAffiliation"), false);
            }
            rs.close();
            stat.close();
            System.out.println("Adding Document to Word...");
            stat = conn.prepareStatement("Select Document_idDocument, Word_idWord, isAuthorWord, isSourceWord, isAddedWord FROM Document_Word;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getDocumentWordDAO().addDocumentWord(rs.getInt("Document_idDocument"), rs.getInt("Word_idWord"), rs.getBoolean("isAuthorWord"), rs.getBoolean("isSourceWord"), rs.getBoolean("isAddedWord"), false);
            }
            rs.close();
            stat.close();
            System.out.println("Adding Document to Reference...");
            stat = conn.prepareStatement("Select Reference_idReference, Document_idDocument FROM Document_Reference;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getDocumentReferenceDAO().addDocumentReference(rs.getInt("Document_idDocument"), rs.getInt("Reference_idReference"), false);
            }
            rs.close();
            stat.close();
            System.out.println("Adding AuthorReference To Reference...");
            stat = conn.prepareStatement("Select AuthorReference_idAuthorReference, Reference_idReference, position FROM AuthorReference_Reference;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getAuthorReferenceReferenceDAO().addAuthorReferenceReference(rs.getInt("Reference_idReference"), rs.getInt("AuthorReference_idAuthorReference"), rs.getInt("position"), false);
            }
            rs.close();
            stat.close();
            System.out.println("Adding Author to Affiliation...");
            stat = conn.prepareStatement("Select Affiliation_idAffiliation, Author_idAuthor FROM Author_Affiliation;");
            rs = stat.executeQuery();
            while (rs.next()) {
                newFactoryDAO.getAuthorAffiliationDAO().addAuthorAffiliation(rs.getInt("Author_idAuthor"), rs.getInt("Affiliation_idAffiliation"), false);
            }
            rs.close();
            stat.close();
            newKnowledgeBaseManager.commit();
            newKnowledgeBaseManager.close();
            conn.close();
        }
        catch (SQLException sqle) {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                throw new KnowledgeBaseException(ex.getCause());
            }
            throw new KnowledgeBaseException(sqle.getCause());
        }
        catch (KnowledgeBaseException kbe) {
            newKnowledgeBaseManager.rollback();
            newKnowledgeBaseManager.close();
            throw kbe;
        }
    }
}

