/*
 * Decompiled with CFR 0.152.
 */
package scimat.model.statistic.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticDAO {
    private KnowledgeBaseManager kbm;
    private static final String __SELECT_AUTHORGROUPS_FREQ = "SELECT count(DISTINCT ag.idAuthorGroup) AS freq\nFROM Period p\n     LEFT OUTER JOIN PublishDate_Period pup ON p.idPeriod = pup.Period_idPeriod\n     LEFT OUTER JOIN PublishDate pu ON pup.PublishDate_idPublishDate = pu.idPublishDate\n     LEFT OUTER JOIN Document d ON pu.idPublishDate = d.PublishDate_idPublishDate\n     LEFT OUTER JOIN Document_Author da ON d.idDocument = da.Document_idDocument\n     LEFT OUTER JOIN Author a ON da.Author_idAuthor = a.idAuthor\n     LEFT OUTER JOIN AuthorGroup ag ON a.AuthorGroup_idAuthorGroup = ag.idAuthorGroup\n     WHERE p.idPeriod = ?\nGROUP BY p.idPeriod, d.idDocument;";
    private static final String __SELECT_UNIQUE_AUTHORGROUPS_COUNT = "SELECT count(DISTINCT ag.idAuthorGroup) AS count\nFROM Period p\n     LEFT OUTER JOIN PublishDate_Period pup ON p.idPeriod = pup.Period_idPeriod\n     LEFT OUTER JOIN PublishDate pu ON pup.PublishDate_idPublishDate = pu.idPublishDate\n     LEFT OUTER JOIN Document d ON pu.idPublishDate = d.PublishDate_idPublishDate\n     LEFT OUTER JOIN Document_Author da ON d.idDocument = da.Document_idDocument\n     LEFT OUTER JOIN Author a ON da.Author_idAuthor = a.idAuthor\n     LEFT OUTER JOIN AuthorGroup ag ON a.AuthorGroup_idAuthorGroup = ag.idAuthorGroup\n     WHERE p.idPeriod = ?\n;";
    private static final String __SELECT_REFERENCEGROUPS_FREQ = "SELECT count(DISTINCT rg.idReferenceGroup) AS freq\nFROM Period p\n     LEFT OUTER JOIN PublishDate_Period pup ON p.idPeriod = pup.Period_idPeriod\n     LEFT OUTER JOIN PublishDate pu ON pup.PublishDate_idPublishDate = pu.idPublishDate\n     LEFT OUTER JOIN Document d ON pu.idPublishDate = d.PublishDate_idPublishDate\n     LEFT OUTER JOIN Document_Reference dr ON d.idDocument = dr.Document_idDocument\n     LEFT OUTER JOIN Reference r ON dr.Reference_idReference = r.idReference\n     LEFT OUTER JOIN ReferenceGroup rg ON r.ReferenceGroup_idReferenceGroup = rg.idReferenceGroup\n     WHERE p.idPeriod = ?\nGROUP BY p.idPeriod, d.idDocument;";
    private static final String __SELECT_UNIQUE_REFERENCEGROUPS_COUNT = "SELECT count(DISTINCT rg.idReferenceGroup) AS freq\nFROM Period p\n     LEFT OUTER JOIN PublishDate_Period pup ON p.idPeriod = pup.Period_idPeriod\n     LEFT OUTER JOIN PublishDate pu ON pup.PublishDate_idPublishDate = pu.idPublishDate\n     LEFT OUTER JOIN Document d ON pu.idPublishDate = d.PublishDate_idPublishDate\n     LEFT OUTER JOIN Document_Reference dr ON d.idDocument = dr.Document_idDocument\n     LEFT OUTER JOIN Reference r ON dr.Reference_idReference = r.idReference\n     LEFT OUTER JOIN ReferenceGroup rg ON r.ReferenceGroup_idReferenceGroup = rg.idReferenceGroup\n     WHERE p.idPeriod = ?;";
    private static final String __SELECT_WORDGROUPS_FREQ = "SELECT count(DISTINCT wg.idWordGroup) AS freq\nFROM Period p\n     LEFT OUTER JOIN PublishDate_Period pup ON p.idPeriod = pup.Period_idPeriod\n     LEFT OUTER JOIN PublishDate pu ON pup.PublishDate_idPublishDate = pu.idPublishDate\n     LEFT OUTER JOIN Document d ON pu.idPublishDate = d.PublishDate_idPublishDate\n     LEFT OUTER JOIN Document_Word dw ON d.idDocument = dw.Document_idDocument\n     LEFT OUTER JOIN Word w ON dw.Word_idWord = w.idWord\n     LEFT OUTER JOIN WordGroup wg ON w.WordGroup_idWordGroup = wg.idWordGroup\n     WHERE p.idPeriod = ?\nGROUP BY p.idPeriod, d.idDocument;";
    private static final String __SELECT_UNIQUE_WORDGROUPS_COUNT = "SELECT count(DISTINCT wg.idWordGroup) AS count\nFROM Period p\n     LEFT OUTER JOIN PublishDate_Period pup ON p.idPeriod = pup.Period_idPeriod\n     LEFT OUTER JOIN PublishDate pu ON pup.PublishDate_idPublishDate = pu.idPublishDate\n     LEFT OUTER JOIN Document d ON pu.idPublishDate = d.PublishDate_idPublishDate\n     LEFT OUTER JOIN Document_Word dw ON d.idDocument = dw.Document_idDocument\n     LEFT OUTER JOIN Word w ON dw.Word_idWord = w.idWord\n     LEFT OUTER JOIN WordGroup wg ON w.WordGroup_idWordGroup = wg.idWordGroup\n     WHERE p.idPeriod = ?\n;";

    public StatisticDAO(KnowledgeBaseManager kbm) {
        this.kbm = kbm;
    }

    public ArrayList<Integer> getAuthorGroupsCountPerDocument(Integer periodID) throws KnowledgeBaseException {
        ArrayList<Integer> count = new ArrayList<Integer>();
        try {
            PreparedStatement stat = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORGROUPS_FREQ);
            stat.setInt(1, periodID);
            ResultSet rs = stat.executeQuery();
            while (rs.next()) {
                count.add(rs.getInt("freq"));
            }
            rs.close();
            stat.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return count;
    }

    public int getUniqueAuthorGroupsCount(Integer periodID) throws KnowledgeBaseException {
        int count = 0;
        try {
            PreparedStatement stat = this.kbm.getConnection().prepareStatement(__SELECT_UNIQUE_AUTHORGROUPS_COUNT);
            stat.setInt(1, periodID);
            ResultSet rs = stat.executeQuery();
            if (rs.next()) {
                count = rs.getInt("count");
            }
            rs.close();
            stat.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return count;
    }

    public ArrayList<Integer> getReferenceGroupsCountPerDocument(Integer periodID) throws KnowledgeBaseException {
        ArrayList<Integer> count = new ArrayList<Integer>();
        try {
            PreparedStatement stat = this.kbm.getConnection().prepareStatement(__SELECT_REFERENCEGROUPS_FREQ);
            stat.setInt(1, periodID);
            ResultSet rs = stat.executeQuery();
            while (rs.next()) {
                count.add(rs.getInt("freq"));
            }
            rs.close();
            stat.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return count;
    }

    public int getUniqueReferenceGroupsCount(Integer periodID) throws KnowledgeBaseException {
        int count = 0;
        try {
            PreparedStatement stat = this.kbm.getConnection().prepareStatement(__SELECT_UNIQUE_REFERENCEGROUPS_COUNT);
            stat.setInt(1, periodID);
            ResultSet rs = stat.executeQuery();
            if (rs.next()) {
                count = rs.getInt("count");
            }
            rs.close();
            stat.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return count;
    }

    public ArrayList<Integer> getWordGroupsCountPerDocument(Integer periodID) throws KnowledgeBaseException {
        ArrayList<Integer> count = new ArrayList<Integer>();
        try {
            PreparedStatement stat = this.kbm.getConnection().prepareStatement(__SELECT_WORDGROUPS_FREQ);
            stat.setInt(1, periodID);
            ResultSet rs = stat.executeQuery();
            while (rs.next()) {
                count.add(rs.getInt("freq"));
            }
            rs.close();
            stat.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return count;
    }

    public int getUniqueWordGroupsCount(Integer periodID) throws KnowledgeBaseException {
        int count = 0;
        try {
            PreparedStatement stat = this.kbm.getConnection().prepareStatement(__SELECT_UNIQUE_WORDGROUPS_COUNT);
            stat.setInt(1, periodID);
            ResultSet rs = stat.executeQuery();
            if (rs.next()) {
                count = rs.getInt("count");
            }
            rs.close();
            stat.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return count;
    }
}

