/*
 * Decompiled with CFR 0.152.
 */
package scimat.model.knowledgebase.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.knowledgebaseevents.event.add.AddWordEvent;
import scimat.knowledgebaseevents.event.add.AddWordWithoutGroupEvent;
import scimat.knowledgebaseevents.event.relation.DocumentRelationWordEvent;
import scimat.knowledgebaseevents.event.relation.WordGroupRelationWordEvent;
import scimat.knowledgebaseevents.event.remove.RemoveWordEvent;
import scimat.knowledgebaseevents.event.remove.RemoveWordWithoutGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateDocumentEvent;
import scimat.knowledgebaseevents.event.update.UpdateWordEvent;
import scimat.knowledgebaseevents.event.update.UpdateWordGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateWordWithoutGroupEvent;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.UtilsDAO;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.DocumentWord;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.entity.WordGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordDAO {
    private KnowledgeBaseManager kbm;
    private static final String __INSERT_WORD = "INSERT INTO Word(wordName) VALUES(?);";
    private static final String __INSERT_WORD_WITH_ID = "INSERT INTO Word(idWord,wordName) VALUES(?,?);";
    private static final String __REMOVE_WORD = "DELETE FROM Word WHERE idWord = ?;";
    private static final String __UPDATE_WORDNAME = "UPDATE Word SET wordName = ? WHERE idWord = ?;";
    private static final String __UPDATE_WORDGROUP = "UPDATE Word SET WordGroup_idWordGroup = ? WHERE idWord = ?;";
    private static final String __SELECT_WORDGROUP = "SELECT wg.* FROM Word w, WordGroup wg WHERE w.idWord = ? AND       w.WordGroup_idWordGroup = wg.idWordGroup;";
    private static final String __SELECT_DOCUMENT_WORD = "SELECT d.*, w.*, dw.isAuthorWord, dw.isSourceWord, dw.isAddedWord FROM Document_Word dw, Document d, Word w WHERE w.idWord = ? AND       w.idWord = dw.Word_idWord AND       dw.Document_idDocument = d.idDocument;";
    private static final String __SELECT_DOCUMENT = "SELECT d.* FROM Document_Word dw, Document d WHERE dw.Word_idWord = ? AND      dw.Document_idDocument = d.idDocument";
    private static final String __SELECT_DOCUMENT_ALL = "SELECT d.* FROM Document_Word dw, Document d WHERE dw.Word_idWord = ? AND      dw.Document_idDocument = d.idDocument;";
    private static final String __SELECT_WORD_BY_ID = "SELECT * FROM Word WHERE idWord = ?;";
    private static final String __SELECT_WORD_BY_NAME = "SELECT * FROM Word WHERE wordName = ?;";
    private static final String __SELECT_WORDS = "SELECT * FROM Word;";
    private static final String __SELECT_WORDS_WITHOUTGROUP = "SELECT * FROM Word WHERE WordGroup_idWordGroup IS NULL;";
    private static final String __CHECK_WORD_BY_ID = "SELECT idWord FROM Word WHERE idWord = ?;";
    private static final String __CHECK_WORD_BY_NAME = "SELECT idWord FROM Word WHERE wordName = ?;";
    private PreparedStatement statCheckById;
    private PreparedStatement statCheckByName;
    private PreparedStatement statAddWord;
    private PreparedStatement statAddWordWithId;
    private PreparedStatement statRemoveWord;
    private PreparedStatement statSelectDocumentAll;
    private PreparedStatement statSelectDocumentWord;
    private PreparedStatement statSelectWordGroup;
    private PreparedStatement statSelectWords;
    private PreparedStatement statSelectWordsWithoutGroup;
    private PreparedStatement statSelectWordById;
    private PreparedStatement statSelectWordByName;
    private PreparedStatement statUpdateWordGroup;
    private PreparedStatement statUpdateName;

    public WordDAO(KnowledgeBaseManager kbm) throws KnowledgeBaseException {
        this.kbm = kbm;
        try {
            this.statCheckById = this.kbm.getConnection().prepareStatement(__CHECK_WORD_BY_ID);
            this.statCheckByName = this.kbm.getConnection().prepareStatement(__CHECK_WORD_BY_NAME);
            this.statAddWord = this.kbm.getConnection().prepareStatement(__INSERT_WORD, 1);
            this.statAddWordWithId = this.kbm.getConnection().prepareStatement(__INSERT_WORD_WITH_ID);
            this.statRemoveWord = this.kbm.getConnection().prepareStatement(__REMOVE_WORD);
            this.statSelectDocumentAll = this.kbm.getConnection().prepareStatement(__SELECT_DOCUMENT_ALL);
            this.statSelectDocumentWord = this.kbm.getConnection().prepareStatement(__SELECT_DOCUMENT_WORD);
            this.statSelectWordGroup = this.kbm.getConnection().prepareStatement(__SELECT_WORDGROUP);
            this.statSelectWords = this.kbm.getConnection().prepareStatement(__SELECT_WORDS);
            this.statSelectWordsWithoutGroup = this.kbm.getConnection().prepareStatement(__SELECT_WORDS_WITHOUTGROUP);
            this.statSelectWordById = this.kbm.getConnection().prepareStatement(__SELECT_WORD_BY_ID);
            this.statSelectWordByName = this.kbm.getConnection().prepareStatement(__SELECT_WORD_BY_NAME);
            this.statUpdateWordGroup = this.kbm.getConnection().prepareStatement(__UPDATE_WORDGROUP);
            this.statUpdateName = this.kbm.getConnection().prepareStatement(__UPDATE_WORDNAME);
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public Integer addWord(String word, boolean notifyObservers) throws KnowledgeBaseException {
        Integer id;
        try {
            this.statAddWord.clearParameters();
            this.statAddWord.setString(1, word);
            if (this.statAddWord.executeUpdate() > 0) {
                id = this.statAddWord.getGeneratedKeys().getInt(1);
                this.statAddWord.getGeneratedKeys().close();
            } else {
                id = null;
            }
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddWordEvent(this.getWord(id)));
        }
        return id;
    }

    public boolean addWord(Integer wordID, String wordName, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statAddWordWithId.clearParameters();
            this.statAddWordWithId.setInt(1, wordID);
            this.statAddWordWithId.setString(2, wordName);
            result = this.statAddWordWithId.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddWordEvent(this.getWord(wordID)));
        }
        return result;
    }

    public boolean addWord(Word word, boolean notifyObservers) throws KnowledgeBaseException {
        return this.addWord(word.getWordID(), word.getWordName(), notifyObservers);
    }

    public boolean removeWord(Integer wordID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        Word word = null;
        WordGroup wordGroup = null;
        ArrayList<Document> documents = null;
        if (notifyObservers) {
            word = this.getWord(wordID);
            wordGroup = this.getWordGroup(wordID);
            documents = this.getDocuments(wordID);
        }
        try {
            this.statRemoveWord.clearParameters();
            this.statRemoveWord.setInt(1, wordID);
            result = this.statRemoveWord.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new RemoveWordEvent(word));
            if (wordGroup != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateWordGroupEvent(CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO().refreshWordGroup(wordGroup)));
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new WordGroupRelationWordEvent());
            } else {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new RemoveWordWithoutGroupEvent(word));
            }
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateDocumentEvent(CurrentProject.getInstance().getFactoryDAO().getDocumentDAO().refreshDocuments(documents)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new DocumentRelationWordEvent());
        }
        return result;
    }

    public Word getWord(Integer idWord) throws KnowledgeBaseException {
        Word word = null;
        try {
            this.statSelectWordById.clearParameters();
            this.statSelectWordById.setInt(1, idWord);
            ResultSet rs = this.statSelectWordById.executeQuery();
            if (rs.next()) {
                word = UtilsDAO.getInstance().getWord(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return word;
    }

    public Word getWord(String word) throws KnowledgeBaseException {
        Word w = null;
        try {
            this.statSelectWordByName.clearParameters();
            this.statSelectWordByName.setString(1, word);
            ResultSet rs = this.statSelectWordByName.executeQuery();
            if (rs.next()) {
                w = UtilsDAO.getInstance().getWord(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return w;
    }

    public ArrayList<Word> getWords() throws KnowledgeBaseException {
        ArrayList<Word> wordsList = new ArrayList<Word>();
        try {
            this.statSelectWords.clearParameters();
            ResultSet rs = this.statSelectWords.executeQuery();
            while (rs.next()) {
                wordsList.add(UtilsDAO.getInstance().getWord(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return wordsList;
    }

    public ArrayList<Word> getWordsWithoutGroup() throws KnowledgeBaseException {
        ArrayList<Word> wordsList = new ArrayList<Word>();
        try {
            this.statSelectWordsWithoutGroup.clearParameters();
            ResultSet rs = this.statSelectWordsWithoutGroup.executeQuery();
            while (rs.next()) {
                wordsList.add(UtilsDAO.getInstance().getWord(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return wordsList;
    }

    public boolean setWordName(Integer wordID, String wordName, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateName.clearParameters();
            this.statUpdateName.setString(1, wordName);
            this.statUpdateName.setInt(2, wordID);
            result = this.statUpdateName.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            Word word = this.getWord(wordID);
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateWordEvent(word));
            if (this.getWordGroup(wordID) == null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateWordWithoutGroupEvent(word));
            }
        }
        return result;
    }

    public boolean setWordGroup(Integer wordID, Integer wordGroupID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        WordGroup oldWordGroup = null;
        if (notifyObservers) {
            oldWordGroup = this.getWordGroup(wordID);
        }
        try {
            this.statUpdateWordGroup.clearParameters();
            if (wordGroupID != null) {
                this.statUpdateWordGroup.setInt(1, wordGroupID);
            } else {
                this.statUpdateWordGroup.setNull(1, 0);
            }
            this.statUpdateWordGroup.setInt(2, wordID);
            result = this.statUpdateWordGroup.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            if (oldWordGroup != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateWordGroupEvent(CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO().refreshWordGroup(oldWordGroup)));
                if (wordGroupID == null) {
                    KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddWordWithoutGroupEvent(this.getWord(wordID)));
                }
            } else if (wordGroupID != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new RemoveWordWithoutGroupEvent(this.getWord(wordID)));
            }
            if (wordGroupID != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateWordGroupEvent(this.getWordGroup(wordID)));
            }
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new WordGroupRelationWordEvent());
        }
        return result;
    }

    public WordGroup getWordGroup(Integer wordID) throws KnowledgeBaseException {
        WordGroup wordGroup = null;
        try {
            this.statSelectWordGroup.clearParameters();
            this.statSelectWordGroup.setInt(1, wordID);
            ResultSet rs = this.statSelectWordGroup.executeQuery();
            if (rs.next()) {
                wordGroup = UtilsDAO.getInstance().getWordGroup(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return wordGroup;
    }

    public ArrayList<DocumentWord> getDocumentWords(Integer documentID) throws KnowledgeBaseException {
        ArrayList<DocumentWord> wordsList = new ArrayList<DocumentWord>();
        try {
            this.statSelectDocumentWord.clearParameters();
            this.statSelectDocumentWord.setInt(1, documentID);
            ResultSet rs = this.statSelectDocumentWord.executeQuery();
            while (rs.next()) {
                wordsList.add(UtilsDAO.getInstance().getDocumentWord(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return wordsList;
    }

    public ArrayList<Document> getDocuments(Integer wordID, boolean isAuthorWord, boolean isSourceWord, boolean isAddedWord) throws KnowledgeBaseException {
        ArrayList<Document> wordsList = new ArrayList<Document>();
        try {
            String query = __SELECT_DOCUMENT;
            String optional = "";
            if (isAuthorWord) {
                optional = optional + "dw.isAuthorWord = 1";
            }
            if (isSourceWord) {
                optional = optional.isEmpty() ? optional + "dw.isSourceWord = 1" : optional + " OR dw.isSourceWord = 1";
            }
            if (isAddedWord) {
                optional = optional.isEmpty() ? optional + "dw.isAddedWord = 1" : optional + " OR dw.isAddedWord = 1";
            }
            query = optional.isEmpty() ? query + "" : query + " AND ( " + optional + ");";
            Statement stat = this.kbm.getConnection().createStatement();
            ResultSet rs = stat.executeQuery(query.replace("?", String.valueOf(wordID)));
            while (rs.next()) {
                wordsList.add(UtilsDAO.getInstance().getDocument(rs));
            }
            rs.close();
            stat.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return wordsList;
    }

    public ArrayList<Document> getDocuments(Integer wordID) throws KnowledgeBaseException {
        ArrayList<Document> wordsList = new ArrayList<Document>();
        try {
            this.statSelectDocumentAll.clearParameters();
            this.statSelectDocumentAll.setInt(1, wordID);
            ResultSet rs = this.statSelectDocumentAll.executeQuery();
            while (rs.next()) {
                wordsList.add(UtilsDAO.getInstance().getDocument(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return wordsList;
    }

    public boolean checkWord(String word) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckByName.clearParameters();
            this.statCheckByName.setString(1, word);
            ResultSet rs = this.statCheckByName.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public boolean checkWord(Integer idWord) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckById.clearParameters();
            this.statCheckById.setInt(1, idWord);
            ResultSet rs = this.statCheckById.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public ArrayList<Word> refreshWords(ArrayList<Word> wordsToRefresh) throws KnowledgeBaseException {
        ArrayList<Word> words = new ArrayList<Word>();
        int i = 0;
        if (!wordsToRefresh.isEmpty()) {
            String query = "SELECT * FROM Word WHERE idWord IN (" + wordsToRefresh.get(i).getWordID();
            for (i = 1; i < wordsToRefresh.size(); ++i) {
                query = query + ", " + wordsToRefresh.get(i).getWordID();
            }
            query = query + ");";
            try {
                Statement stat = this.kbm.getConnection().createStatement();
                ResultSet rs = stat.executeQuery(query);
                while (rs.next()) {
                    words.add(UtilsDAO.getInstance().getWord(rs));
                }
                rs.close();
                stat.close();
            }
            catch (SQLException e) {
                throw new KnowledgeBaseException(e.getMessage(), e.getCause());
            }
        }
        return words;
    }

    public Word refreshWord(Word wordToRefresh) throws KnowledgeBaseException {
        return this.getWord(wordToRefresh.getWordID());
    }
}

