/*
 * Decompiled with CFR 0.152.
 */
package scimat.model.knowledgebase.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.knowledgebaseevents.event.add.AddSubjectCategoryEvent;
import scimat.knowledgebaseevents.event.relation.JournalRelationSubjectCategoryRelationPublishDateEvent;
import scimat.knowledgebaseevents.event.remove.RemoveSubjectCategoryEvent;
import scimat.knowledgebaseevents.event.update.UpdateSubjectCategoryEvent;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.UtilsDAO;
import scimat.model.knowledgebase.entity.JournalSubjectCategoryPublishDate;
import scimat.model.knowledgebase.entity.SubjectCategory;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubjectCategoryDAO {
    private KnowledgeBaseManager kbm;
    private static final String __INSERT_SUBJECTCATEGORY = "INSERT INTO SubjectCategory(subjectCategoryName) VALUES(?);";
    private static final String __INSERT_SUBJECTCATEGORY_WITH_ID = "INSERT INTO SubjectCategory(idSubjectCategory,subjectCategoryName) VALUES(?,?);";
    private static final String __REMOVE_SUBJECTCATEGORY = "DELETE FROM SubjectCategory WHERE idSubjectCategory = ?;";
    private static final String __UPDATE_SUBJECTCATEGORYNAME = "UPDATE SubjectCategory SET subjectCategoryName = ? WHERE idSubjectCategory = ?;";
    private static final String __SELECT_JOURNAL_SUBJECTCATEGORY_PUBLISHDATE = "SELECT j.*, s.*, p.* FROM PublishDate p, Journal j, SubjectCategory s, Journal_SubjectCategory_PublishDate jsp WHERE s.idSubjectCategory = ? AND       j.idJournal = jsp.Journal_idJournal AND       jsp.SubjectCategory_idSubjectCategory = s.idSubjectCategory AND       jsp.PublishDate_idPublishDate = p.idPublishDate;";
    private static final String __SELECT_SUBJECTCATEGORY_BY_ID = "SELECT * FROM SubjectCategory WHERE idSubjectCategory = ?;";
    private static final String __SELECT_SUBJECTCATEGORY_BY_CATEGORYNAME = "SELECT * FROM SubjectCategory WHERE subjectCategoryName = ?;";
    private static final String __SELECT_SUBJECTCATEGORIES = "SELECT * FROM SubjectCategory;";
    private static final String __CHECK_SUBJECTCATEGORY_BY_CATEGORYNAME = "SELECT idSubjectCategory FROM SubjectCategory WHERE subjectCategoryName = ?;";
    private static final String __CHECK_SUBJECTCATEGORY_BY_ID = "SELECT idSubjectCategory FROM SubjectCategory WHERE idSubjectCategory = ?;";
    private PreparedStatement statCheckSubjectCategoryByCategoryName;
    private PreparedStatement statCheckSubjectCategoryById;
    private PreparedStatement statAddSubjectCategory;
    private PreparedStatement statAddSubjectCategoryWithId;
    private PreparedStatement statRemoveSubjectCategory;
    private PreparedStatement statSelectJournalSubjectCategoryPublishDate;
    private PreparedStatement statSelectSubjectCategories;
    private PreparedStatement statSelectSubjectCategoryByCategoryName;
    private PreparedStatement statSelectSubjectCategoryById;
    private PreparedStatement statUpdateCategoryName;

    public SubjectCategoryDAO(KnowledgeBaseManager kbm) throws KnowledgeBaseException {
        this.kbm = kbm;
        try {
            this.statCheckSubjectCategoryByCategoryName = this.kbm.getConnection().prepareStatement(__CHECK_SUBJECTCATEGORY_BY_CATEGORYNAME);
            this.statCheckSubjectCategoryById = this.kbm.getConnection().prepareStatement(__CHECK_SUBJECTCATEGORY_BY_ID);
            this.statAddSubjectCategory = this.kbm.getConnection().prepareStatement(__INSERT_SUBJECTCATEGORY, 1);
            this.statAddSubjectCategoryWithId = this.kbm.getConnection().prepareStatement(__INSERT_SUBJECTCATEGORY_WITH_ID);
            this.statRemoveSubjectCategory = this.kbm.getConnection().prepareStatement(__REMOVE_SUBJECTCATEGORY);
            this.statSelectJournalSubjectCategoryPublishDate = this.kbm.getConnection().prepareStatement(__SELECT_JOURNAL_SUBJECTCATEGORY_PUBLISHDATE);
            this.statSelectSubjectCategories = this.kbm.getConnection().prepareStatement(__SELECT_SUBJECTCATEGORIES);
            this.statSelectSubjectCategoryByCategoryName = this.kbm.getConnection().prepareStatement(__SELECT_SUBJECTCATEGORY_BY_CATEGORYNAME);
            this.statSelectSubjectCategoryById = this.kbm.getConnection().prepareStatement(__SELECT_SUBJECTCATEGORY_BY_ID);
            this.statUpdateCategoryName = this.kbm.getConnection().prepareStatement(__UPDATE_SUBJECTCATEGORYNAME);
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public Integer addSubjectCategory(String subjectCategoryName, boolean notifyObservers) throws KnowledgeBaseException {
        Integer id;
        try {
            this.statAddSubjectCategory.clearParameters();
            this.statAddSubjectCategory.setString(1, subjectCategoryName);
            if (this.statAddSubjectCategory.executeUpdate() == 1) {
                id = this.statAddSubjectCategory.getGeneratedKeys().getInt(1);
                this.statAddSubjectCategory.getGeneratedKeys().close();
            } else {
                id = null;
            }
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddSubjectCategoryEvent(this.getSubjectCategory(id)));
        }
        return id;
    }

    public boolean addSubjectCategory(Integer subjectCategoryID, String subjectCategoryName, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statAddSubjectCategoryWithId.clearParameters();
            this.statAddSubjectCategoryWithId.setInt(1, subjectCategoryID);
            this.statAddSubjectCategoryWithId.setString(2, subjectCategoryName);
            result = this.statAddSubjectCategoryWithId.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddSubjectCategoryEvent(this.getSubjectCategory(subjectCategoryID)));
        }
        return result;
    }

    public boolean addSubjectCategory(SubjectCategory subjectCategory, boolean notifyObservers) throws KnowledgeBaseException {
        return this.addSubjectCategory(subjectCategory.getSubjectCategoryID(), subjectCategory.getSubjectCategoryName(), notifyObservers);
    }

    public boolean removeSubjectCategory(Integer subjectCategoryID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        SubjectCategory subjectCategory = null;
        if (notifyObservers) {
            subjectCategory = this.getSubjectCategory(subjectCategoryID);
        }
        try {
            this.statRemoveSubjectCategory.clearParameters();
            this.statRemoveSubjectCategory.setInt(1, subjectCategoryID);
            result = this.statRemoveSubjectCategory.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new RemoveSubjectCategoryEvent(subjectCategory));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new JournalRelationSubjectCategoryRelationPublishDateEvent());
        }
        return result;
    }

    public SubjectCategory getSubjectCategory(Integer idSubjectCategory) throws KnowledgeBaseException {
        SubjectCategory subjectCategory = null;
        try {
            this.statSelectSubjectCategoryById.clearParameters();
            this.statSelectSubjectCategoryById.setInt(1, idSubjectCategory);
            ResultSet rs = this.statSelectSubjectCategoryById.executeQuery();
            if (rs.next()) {
                subjectCategory = UtilsDAO.getInstance().getSubjectCategory(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return subjectCategory;
    }

    public SubjectCategory getSubjectCategory(String subjectCategoryName) throws KnowledgeBaseException {
        SubjectCategory subjectCategory = null;
        try {
            this.statSelectSubjectCategoryByCategoryName.clearParameters();
            this.statSelectSubjectCategoryByCategoryName.setString(1, subjectCategoryName);
            ResultSet rs = this.statSelectSubjectCategoryByCategoryName.executeQuery();
            if (rs.next()) {
                subjectCategory = UtilsDAO.getInstance().getSubjectCategory(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return subjectCategory;
    }

    public ArrayList<SubjectCategory> getSubjectCategories() throws KnowledgeBaseException {
        ArrayList<SubjectCategory> subjectCategoriesList = new ArrayList<SubjectCategory>();
        try {
            this.statSelectSubjectCategories.clearParameters();
            ResultSet rs = this.statSelectSubjectCategories.executeQuery();
            while (rs.next()) {
                subjectCategoriesList.add(UtilsDAO.getInstance().getSubjectCategory(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return subjectCategoriesList;
    }

    public boolean setSubjectCategoryName(Integer subjectCategoryID, String subjectCategoryName, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateCategoryName.clearParameters();
            this.statUpdateCategoryName.setString(1, subjectCategoryName);
            this.statUpdateCategoryName.setInt(2, subjectCategoryID);
            result = this.statUpdateCategoryName.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateSubjectCategoryEvent(this.getSubjectCategory(subjectCategoryID)));
        }
        return result;
    }

    public ArrayList<JournalSubjectCategoryPublishDate> getJournals(Integer subjectCategoryID) throws KnowledgeBaseException {
        ArrayList<JournalSubjectCategoryPublishDate> jspList = new ArrayList<JournalSubjectCategoryPublishDate>();
        try {
            this.statSelectJournalSubjectCategoryPublishDate.clearParameters();
            this.statSelectJournalSubjectCategoryPublishDate.setInt(1, subjectCategoryID);
            ResultSet rs = this.statSelectJournalSubjectCategoryPublishDate.executeQuery();
            while (rs.next()) {
                jspList.add(UtilsDAO.getInstance().getJournalSubjectCategoryPublishDate(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return jspList;
    }

    public boolean checkSubjectCategory(String subjectCategoryName) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckSubjectCategoryByCategoryName.clearParameters();
            this.statCheckSubjectCategoryByCategoryName.setString(1, subjectCategoryName);
            ResultSet rs = this.statCheckSubjectCategoryByCategoryName.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public boolean checkSubjectCategory(Integer idSubjectCategory) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckSubjectCategoryById.clearParameters();
            this.statCheckSubjectCategoryById.setInt(1, idSubjectCategory);
            ResultSet rs = this.statCheckSubjectCategoryById.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public ArrayList<SubjectCategory> refreshSubjectCategorys(ArrayList<SubjectCategory> subjectCategoriesToRefresh) throws KnowledgeBaseException {
        ArrayList<SubjectCategory> subjectCategorys = new ArrayList<SubjectCategory>();
        int i = 0;
        if (!subjectCategoriesToRefresh.isEmpty()) {
            String query = "SELECT * FROM SubjectCategory WHERE idSubjectCategory IN (" + subjectCategoriesToRefresh.get(i).getSubjectCategoryID();
            for (i = 1; i < subjectCategoriesToRefresh.size(); ++i) {
                query = query + ", " + subjectCategoriesToRefresh.get(i).getSubjectCategoryID();
            }
            query = query + ");";
            try {
                Statement stat = this.kbm.getConnection().createStatement();
                ResultSet rs = stat.executeQuery(query);
                while (rs.next()) {
                    subjectCategorys.add(UtilsDAO.getInstance().getSubjectCategory(rs));
                }
                rs.close();
                stat.close();
            }
            catch (SQLException e) {
                throw new KnowledgeBaseException(e.getMessage(), e.getCause());
            }
        }
        return subjectCategorys;
    }

    public SubjectCategory refreshSubjectCategory(SubjectCategory subjectCategoryToRefresh) throws KnowledgeBaseException {
        return this.getSubjectCategory(subjectCategoryToRefresh.getSubjectCategoryID());
    }
}

