/*
 * Decompiled with CFR 0.152.
 */
package scimat.model.knowledgebase.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.knowledgebaseevents.event.add.AddReferenceSourceEvent;
import scimat.knowledgebaseevents.event.add.AddReferenceSourceWithoutGroupEvent;
import scimat.knowledgebaseevents.event.relation.ReferenceSourceGroupRelationReferenceSourceEvent;
import scimat.knowledgebaseevents.event.relation.ReferenceSourceRelationReferenceEvent;
import scimat.knowledgebaseevents.event.remove.RemoveReferenceSourceEvent;
import scimat.knowledgebaseevents.event.remove.RemoveReferenceSourceWithoutGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateReferenceSourceEvent;
import scimat.knowledgebaseevents.event.update.UpdateReferenceSourceGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateReferenceSourceWithoutGroupEvent;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.UtilsDAO;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.entity.ReferenceSourceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceSourceDAO {
    private KnowledgeBaseManager kbm;
    private static final String __INSERT_REFERENCESOURCE = "INSERT INTO ReferenceSource(source) VALUES(?);";
    private static final String __INSERT_REFERENCESOURCE_WITH_ID = "INSERT INTO ReferenceSource(idReferenceSource,source) VALUES(?,?);";
    private static final String __REMOVE_REFERENCESOURCE = "DELETE FROM ReferenceSource WHERE idReferenceSource = ?;";
    private static final String __UPDATE_SOURCE = "UPDATE ReferenceSource SET source = ? WHERE idReferenceSource = ?;";
    private static final String __UPDATE_REFERENCESOURCEGROUP = "UPDATE ReferenceSource SET ReferenceSourceGroup_idReferenceSourceGroup = ? WHERE idReferenceSource = ?;";
    private static final String __SELECT_REFERENCESOURCEGROUP = "SELECT rsg.* FROM ReferenceSource rs, ReferenceSourceGroup rsg WHERE rs.idReferenceSource = ? AND       rs.ReferenceSourceGroup_idReferenceSourceGroup = rsg.idReferenceSourceGroup;";
    private static final String __SELECT_REFERENCES = "SELECT r.* FROM ReferenceSource rs, Reference r WHERE rs.idReferenceSource = ? AND       rs.idReferenceSource = r.ReferenceSource_idReferenceSource;";
    private static final String __SELECT_REFERENCESOURCE_BY_ID = "SELECT * FROM ReferenceSource WHERE idReferenceSource = ?;";
    private static final String __SELECT_REFERENCESOURCE_BY_SOURCE = "SELECT * FROM ReferenceSource WHERE source = ?;";
    private static final String __SELECT_REFERENCESOURCES = "SELECT * FROM ReferenceSource;";
    private static final String __SELECT_REFERENCESOURCES_WITHOUT_GROUP = "SELECT * FROM ReferenceSource WHERE ReferenceSourceGroup_idReferenceSourceGroup IS NULL;";
    private static final String __CHECK_REFERENCESOURCE_BY_SOURCE = "SELECT idReferenceSource FROM ReferenceSource WHERE source = ?;";
    private static final String __CHECK_REFERENCESOURCE_BY_ID = "SELECT idReferenceSource FROM ReferenceSource WHERE idReferenceSource = ?;";
    private PreparedStatement statCheckReferenceSourceById;
    private PreparedStatement statCheckReferenceSourceBySource;
    private PreparedStatement statAddReferenceSource;
    private PreparedStatement statAddReferenceSourceWithId;
    private PreparedStatement statRemoveReferenceSource;
    private PreparedStatement statSelectReferences;
    private PreparedStatement statSelectReferenceSourceGroup;
    private PreparedStatement statSelectReferenceSources;
    private PreparedStatement statSelectReferenceSourcesWithoutGroup;
    private PreparedStatement statSelectReferenceSourceById;
    private PreparedStatement statSelectReferenceSourceBySource;
    private PreparedStatement statUpdateReferenceSourceGroup;
    private PreparedStatement statUpdateSource;

    public ReferenceSourceDAO(KnowledgeBaseManager kbm) throws KnowledgeBaseException {
        this.kbm = kbm;
        try {
            this.statCheckReferenceSourceById = this.kbm.getConnection().prepareStatement(__CHECK_REFERENCESOURCE_BY_ID);
            this.statCheckReferenceSourceBySource = this.kbm.getConnection().prepareStatement(__CHECK_REFERENCESOURCE_BY_SOURCE);
            this.statAddReferenceSource = this.kbm.getConnection().prepareStatement(__INSERT_REFERENCESOURCE, 1);
            this.statAddReferenceSourceWithId = this.kbm.getConnection().prepareStatement(__INSERT_REFERENCESOURCE_WITH_ID);
            this.statRemoveReferenceSource = this.kbm.getConnection().prepareStatement(__REMOVE_REFERENCESOURCE);
            this.statSelectReferences = this.kbm.getConnection().prepareStatement(__SELECT_REFERENCES);
            this.statSelectReferenceSourceGroup = this.kbm.getConnection().prepareStatement(__SELECT_REFERENCESOURCEGROUP);
            this.statSelectReferenceSources = this.kbm.getConnection().prepareStatement(__SELECT_REFERENCESOURCES);
            this.statSelectReferenceSourcesWithoutGroup = this.kbm.getConnection().prepareStatement(__SELECT_REFERENCESOURCES_WITHOUT_GROUP);
            this.statSelectReferenceSourceById = this.kbm.getConnection().prepareStatement(__SELECT_REFERENCESOURCE_BY_ID);
            this.statSelectReferenceSourceBySource = this.kbm.getConnection().prepareStatement(__SELECT_REFERENCESOURCE_BY_SOURCE);
            this.statUpdateReferenceSourceGroup = this.kbm.getConnection().prepareStatement(__UPDATE_REFERENCESOURCEGROUP);
            this.statUpdateSource = this.kbm.getConnection().prepareStatement(__UPDATE_SOURCE);
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public Integer addReferenceSource(String source, boolean notifyObservers) throws KnowledgeBaseException {
        Integer id;
        try {
            this.statAddReferenceSource.clearParameters();
            this.statAddReferenceSource.setString(1, source);
            if (this.statAddReferenceSource.executeUpdate() == 1) {
                id = this.statAddReferenceSource.getGeneratedKeys().getInt(1);
                this.statAddReferenceSource.getGeneratedKeys().close();
            } else {
                id = null;
            }
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddReferenceSourceEvent(this.getReferenceSource(id)));
        }
        return id;
    }

    public boolean addReferenceSource(Integer referenceSourceID, String source, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statAddReferenceSourceWithId.clearParameters();
            this.statAddReferenceSourceWithId.setInt(1, referenceSourceID);
            this.statAddReferenceSourceWithId.setString(2, source);
            result = this.statAddReferenceSourceWithId.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddReferenceSourceEvent(this.getReferenceSource(referenceSourceID)));
        }
        return result;
    }

    public boolean addReferenceSource(ReferenceSource referenceSource, boolean notifyObservers) throws KnowledgeBaseException {
        return this.addReferenceSource(referenceSource.getReferenceSourceID(), referenceSource.getSource(), notifyObservers);
    }

    public boolean removeReferenceSource(Integer referenceSourceID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        ReferenceSource referenceSource = null;
        ReferenceSourceGroup referenceSourceGroup = null;
        if (notifyObservers) {
            referenceSource = this.getReferenceSource(referenceSourceID);
            referenceSourceGroup = this.getReferenceSourceGroup(referenceSourceID);
        }
        try {
            this.statRemoveReferenceSource.clearParameters();
            this.statRemoveReferenceSource.setInt(1, referenceSourceID);
            result = this.statRemoveReferenceSource.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new RemoveReferenceSourceEvent(referenceSource));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new ReferenceSourceRelationReferenceEvent());
            if (referenceSourceGroup != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceSourceGroupEvent(CurrentProject.getInstance().getFactoryDAO().getReferenceSourceGroupDAO().refreshReferenceSourceGroup(referenceSourceGroup)));
            } else {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new RemoveReferenceSourceWithoutGroupEvent(referenceSource));
            }
        }
        return result;
    }

    public ReferenceSource getReferenceSource(Integer idReferenceSource) throws KnowledgeBaseException {
        ReferenceSource referenceSource = null;
        try {
            this.statSelectReferenceSourceById.clearParameters();
            this.statSelectReferenceSourceById.setInt(1, idReferenceSource);
            ResultSet rs = this.statSelectReferenceSourceById.executeQuery();
            if (rs.next()) {
                referenceSource = UtilsDAO.getInstance().getReferenceSource(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return referenceSource;
    }

    public ReferenceSource getReferenceSource(String source) throws KnowledgeBaseException {
        ReferenceSource referenceSource = null;
        try {
            this.statSelectReferenceSourceBySource.clearParameters();
            this.statSelectReferenceSourceBySource.setString(1, source);
            ResultSet rs = this.statSelectReferenceSourceBySource.executeQuery();
            if (rs.next()) {
                referenceSource = UtilsDAO.getInstance().getReferenceSource(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return referenceSource;
    }

    public ArrayList<ReferenceSource> getReferenceSources() throws KnowledgeBaseException {
        ArrayList<ReferenceSource> referenceSourceList = new ArrayList<ReferenceSource>();
        try {
            this.statSelectReferenceSources.clearParameters();
            ResultSet rs = this.statSelectReferenceSources.executeQuery();
            while (rs.next()) {
                referenceSourceList.add(UtilsDAO.getInstance().getReferenceSource(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return referenceSourceList;
    }

    public ArrayList<ReferenceSource> getReferenceSourcesWithoutGroup() throws KnowledgeBaseException {
        ArrayList<ReferenceSource> referenceSourceList = new ArrayList<ReferenceSource>();
        try {
            this.statSelectReferenceSourcesWithoutGroup.clearParameters();
            ResultSet rs = this.statSelectReferenceSourcesWithoutGroup.executeQuery();
            while (rs.next()) {
                referenceSourceList.add(UtilsDAO.getInstance().getReferenceSource(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return referenceSourceList;
    }

    public boolean setSource(Integer referenceSourceID, String source, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateSource.clearParameters();
            this.statUpdateSource.setString(1, source);
            this.statUpdateSource.setInt(2, referenceSourceID);
            result = this.statUpdateSource.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            ReferenceSource referenceSource = this.getReferenceSource(referenceSourceID);
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceSourceEvent(referenceSource));
            if (this.getReferenceSourceGroup(referenceSourceID) == null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceSourceWithoutGroupEvent(referenceSource));
            }
        }
        return result;
    }

    public boolean setReferenceSourceGroup(Integer referenceSourceID, Integer referenceSourceGroupID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        ReferenceSourceGroup oldReferenceSourceGroup = null;
        if (notifyObservers) {
            oldReferenceSourceGroup = this.getReferenceSourceGroup(referenceSourceID);
        }
        try {
            this.statUpdateReferenceSourceGroup.clearParameters();
            if (referenceSourceGroupID != null) {
                this.statUpdateReferenceSourceGroup.setInt(1, referenceSourceGroupID);
            } else {
                this.statUpdateReferenceSourceGroup.setNull(1, 0);
            }
            this.statUpdateReferenceSourceGroup.setInt(2, referenceSourceID);
            result = this.statUpdateReferenceSourceGroup.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            if (oldReferenceSourceGroup != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceSourceGroupEvent(CurrentProject.getInstance().getFactoryDAO().getReferenceSourceGroupDAO().refreshReferenceSourceGroup(oldReferenceSourceGroup)));
                if (referenceSourceGroupID == null) {
                    KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddReferenceSourceWithoutGroupEvent(this.getReferenceSource(referenceSourceID)));
                }
            } else if (referenceSourceGroupID != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new RemoveReferenceSourceWithoutGroupEvent(this.getReferenceSource(referenceSourceID)));
            }
            if (referenceSourceGroupID != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceSourceGroupEvent(this.getReferenceSourceGroup(referenceSourceID)));
            }
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new ReferenceSourceGroupRelationReferenceSourceEvent());
        }
        return result;
    }

    public ReferenceSourceGroup getReferenceSourceGroup(Integer referenceSourceID) throws KnowledgeBaseException {
        ReferenceSourceGroup referenceSourceGroup = null;
        try {
            this.statSelectReferenceSourceGroup.clearParameters();
            this.statSelectReferenceSourceGroup.setInt(1, referenceSourceID);
            ResultSet rs = this.statSelectReferenceSourceGroup.executeQuery();
            if (rs.next()) {
                referenceSourceGroup = UtilsDAO.getInstance().getReferenceSourceGroup(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return referenceSourceGroup;
    }

    public ArrayList<Reference> getReferences(Integer referenceSourceID) throws KnowledgeBaseException {
        ArrayList<Reference> referenceList = new ArrayList<Reference>();
        try {
            this.statSelectReferences.clearParameters();
            this.statSelectReferences.setInt(1, referenceSourceID);
            ResultSet rs = this.statSelectReferences.executeQuery();
            while (rs.next()) {
                referenceList.add(UtilsDAO.getInstance().getReference(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return referenceList;
    }

    public boolean checkReferenceSource(String source) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckReferenceSourceBySource.clearParameters();
            this.statCheckReferenceSourceBySource.setString(1, source);
            ResultSet rs = this.statCheckReferenceSourceBySource.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public boolean checkReferenceSource(Integer idReferenceSource) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckReferenceSourceById.clearParameters();
            this.statCheckReferenceSourceById.setInt(1, idReferenceSource);
            ResultSet rs = this.statCheckReferenceSourceById.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public ArrayList<ReferenceSource> refreshReferenceSources(ArrayList<ReferenceSource> referenceSourcesToRefresh) throws KnowledgeBaseException {
        ArrayList<ReferenceSource> referenceSources = new ArrayList<ReferenceSource>();
        int i = 0;
        if (!referenceSourcesToRefresh.isEmpty()) {
            String query = "SELECT * FROM ReferenceSource WHERE idReferenceSource IN (" + referenceSourcesToRefresh.get(i).getReferenceSourceID();
            for (i = 1; i < referenceSourcesToRefresh.size(); ++i) {
                query = query + ", " + referenceSourcesToRefresh.get(i).getReferenceSourceID();
            }
            query = query + ");";
            try {
                Statement stat = this.kbm.getConnection().createStatement();
                ResultSet rs = stat.executeQuery(query);
                while (rs.next()) {
                    referenceSources.add(UtilsDAO.getInstance().getReferenceSource(rs));
                }
                rs.close();
                stat.close();
            }
            catch (SQLException e) {
                throw new KnowledgeBaseException(e.getMessage(), e.getCause());
            }
        }
        return referenceSources;
    }

    public ReferenceSource refreshReferenceSource(ReferenceSource referenceSourceToRefresh) throws KnowledgeBaseException {
        return this.getReferenceSource(referenceSourceToRefresh.getReferenceSourceID());
    }
}

