/*
 * Decompiled with CFR 0.152.
 */
package scimat.model.knowledgebase.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.knowledgebaseevents.event.add.AddReferenceGroupEvent;
import scimat.knowledgebaseevents.event.relation.ReferenceGroupRelationReferenceEvent;
import scimat.knowledgebaseevents.event.remove.RemoveReferenceGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateReferenceGroupEvent;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.UtilsDAO;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.ReferenceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceGroupDAO {
    private KnowledgeBaseManager kbm;
    private static final String __INSERT_REFERENCEGROUP = "INSERT INTO ReferenceGroup(groupName,stopGroup) VALUES(?,?);";
    private static final String __INSERT_REFERENCEGROUP_WITH_ID = "INSERT INTO ReferenceGroup(idReferenceGroup,groupName,stopGroup) VALUES(?,?,?);";
    private static final String __REMOVE_REFERENCEGROUP = "DELETE FROM ReferenceGroup WHERE idReferenceGroup = ?;";
    private static final String __UPDATE_GROUPNAME = "UPDATE ReferenceGroup SET groupName = ? WHERE idReferenceGroup = ?;";
    private static final String __UPDATE_STOPGROUP = "UPDATE ReferenceGroup SET stopGroup = ? WHERE idReferenceGroup = ?;";
    private static final String __UPDATE_REFERENCEGROUP = "UPDATE ReferenceGroup SET groupName = ?,     stopGroup = ? WHERE idReferenceGroup = ?;";
    private static final String __SELECT_REFERENCES = "SELECT r.* FROM Reference r, ReferenceGroup rg WHERE rg.idReferenceGroup = ? AND       r.ReferenceGroup_idReferenceGroup = rg.idReferenceGroup;";
    private static final String __SELECT_REFERENCEGROUP_BY_ID = "SELECT * FROM ReferenceGroup WHERE idReferenceGroup = ?;";
    private static final String __SELECT_REFERENCEGROUP_BY_NAME = "SELECT * FROM ReferenceGroup WHERE groupName = ?;";
    private static final String __SELECT_REFERENCEGROUP_BY_STOPGROUP = "SELECT * FROM ReferenceGroup WHERE stopGroup = ?;";
    private static final String __SELECT_REFERENCEGROUPS = "SELECT * FROM ReferenceGroup;";
    private static final String __CHECK_REFERENCEGROUP_BY_NAME = "SELECT idReferenceGroup FROM ReferenceGroup WHERE groupName = ?;";
    private static final String __CHECK_REFERENCEGROUP_BY_ID = "SELECT idReferenceGroup FROM ReferenceGroup WHERE idReferenceGroup = ?;";
    private PreparedStatement statCheckReferenceGroupByName;
    private PreparedStatement statCheckReferenceGroupById;
    private PreparedStatement statAddReferenceGroup;
    private PreparedStatement statAddReferenceGroupWithId;
    private PreparedStatement statRemoveReferenceGroup;
    private PreparedStatement statSelectReferences;
    private PreparedStatement statSelectReferenceGroups;
    private PreparedStatement statSelectReferenceGroupById;
    private PreparedStatement statSelectReferenceGroupByName;
    private PreparedStatement statSelectReferenceGroupByStopGroup;
    private PreparedStatement statUpdateGroupName;
    private PreparedStatement statUpdateReferenceGroup;
    private PreparedStatement statUpdateStopGroup;

    public ReferenceGroupDAO(KnowledgeBaseManager kbm) throws KnowledgeBaseException {
        this.kbm = kbm;
        try {
            this.statCheckReferenceGroupByName = this.kbm.getConnection().prepareStatement(__CHECK_REFERENCEGROUP_BY_NAME);
            this.statCheckReferenceGroupById = this.kbm.getConnection().prepareStatement(__CHECK_REFERENCEGROUP_BY_ID);
            this.statAddReferenceGroup = this.kbm.getConnection().prepareStatement(__INSERT_REFERENCEGROUP, 1);
            this.statAddReferenceGroupWithId = this.kbm.getConnection().prepareStatement(__INSERT_REFERENCEGROUP_WITH_ID);
            this.statRemoveReferenceGroup = this.kbm.getConnection().prepareStatement(__REMOVE_REFERENCEGROUP);
            this.statSelectReferences = this.kbm.getConnection().prepareStatement(__SELECT_REFERENCES);
            this.statSelectReferenceGroups = this.kbm.getConnection().prepareStatement(__SELECT_REFERENCEGROUPS);
            this.statSelectReferenceGroupById = this.kbm.getConnection().prepareStatement(__SELECT_REFERENCEGROUP_BY_ID);
            this.statSelectReferenceGroupByName = this.kbm.getConnection().prepareStatement(__SELECT_REFERENCEGROUP_BY_NAME);
            this.statSelectReferenceGroupByStopGroup = this.kbm.getConnection().prepareStatement(__SELECT_REFERENCEGROUP_BY_STOPGROUP);
            this.statUpdateGroupName = this.kbm.getConnection().prepareStatement(__UPDATE_GROUPNAME);
            this.statUpdateReferenceGroup = this.kbm.getConnection().prepareStatement(__UPDATE_REFERENCEGROUP);
            this.statUpdateStopGroup = this.kbm.getConnection().prepareStatement(__UPDATE_STOPGROUP);
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public Integer addReferenceGroup(String groupName, boolean stopGroup, boolean notifyObservers) throws KnowledgeBaseException {
        Integer id;
        try {
            this.statAddReferenceGroup.clearParameters();
            this.statAddReferenceGroup.setString(1, groupName);
            this.statAddReferenceGroup.setBoolean(2, stopGroup);
            if (this.statAddReferenceGroup.executeUpdate() == 1) {
                id = this.statAddReferenceGroup.getGeneratedKeys().getInt(1);
                this.statAddReferenceGroup.getGeneratedKeys().close();
            } else {
                id = null;
            }
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddReferenceGroupEvent(this.getReferenceGroup(id)));
        }
        return id;
    }

    public boolean addReferenceGroup(Integer referenceGroupID, String groupName, boolean stopGroup, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statAddReferenceGroupWithId.clearParameters();
            this.statAddReferenceGroupWithId.setInt(1, referenceGroupID);
            this.statAddReferenceGroupWithId.setString(2, groupName);
            this.statAddReferenceGroupWithId.setBoolean(3, stopGroup);
            result = this.statAddReferenceGroupWithId.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddReferenceGroupEvent(this.getReferenceGroup(referenceGroupID)));
        }
        return result;
    }

    public boolean addReferenceGroup(ReferenceGroup referenceGroup, boolean notifyObservers) throws KnowledgeBaseException {
        return this.addReferenceGroup(referenceGroup.getReferenceGroupID(), referenceGroup.getGroupName(), referenceGroup.isStopGroup(), notifyObservers);
    }

    public boolean removeReferenceGroup(Integer referenceGroupID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        ReferenceGroup referenceGroup = null;
        if (notifyObservers) {
            referenceGroup = this.getReferenceGroup(referenceGroupID);
        }
        try {
            this.statRemoveReferenceGroup.clearParameters();
            this.statRemoveReferenceGroup.setInt(1, referenceGroupID);
            result = this.statRemoveReferenceGroup.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new RemoveReferenceGroupEvent(referenceGroup));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new ReferenceGroupRelationReferenceEvent());
        }
        return result;
    }

    public ReferenceGroup getReferenceGroup(Integer idReferenceGroup) throws KnowledgeBaseException {
        ReferenceGroup referenceGroup = null;
        try {
            this.statSelectReferenceGroupById.clearParameters();
            this.statSelectReferenceGroupById.setInt(1, idReferenceGroup);
            ResultSet rs = this.statSelectReferenceGroupById.executeQuery();
            if (rs.next()) {
                referenceGroup = UtilsDAO.getInstance().getReferenceGroup(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return referenceGroup;
    }

    public ReferenceGroup getReferenceGroup(String groupName) throws KnowledgeBaseException {
        ReferenceGroup referenceGroup = null;
        try {
            this.statSelectReferenceGroupByName.clearParameters();
            this.statSelectReferenceGroupByName.setString(1, groupName);
            ResultSet rs = this.statSelectReferenceGroupByName.executeQuery();
            if (rs.next()) {
                referenceGroup = UtilsDAO.getInstance().getReferenceGroup(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return referenceGroup;
    }

    public ArrayList<ReferenceGroup> getReferenceGroups(boolean stopGroup) throws KnowledgeBaseException {
        ArrayList<ReferenceGroup> referenceGroupList = new ArrayList<ReferenceGroup>();
        ReferenceGroup referenceGroup = null;
        try {
            this.statSelectReferenceGroupByStopGroup.clearParameters();
            this.statSelectReferenceGroupByStopGroup.setBoolean(1, stopGroup);
            ResultSet rs = this.statSelectReferenceGroupByStopGroup.executeQuery();
            while (rs.next()) {
                referenceGroup = UtilsDAO.getInstance().getReferenceGroup(rs);
                referenceGroupList.add(referenceGroup);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return referenceGroupList;
    }

    public ArrayList<ReferenceGroup> getReferenceGroups() throws KnowledgeBaseException {
        ArrayList<ReferenceGroup> referenceGroupList = new ArrayList<ReferenceGroup>();
        ReferenceGroup referenceGroup = null;
        try {
            this.statSelectReferenceGroups.clearParameters();
            ResultSet rs = this.statSelectReferenceGroups.executeQuery();
            while (rs.next()) {
                referenceGroup = UtilsDAO.getInstance().getReferenceGroup(rs);
                referenceGroupList.add(referenceGroup);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return referenceGroupList;
    }

    public boolean setGroupName(Integer referenceGroupID, String goupName, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateGroupName.clearParameters();
            this.statUpdateGroupName.setString(1, goupName);
            this.statUpdateGroupName.setInt(2, referenceGroupID);
            result = this.statUpdateGroupName.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceGroupEvent(this.getReferenceGroup(referenceGroupID)));
        }
        return result;
    }

    public boolean setStopGroup(Integer referenceGroupID, boolean stopGroup, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateStopGroup.clearParameters();
            this.statUpdateStopGroup.setBoolean(1, stopGroup);
            this.statUpdateStopGroup.setInt(2, referenceGroupID);
            result = this.statUpdateStopGroup.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceGroupEvent(this.getReferenceGroup(referenceGroupID)));
        }
        return result;
    }

    public boolean updateReferenceGroup(Integer referenceGroupID, String groupName, boolean stopGroup, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateReferenceGroup.clearParameters();
            this.statUpdateReferenceGroup.setString(1, groupName);
            this.statUpdateReferenceGroup.setBoolean(2, stopGroup);
            this.statUpdateReferenceGroup.setInt(3, referenceGroupID);
            result = this.statUpdateReferenceGroup.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceGroupEvent(this.getReferenceGroup(referenceGroupID)));
        }
        return result;
    }

    public ArrayList<Reference> getReferences(Integer referenceGroupID) throws KnowledgeBaseException {
        ArrayList<Reference> referencesList = new ArrayList<Reference>();
        try {
            this.statSelectReferences.clearParameters();
            this.statSelectReferences.setInt(1, referenceGroupID);
            ResultSet rs = this.statSelectReferences.executeQuery();
            while (rs.next()) {
                referencesList.add(UtilsDAO.getInstance().getReference(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return referencesList;
    }

    public boolean checkReferenceGroup(String groupName) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckReferenceGroupByName.clearParameters();
            this.statCheckReferenceGroupByName.setString(1, groupName);
            ResultSet rs = this.statCheckReferenceGroupByName.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public boolean checkReferenceGroup(Integer idReferenceGroup) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckReferenceGroupById.clearParameters();
            this.statCheckReferenceGroupById.setInt(1, idReferenceGroup);
            ResultSet rs = this.statCheckReferenceGroupById.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public ArrayList<ReferenceGroup> refreshReferenceGroups(ArrayList<ReferenceGroup> referenceGroupsToRefresh) throws KnowledgeBaseException {
        ArrayList<ReferenceGroup> referenceGroups = new ArrayList<ReferenceGroup>();
        int i = 0;
        if (!referenceGroupsToRefresh.isEmpty()) {
            String query = "SELECT * FROM ReferenceGroup WHERE idReferenceGroup IN (" + referenceGroupsToRefresh.get(i).getReferenceGroupID();
            for (i = 1; i < referenceGroupsToRefresh.size(); ++i) {
                query = query + ", " + referenceGroupsToRefresh.get(i).getReferenceGroupID();
            }
            query = query + ");";
            try {
                Statement stat = this.kbm.getConnection().createStatement();
                ResultSet rs = stat.executeQuery(query);
                while (rs.next()) {
                    referenceGroups.add(UtilsDAO.getInstance().getReferenceGroup(rs));
                }
                rs.close();
                stat.close();
            }
            catch (SQLException e) {
                throw new KnowledgeBaseException(e.getMessage(), e.getCause());
            }
        }
        return referenceGroups;
    }

    public ReferenceGroup refreshReferenceGroup(ReferenceGroup referenceGroupToRefresh) throws KnowledgeBaseException {
        return this.getReferenceGroup(referenceGroupToRefresh.getReferenceGroupID());
    }
}

