/*
 * Decompiled with CFR 0.152.
 */
package scimat.model.knowledgebase.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.TreeSet;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.knowledgebaseevents.event.add.AddReferenceEvent;
import scimat.knowledgebaseevents.event.add.AddReferenceWithoutGroupEvent;
import scimat.knowledgebaseevents.event.relation.DocumentRelationReferenceEvent;
import scimat.knowledgebaseevents.event.relation.ReferenceGroupRelationReferenceEvent;
import scimat.knowledgebaseevents.event.relation.ReferenceRelationAuthorReferenceEvent;
import scimat.knowledgebaseevents.event.relation.ReferenceSourceRelationReferenceEvent;
import scimat.knowledgebaseevents.event.remove.RemoveReferenceEvent;
import scimat.knowledgebaseevents.event.remove.RemoveReferenceWithoutGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateAuthorReferenceEvent;
import scimat.knowledgebaseevents.event.update.UpdateAuthorReferenceGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateAuthorReferenceWithoutGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateDocumentEvent;
import scimat.knowledgebaseevents.event.update.UpdateReferenceEvent;
import scimat.knowledgebaseevents.event.update.UpdateReferenceGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateReferenceSourceEvent;
import scimat.knowledgebaseevents.event.update.UpdateReferenceSourceGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateReferenceSourceWithoutGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateReferenceWithoutGroupEvent;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.ReferenceSourceDAO;
import scimat.model.knowledgebase.dao.UtilsDAO;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.entity.AuthorReferenceGroup;
import scimat.model.knowledgebase.entity.AuthorReferenceReference;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.ReferenceGroup;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.entity.ReferenceSourceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceDAO {
    private KnowledgeBaseManager kbm;
    private static final String __INSERT_REFERENCE = "INSERT INTO Reference(fullReference,volume,issue,page,year,doi,format) VALUES(?,?,?,?,?,?,?);";
    private static final String __INSERT_REFERENCE_WITH_ID = "INSERT INTO Reference(idReference,fullReference,volume,issue,page,year,doi,format) VALUES(?,?,?,?,?,?,?,?);";
    private static final String __REMOVE_REFERENCE = "DELETE FROM Reference WHERE idReference = ?;";
    private static final String __UPDATE_FULLREFERENCE = "UPDATE Reference SET fullReference = ? WHERE idReference = ?;";
    private static final String __UPDATE_VOLUME = "UPDATE Reference SET volume = ? WHERE idReference = ?;";
    private static final String __UPDATE_ISSUE = "UPDATE Reference SET issue = ? WHERE idReference = ?;";
    private static final String __UPDATE_PAGE = "UPDATE Reference SET page = ? WHERE idReference = ?;";
    private static final String __UPDATE_DOI = "UPDATE Reference SET doi = ? WHERE idReference = ?;";
    private static final String __UPDATE_FORMAT = "UPDATE Reference SET format = ? WHERE idReference = ?;";
    private static final String __UPDATE_YEAR = "UPDATE Reference SET year = ? WHERE idReference = ?;";
    private static final String __UPDATE_REFERENCE = "UPDATE Reference SET fullReference = ?,     volume = ?,     issue = ?,     page = ?,     year = ?,     doi = ?,     format = ? WHERE idReference = ?;";
    private static final String __UPDATE_REFERENCEGROUP = "UPDATE Reference SET ReferenceGroup_idReferenceGroup = ? WHERE idReference = ?;";
    private static final String __UPDATE_REFERENCESOURCE = "UPDATE Reference SET ReferenceSource_idReferenceSource = ? WHERE idReference = ?;";
    private static final String __SELECT_REFERENCEGROUP = "SELECT rg.* FROM Reference r, ReferenceGroup rg WHERE r.idReference = ? AND r.ReferenceGroup_idReferenceGroup = rg.idReferenceGroup;";
    private static final String __SELECT_REFERENCESOURCE = "SELECT rs.* FROM Reference r, ReferenceSource rs WHERE r.idReference = ? AND r.ReferenceSource_idReferenceSource = rs.idReferenceSource;";
    private static final String __SELECT_REFERENCESOURCE_WITHOUT_GROUP = "SELECT rs.* FROM Reference r, ReferenceSource rs WHERE r.idReference = ? AND r.ReferenceSource_idReferenceSource = rs.idReferenceSource AND rs.ReferenceSourceGroup_idReferenceSourceGroup;";
    private static final String __SELECT_DOCUMENTS = "SELECT d.* FROM Document_Reference dr, Document d WHERE dr.Reference_idReference = ? and dr.Document_idDocument = d.idDocument;";
    private static final String __SELECT_AUTHORREFERENCE_REFERENCE = "SELECT r.*, ar.*, arr.position FROM AuthorReference_Reference arr, AuthorReference ar, Reference r WHERE r.idReference = ? AND       r.idReference = arr.Reference_idReference AND       arr.AuthorReference_idAuthorReference = ar.idAuthorReference;";
    private static final String __SELECT_AUTHORREFERENCES = "SELECT ar.* FROM AuthorReference_Reference arr, AuthorReference ar WHERE arr.Reference_idReference = ? AND       arr.AuthorReference_idAuthorReference = ar.idAuthorReference;";
    private static final String __SELECT_AUTHORREFERENCES_WITHOUT_GROUP = "SELECT ar.* FROM AuthorReference_Reference arr, AuthorReference ar WHERE arr.Reference_idReference = ? AND       arr.AuthorReference_idAuthorReference = ar.idAuthorReference AND ar.AuthorReferenceGroup_idAuthorReferenceGroup ISNULL;";
    private static final String __SELECT_REFERENCE_BY_ID = "SELECT * FROM Reference WHERE idReference = ?;";
    private static final String __SELECT_REFERENCE_BY_FULLREFERENCE = "SELECT * FROM Reference WHERE fullReference = ?;";
    private static final String __SELECT_REFERENCES = "SELECT * FROM Reference;";
    private static final String __SELECT_REFERENCES_WITHOUTGROUP = "SELECT * FROM Reference WHERE ReferenceGRoup_idReferenceGroup IS NULL;";
    private static final String __CHECK_REFERENCE_BY_FULLREFERENCE = "SELECT idReference FROM Reference WHERE fullReference = ?;";
    private static final String __CHECK_REFERENCE_BY_ID = "SELECT idReference FROM Reference WHERE idReference = ?;";
    private PreparedStatement statCheckReferenceByFullReference;
    private PreparedStatement statCheckReferenceById;
    private PreparedStatement statAddReference;
    private PreparedStatement statAddReferenceWithId;
    private PreparedStatement statRemoveReference;
    private PreparedStatement statSelectAuthorReferences;
    private PreparedStatement statSelectAuthorReferencesWithoutGroup;
    private PreparedStatement statSelectAuthorReferenceReference;
    private PreparedStatement statSelectDocuments;
    private PreparedStatement statSelectReferenceGroup;
    private PreparedStatement statSelectReferences;
    private PreparedStatement statSelectReferenceSource;
    private PreparedStatement statSelectReferenceSourceWithoutGroup;
    private PreparedStatement statSelectReferencesWithoutGroup;
    private PreparedStatement statSelectReferenceByFullReference;
    private PreparedStatement statSelectReferenceById;
    private PreparedStatement statUpdateDoi;
    private PreparedStatement statUpdateFormat;
    private PreparedStatement statUpdateFullReference;
    private PreparedStatement statUpdateIssue;
    private PreparedStatement statUpdatePage;
    private PreparedStatement statUpdateReference;
    private PreparedStatement statUpdateRererenceGroup;
    private PreparedStatement statUpdateReferenceSource;
    private PreparedStatement statUpdateVolume;
    private PreparedStatement statUpdateYear;

    public ReferenceDAO(KnowledgeBaseManager kbm) throws KnowledgeBaseException {
        this.kbm = kbm;
        try {
            this.statCheckReferenceByFullReference = this.kbm.getConnection().prepareStatement(__CHECK_REFERENCE_BY_FULLREFERENCE);
            this.statCheckReferenceById = this.kbm.getConnection().prepareStatement(__CHECK_REFERENCE_BY_ID);
            this.statAddReference = this.kbm.getConnection().prepareStatement(__INSERT_REFERENCE, 1);
            this.statAddReferenceWithId = this.kbm.getConnection().prepareStatement(__INSERT_REFERENCE_WITH_ID);
            this.statRemoveReference = this.kbm.getConnection().prepareStatement(__REMOVE_REFERENCE);
            this.statSelectAuthorReferences = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORREFERENCES);
            this.statSelectAuthorReferencesWithoutGroup = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORREFERENCES_WITHOUT_GROUP);
            this.statSelectAuthorReferenceReference = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORREFERENCE_REFERENCE);
            this.statSelectDocuments = this.kbm.getConnection().prepareStatement(__SELECT_DOCUMENTS);
            this.statSelectReferenceGroup = this.kbm.getConnection().prepareStatement(__SELECT_REFERENCEGROUP);
            this.statSelectReferences = this.kbm.getConnection().prepareStatement(__SELECT_REFERENCES);
            this.statSelectReferenceSource = this.kbm.getConnection().prepareStatement(__SELECT_REFERENCESOURCE);
            this.statSelectReferenceSourceWithoutGroup = this.kbm.getConnection().prepareStatement(__SELECT_REFERENCESOURCE_WITHOUT_GROUP);
            this.statSelectReferencesWithoutGroup = this.kbm.getConnection().prepareStatement(__SELECT_REFERENCES_WITHOUTGROUP);
            this.statSelectReferenceByFullReference = this.kbm.getConnection().prepareStatement(__SELECT_REFERENCE_BY_FULLREFERENCE);
            this.statSelectReferenceById = this.kbm.getConnection().prepareStatement(__SELECT_REFERENCE_BY_ID);
            this.statUpdateDoi = this.kbm.getConnection().prepareStatement(__UPDATE_DOI);
            this.statUpdateFormat = this.kbm.getConnection().prepareStatement(__UPDATE_FORMAT);
            this.statUpdateFullReference = this.kbm.getConnection().prepareStatement(__UPDATE_FULLREFERENCE);
            this.statUpdateIssue = this.kbm.getConnection().prepareStatement(__UPDATE_ISSUE);
            this.statUpdatePage = this.kbm.getConnection().prepareStatement(__UPDATE_PAGE);
            this.statUpdateReference = this.kbm.getConnection().prepareStatement(__UPDATE_REFERENCE);
            this.statUpdateRererenceGroup = this.kbm.getConnection().prepareStatement(__UPDATE_REFERENCEGROUP);
            this.statUpdateReferenceSource = this.kbm.getConnection().prepareStatement(__UPDATE_REFERENCESOURCE);
            this.statUpdateVolume = this.kbm.getConnection().prepareStatement(__UPDATE_VOLUME);
            this.statUpdateYear = this.kbm.getConnection().prepareStatement(__UPDATE_YEAR);
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public Integer addReference(String fullReference, String volume, String issue, String page, String year, String doi, String format, boolean notifyObservers) throws KnowledgeBaseException {
        Integer id;
        try {
            this.statAddReference.clearParameters();
            this.statAddReference.setString(1, fullReference);
            this.statAddReference.setString(2, volume);
            this.statAddReference.setString(3, issue);
            this.statAddReference.setString(4, page);
            this.statAddReference.setString(5, year);
            this.statAddReference.setString(6, doi);
            this.statAddReference.setString(7, format);
            id = this.statAddReference.executeUpdate() == 1 ? Integer.valueOf(this.statAddReference.getGeneratedKeys().getInt(1)) : null;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddReferenceEvent(this.getReference(id)));
        }
        return id;
    }

    public boolean addReference(Integer referenceID, String fullReference, String volume, String issue, String page, String year, String doi, String format, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statAddReferenceWithId.clearParameters();
            this.statAddReferenceWithId.setInt(1, referenceID);
            this.statAddReferenceWithId.setString(2, fullReference);
            this.statAddReferenceWithId.setString(3, volume);
            this.statAddReferenceWithId.setString(4, issue);
            this.statAddReferenceWithId.setString(5, page);
            this.statAddReferenceWithId.setString(6, year);
            this.statAddReferenceWithId.setString(7, doi);
            this.statAddReferenceWithId.setString(8, format);
            result = this.statAddReferenceWithId.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddReferenceEvent(this.getReference(referenceID)));
        }
        return result;
    }

    public boolean addReference(Reference reference, boolean notifyObservers) throws KnowledgeBaseException {
        return this.addReference(reference.getReferenceID(), reference.getFullReference(), reference.getVolume(), reference.getIssue(), reference.getPage(), reference.getYear(), reference.getDoi(), reference.getFormat(), notifyObservers);
    }

    public boolean removeReference(Integer referenceID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        Reference reference = null;
        ReferenceGroup referenceGroup = null;
        ArrayList<AuthorReference> authorReferences = null;
        ArrayList<AuthorReference> authorReferencesWithoutGroup = null;
        ReferenceSource referenceSource = null;
        ReferenceSourceGroup referenceSourceGroup = null;
        ArrayList<Document> documents = null;
        if (notifyObservers) {
            reference = this.getReference(referenceID);
            referenceGroup = this.getReferenceGroup(referenceID);
            authorReferences = this.getAuthorReferences(referenceID);
            referenceSource = this.getReferenceSource(referenceID);
            documents = this.getDocuments(referenceID);
        }
        try {
            this.statRemoveReference.clearParameters();
            this.statRemoveReference.setInt(1, referenceID);
            result = this.statRemoveReference.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new RemoveReferenceEvent(reference));
            if (referenceGroup != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceGroupEvent(CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO().refreshReferenceGroup(referenceGroup)));
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new ReferenceGroupRelationReferenceEvent());
            } else {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new RemoveReferenceWithoutGroupEvent(reference));
            }
            if (referenceSource != null) {
                ReferenceSourceDAO referenceSourceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO();
                referenceSource = referenceSourceDAO.refreshReferenceSource(referenceSource);
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceSourceEvent(referenceSource));
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new ReferenceSourceRelationReferenceEvent());
                referenceSourceGroup = referenceSourceDAO.getReferenceSourceGroup(referenceSource.getReferenceSourceID());
                if (referenceSourceGroup != null) {
                    KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceSourceGroupEvent(referenceSourceGroup));
                } else {
                    KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceSourceWithoutGroupEvent(referenceSource));
                }
            }
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorReferenceEvent(authorReferences));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new ReferenceRelationAuthorReferenceEvent());
            TreeSet<AuthorReferenceGroup> authorReferenceGroups = new TreeSet<AuthorReferenceGroup>();
            authorReferencesWithoutGroup = new ArrayList<AuthorReference>();
            for (int i = 0; i < authorReferences.size(); ++i) {
                AuthorReferenceGroup authorReferenceGroup = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO().getAuthorReferenceGroup(authorReferences.get(i).getAuthorReferenceID());
                if (authorReferenceGroup != null) {
                    authorReferenceGroups.add(authorReferenceGroup);
                    continue;
                }
                authorReferencesWithoutGroup.add(authorReferences.get(i));
            }
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorReferenceWithoutGroupEvent(authorReferencesWithoutGroup));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorReferenceGroupEvent(new ArrayList<AuthorReferenceGroup>(authorReferenceGroups)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateDocumentEvent(documents));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new DocumentRelationReferenceEvent());
        }
        return result;
    }

    public Reference getReference(Integer idReference) throws KnowledgeBaseException {
        Reference reference = null;
        try {
            this.statSelectReferenceById.clearParameters();
            this.statSelectReferenceById.setInt(1, idReference);
            ResultSet rs = this.statSelectReferenceById.executeQuery();
            if (rs.next()) {
                reference = UtilsDAO.getInstance().getReference(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return reference;
    }

    public Reference getReference(String fullReference) throws KnowledgeBaseException {
        Reference reference = null;
        try {
            this.statSelectReferenceByFullReference.clearParameters();
            this.statSelectReferenceByFullReference.setString(1, fullReference);
            ResultSet rs = this.statSelectReferenceByFullReference.executeQuery();
            if (rs.next()) {
                reference = UtilsDAO.getInstance().getReference(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return reference;
    }

    public ArrayList<Reference> getReferences() throws KnowledgeBaseException {
        ArrayList<Reference> referenceList = new ArrayList<Reference>();
        try {
            this.statSelectReferences.clearParameters();
            ResultSet rs = this.statSelectReferences.executeQuery();
            while (rs.next()) {
                referenceList.add(UtilsDAO.getInstance().getReference(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return referenceList;
    }

    public ArrayList<Reference> getReferencesWithoutGroup() throws KnowledgeBaseException {
        ArrayList<Reference> referenceList = new ArrayList<Reference>();
        try {
            this.statSelectReferencesWithoutGroup.clearParameters();
            ResultSet rs = this.statSelectReferencesWithoutGroup.executeQuery();
            while (rs.next()) {
                referenceList.add(UtilsDAO.getInstance().getReference(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return referenceList;
    }

    public boolean setFullReference(Integer referenceID, String fullReference, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateFullReference.clearParameters();
            this.statUpdateFullReference.setString(1, fullReference);
            this.statUpdateFullReference.setInt(2, referenceID);
            result = this.statUpdateFullReference.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            Reference reference = this.getReference(referenceID);
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceEvent(reference));
            if (this.getReferenceGroup(referenceID) == null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceWithoutGroupEvent(reference));
            }
        }
        return result;
    }

    public boolean setVolume(Integer referenceID, String volume, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateVolume.clearParameters();
            this.statUpdateVolume.setString(1, volume);
            this.statUpdateVolume.setInt(2, referenceID);
            result = this.statUpdateVolume.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            Reference reference = this.getReference(referenceID);
            if (this.getReferenceGroup(referenceID) == null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceWithoutGroupEvent(reference));
            }
        }
        return result;
    }

    public boolean setIssue(Integer referenceID, String issue, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateIssue.clearParameters();
            this.statUpdateIssue.setString(1, issue);
            this.statUpdateIssue.setInt(2, referenceID);
            result = this.statUpdateIssue.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            Reference reference = this.getReference(referenceID);
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceEvent(reference));
            if (this.getReferenceGroup(referenceID) == null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceWithoutGroupEvent(reference));
            }
        }
        return result;
    }

    public boolean setPage(Integer referenceID, String page, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdatePage.clearParameters();
            this.statUpdatePage.setString(1, page);
            this.statUpdatePage.setInt(2, referenceID);
            result = this.statUpdatePage.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            Reference reference = this.getReference(referenceID);
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceEvent(reference));
            if (this.getReferenceGroup(referenceID) == null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceWithoutGroupEvent(reference));
            }
        }
        return result;
    }

    public boolean setYear(Integer referenceID, String year, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateYear.clearParameters();
            this.statUpdateYear.setString(1, year);
            this.statUpdateYear.setInt(2, referenceID);
            result = this.statUpdateYear.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            Reference reference = this.getReference(referenceID);
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceEvent(reference));
            if (this.getReferenceGroup(referenceID) == null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceWithoutGroupEvent(reference));
            }
        }
        return result;
    }

    public boolean setDoi(Integer referenceID, String doi, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateDoi.clearParameters();
            this.statUpdateDoi.setString(1, doi);
            this.statUpdateDoi.setInt(2, referenceID);
            result = this.statUpdateDoi.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            Reference reference = this.getReference(referenceID);
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceEvent(reference));
            if (this.getReferenceGroup(referenceID) == null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceWithoutGroupEvent(reference));
            }
        }
        return result;
    }

    public boolean setFormat(Integer referenceID, String format, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateFormat.clearParameters();
            this.statUpdateFormat.setString(1, format);
            this.statUpdateFormat.setInt(2, referenceID);
            result = this.statUpdateFormat.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            Reference reference = this.getReference(referenceID);
            if (this.getReferenceGroup(referenceID) == null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceWithoutGroupEvent(reference));
            }
        }
        return result;
    }

    public boolean updateReference(Integer referenceID, String fullReference, String volume, String issue, String page, String year, String doi, String format, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateReference.clearParameters();
            this.statUpdateReference.setString(1, fullReference);
            this.statUpdateReference.setString(2, volume);
            this.statUpdateReference.setString(3, issue);
            this.statUpdateReference.setString(4, page);
            this.statUpdateReference.setString(5, year);
            this.statUpdateReference.setString(6, doi);
            this.statUpdateReference.setString(7, format);
            this.statUpdateReference.setInt(8, referenceID);
            result = this.statUpdateReference.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            Reference reference = this.getReference(referenceID);
            if (this.getReferenceGroup(referenceID) == null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceWithoutGroupEvent(reference));
            }
        }
        return result;
    }

    public boolean setReferenceGroup(Integer referenceID, Integer referenceGroupID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        ReferenceGroup oldReferenceGroup = null;
        if (notifyObservers) {
            oldReferenceGroup = this.getReferenceGroup(referenceID);
        }
        try {
            this.statUpdateRererenceGroup.clearParameters();
            if (referenceGroupID != null) {
                this.statUpdateRererenceGroup.setInt(1, referenceGroupID);
            } else {
                this.statUpdateRererenceGroup.setNull(1, 0);
            }
            this.statUpdateRererenceGroup.setInt(2, referenceID);
            result = this.statUpdateRererenceGroup.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            if (oldReferenceGroup != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceGroupEvent(CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO().refreshReferenceGroup(oldReferenceGroup)));
                if (referenceGroupID == null) {
                    KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddReferenceWithoutGroupEvent(this.getReference(referenceID)));
                }
            } else if (referenceGroupID != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new RemoveReferenceWithoutGroupEvent(this.getReference(referenceID)));
            }
            if (referenceGroupID != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceGroupEvent(this.getReferenceGroup(referenceID)));
            }
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new ReferenceGroupRelationReferenceEvent());
        }
        return result;
    }

    public boolean setReferenceSource(Integer referenceID, Integer referenceSourceID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        ReferenceSource oldReferenceSource = null;
        if (notifyObservers) {
            oldReferenceSource = this.getReferenceSource(referenceID);
        }
        try {
            this.statUpdateReferenceSource.clearParameters();
            if (referenceSourceID != null) {
                this.statUpdateReferenceSource.setInt(1, referenceSourceID);
            } else {
                this.statUpdateReferenceSource.setNull(1, 0);
            }
            this.statUpdateReferenceSource.setInt(2, referenceID);
            result = this.statUpdateReferenceSource.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            ReferenceSourceGroup referenceSourceGroup;
            ReferenceSourceDAO referenceSourceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO();
            if (oldReferenceSource != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceSourceEvent(referenceSourceDAO.refreshReferenceSource(oldReferenceSource)));
                referenceSourceGroup = referenceSourceDAO.getReferenceSourceGroup(oldReferenceSource.getReferenceSourceID());
                if (referenceSourceGroup != null) {
                    KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceSourceGroupEvent(referenceSourceGroup));
                }
            }
            if (referenceSourceID != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceSourceEvent(this.getReferenceSource(referenceID)));
                referenceSourceGroup = referenceSourceDAO.getReferenceSourceGroup(referenceSourceID);
                if (referenceSourceGroup != null) {
                    KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceSourceGroupEvent(referenceSourceGroup));
                }
            }
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new ReferenceSourceRelationReferenceEvent());
        }
        return result;
    }

    public ReferenceGroup getReferenceGroup(Integer referenceID) throws KnowledgeBaseException {
        ReferenceGroup referenceGroup = null;
        try {
            this.statSelectReferenceGroup.clearParameters();
            this.statSelectReferenceGroup.setInt(1, referenceID);
            ResultSet rs = this.statSelectReferenceGroup.executeQuery();
            if (rs.next()) {
                referenceGroup = UtilsDAO.getInstance().getReferenceGroup(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return referenceGroup;
    }

    public ReferenceSource getReferenceSource(Integer referenceID) throws KnowledgeBaseException {
        ReferenceSource referenceSource = null;
        try {
            this.statSelectReferenceSource.clearParameters();
            this.statSelectReferenceSource.setInt(1, referenceID);
            ResultSet rs = this.statSelectReferenceSource.executeQuery();
            if (rs.next()) {
                referenceSource = UtilsDAO.getInstance().getReferenceSource(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return referenceSource;
    }

    public ReferenceSource getReferenceSourceWithoutGroup(Integer referenceID) throws KnowledgeBaseException {
        ReferenceSource referenceSource = null;
        try {
            this.statSelectReferenceSourceWithoutGroup.clearParameters();
            this.statSelectReferenceSourceWithoutGroup.setInt(1, referenceID);
            ResultSet rs = this.statSelectReferenceSourceWithoutGroup.executeQuery();
            if (rs.next()) {
                referenceSource = UtilsDAO.getInstance().getReferenceSource(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return referenceSource;
    }

    public ArrayList<Document> getDocuments(Integer referenceID) throws KnowledgeBaseException {
        ArrayList<Document> documentList = new ArrayList<Document>();
        try {
            this.statSelectDocuments.clearParameters();
            this.statSelectDocuments.setInt(1, referenceID);
            ResultSet rs = this.statSelectDocuments.executeQuery();
            while (rs.next()) {
                documentList.add(UtilsDAO.getInstance().getDocument(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return documentList;
    }

    public ArrayList<AuthorReferenceReference> getAuthorReferenceReferences(Integer referenceID) throws KnowledgeBaseException {
        ArrayList<AuthorReferenceReference> referencesList = new ArrayList<AuthorReferenceReference>();
        try {
            this.statSelectAuthorReferenceReference.clearParameters();
            this.statSelectAuthorReferenceReference.setInt(1, referenceID);
            ResultSet rs = this.statSelectAuthorReferenceReference.executeQuery();
            while (rs.next()) {
                referencesList.add(UtilsDAO.getInstance().getAuthorReferenceReference(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return referencesList;
    }

    public ArrayList<AuthorReference> getAuthorReferences(Integer referenceID) throws KnowledgeBaseException {
        ArrayList<AuthorReference> authorReferences = new ArrayList<AuthorReference>();
        try {
            this.statSelectAuthorReferences.clearParameters();
            this.statSelectAuthorReferences.setInt(1, referenceID);
            ResultSet rs = this.statSelectAuthorReferences.executeQuery();
            while (rs.next()) {
                authorReferences.add(UtilsDAO.getInstance().getAuthorReference(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorReferences;
    }

    public ArrayList<AuthorReference> getAuthorReferencesWithoutGroup(Integer referenceID) throws KnowledgeBaseException {
        ArrayList<AuthorReference> authorReferences = new ArrayList<AuthorReference>();
        try {
            this.statSelectAuthorReferencesWithoutGroup.clearParameters();
            this.statSelectAuthorReferencesWithoutGroup.setInt(1, referenceID);
            ResultSet rs = this.statSelectAuthorReferencesWithoutGroup.executeQuery();
            while (rs.next()) {
                authorReferences.add(UtilsDAO.getInstance().getAuthorReference(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorReferences;
    }

    public boolean checkReference(String fullReference) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckReferenceByFullReference.clearParameters();
            this.statCheckReferenceByFullReference.setString(1, fullReference);
            ResultSet rs = this.statCheckReferenceByFullReference.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public boolean checkReference(Integer idReference) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckReferenceById.clearParameters();
            this.statCheckReferenceById.setInt(1, idReference);
            ResultSet rs = this.statCheckReferenceById.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public ArrayList<Reference> refreshReferences(ArrayList<Reference> referencesToRefresh) throws KnowledgeBaseException {
        ArrayList<Reference> references = new ArrayList<Reference>();
        int i = 0;
        if (!referencesToRefresh.isEmpty()) {
            String query = "SELECT * FROM Reference WHERE idReference IN (" + referencesToRefresh.get(i).getReferenceID();
            for (i = 1; i < referencesToRefresh.size(); ++i) {
                query = query + ", " + referencesToRefresh.get(i).getReferenceID();
            }
            query = query + ");";
            try {
                Statement stat = this.kbm.getConnection().createStatement();
                ResultSet rs = stat.executeQuery(query);
                while (rs.next()) {
                    references.add(UtilsDAO.getInstance().getReference(rs));
                }
                rs.close();
                stat.close();
            }
            catch (SQLException e) {
                throw new KnowledgeBaseException(e.getMessage(), e.getCause());
            }
        }
        return references;
    }

    public Reference refreshReference(Reference referenceToRefresh) throws KnowledgeBaseException {
        return this.getReference(referenceToRefresh.getReferenceID());
    }
}

