/*
 * Decompiled with CFR 0.152.
 */
package scimat.model.knowledgebase.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.knowledgebaseevents.event.add.AddPeriodEvent;
import scimat.knowledgebaseevents.event.relation.PeriodRelationPublishDateEvent;
import scimat.knowledgebaseevents.event.remove.RemovePeriodEvent;
import scimat.knowledgebaseevents.event.update.UpdatePeriodEvent;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.UtilsDAO;
import scimat.model.knowledgebase.entity.Period;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeriodDAO {
    private KnowledgeBaseManager kbm;
    private static final String __INSERT_PERIOD = "INSERT INTO Period(name, position) VALUES(?,?);";
    private static final String __INSERT_PERIOD_WITH_ID = "INSERT INTO Period(idPeriod,name, position) VALUES(?,?, ?);";
    private static final String __REMOVE_PERIOD = "DELETE FROM Period WHERE idPeriod = ?;";
    private static final String __UPDATE_NAME = "UPDATE Period SET name = ? WHERE idPeriod = ?;";
    private static final String __UPDATE_POSITION = "UPDATE Period SET position = ? WHERE idPeriod = ?;";
    private static final String __SELECT_PUBLISHDATES = "SELECT pu.* FROM PublishDate_Period pdp, PublishDate pu WHERE pdp.Period_idPeriod = ? AND       pdp.PublishDate_idPublishDate = pu.idPublishDate;";
    private static final String __SELECT_PERIOD_BY_ID = "SELECT * FROM Period WHERE idPeriod = ?;";
    private static final String __SELECT_PERIOD_BY_NAME = "SELECT * FROM Period WHERE name = ?;";
    private static final String __SELECT_PERIODS = "SELECT * FROM Period;";
    private static final String __SELECT_PERIODS_ORDERED_BY_POSITION = "SELECT * FROM Period ORDER BY position ASC;";
    private static final String __CHECK_PERIOD_BY_NAME = "SELECT idPeriod FROM Period WHERE name = ?;";
    private static final String __CHECK_PERIOD_BY_ID = "SELECT idPeriod FROM Period WHERE idPeriod = ?;";
    private static final String __SELECT_MAX_POSITION = "SELECT MAX(position) AS maxPosition FROM Period;";
    private PreparedStatement statCheckPeriodById;
    private PreparedStatement statCheckPeriodByName;
    private PreparedStatement statAddPeriod;
    private PreparedStatement statAddPeriodWithId;
    private PreparedStatement statRemovePeriod;
    private PreparedStatement statSelectMaxPosition;
    private PreparedStatement statSelectPeriods;
    private PreparedStatement statSelectPeriodsOrderedByPosition;
    private PreparedStatement statSelectPeriodById;
    private PreparedStatement statSelectPeriodByName;
    private PreparedStatement statSelectPublishDates;
    private PreparedStatement statUpdateName;
    private PreparedStatement statUpdatePosition;

    public PeriodDAO(KnowledgeBaseManager kbm) throws KnowledgeBaseException {
        this.kbm = kbm;
        try {
            this.statCheckPeriodById = this.kbm.getConnection().prepareStatement(__CHECK_PERIOD_BY_ID);
            this.statCheckPeriodByName = this.kbm.getConnection().prepareStatement(__CHECK_PERIOD_BY_NAME);
            this.statAddPeriod = this.kbm.getConnection().prepareStatement(__INSERT_PERIOD, 1);
            this.statAddPeriodWithId = this.kbm.getConnection().prepareStatement(__INSERT_PERIOD_WITH_ID);
            this.statRemovePeriod = this.kbm.getConnection().prepareStatement(__REMOVE_PERIOD);
            this.statSelectMaxPosition = this.kbm.getConnection().prepareStatement(__SELECT_MAX_POSITION);
            this.statSelectPeriods = this.kbm.getConnection().prepareStatement(__SELECT_PERIODS);
            this.statSelectPeriodsOrderedByPosition = this.kbm.getConnection().prepareStatement(__SELECT_PERIODS_ORDERED_BY_POSITION);
            this.statSelectPeriodById = this.kbm.getConnection().prepareStatement(__SELECT_PERIOD_BY_ID);
            this.statSelectPeriodByName = this.kbm.getConnection().prepareStatement(__SELECT_PERIOD_BY_NAME);
            this.statSelectPublishDates = this.kbm.getConnection().prepareStatement(__SELECT_PUBLISHDATES);
            this.statUpdateName = this.kbm.getConnection().prepareStatement(__UPDATE_NAME);
            this.statUpdatePosition = this.kbm.getConnection().prepareStatement(__UPDATE_POSITION);
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public Integer addPeriod(String name, int position, boolean notifyObservers) throws KnowledgeBaseException {
        Integer id;
        try {
            this.statAddPeriod.clearParameters();
            this.statAddPeriod.setString(1, name);
            this.statAddPeriod.setInt(2, position);
            if (this.statAddPeriod.executeUpdate() == 1) {
                id = this.statAddPeriod.getGeneratedKeys().getInt(1);
                this.statAddPeriod.getGeneratedKeys().close();
            } else {
                id = null;
            }
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddPeriodEvent(this.getPeriod(id)));
        }
        return id;
    }

    public boolean addPeriod(Integer periodID, String name, int position, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statAddPeriodWithId.clearParameters();
            this.statAddPeriodWithId.setInt(1, periodID);
            this.statAddPeriodWithId.setString(2, name);
            this.statAddPeriodWithId.setInt(3, position);
            result = this.statAddPeriodWithId.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddPeriodEvent(this.getPeriod(periodID)));
        }
        return result;
    }

    public boolean addPeriod(Period period, boolean notifyObservers) throws KnowledgeBaseException {
        return this.addPeriod(period.getPeriodID(), period.getName(), period.getPosition(), notifyObservers);
    }

    public boolean removePeriod(Integer periodID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        Period period = null;
        if (notifyObservers) {
            period = this.getPeriod(periodID);
        }
        try {
            this.statRemovePeriod.clearParameters();
            this.statRemovePeriod.setInt(1, periodID);
            result = this.statRemovePeriod.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new RemovePeriodEvent(period));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new PeriodRelationPublishDateEvent());
        }
        return result;
    }

    public Period getPeriod(Integer periodID) throws KnowledgeBaseException {
        Period period = null;
        try {
            this.statSelectPeriodById.clearParameters();
            this.statSelectPeriodById.setInt(1, periodID);
            ResultSet rs = this.statSelectPeriodById.executeQuery();
            if (rs.next()) {
                period = UtilsDAO.getInstance().getPeriod(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return period;
    }

    public Period getPeriod(String name) throws KnowledgeBaseException {
        Period period = null;
        try {
            this.statSelectPeriodByName.clearParameters();
            this.statSelectPeriodByName.setString(1, name);
            ResultSet rs = this.statSelectPeriodByName.executeQuery();
            if (rs.next()) {
                period = UtilsDAO.getInstance().getPeriod(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return period;
    }

    public ArrayList<Period> getPeriods() throws KnowledgeBaseException {
        ArrayList<Period> periodList = new ArrayList<Period>();
        try {
            this.statSelectPeriods.clearParameters();
            ResultSet rs = this.statSelectPeriods.executeQuery();
            while (rs.next()) {
                periodList.add(UtilsDAO.getInstance().getPeriod(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return periodList;
    }

    public ArrayList<Period> getPeriodsOrderedByPosition() throws KnowledgeBaseException {
        ArrayList<Period> periodList = new ArrayList<Period>();
        try {
            this.statSelectPeriodsOrderedByPosition.clearParameters();
            ResultSet rs = this.statSelectPeriodsOrderedByPosition.executeQuery();
            while (rs.next()) {
                periodList.add(UtilsDAO.getInstance().getPeriod(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return periodList;
    }

    public boolean setName(Integer periodID, String name, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateName.clearParameters();
            this.statUpdateName.setString(1, name);
            this.statUpdateName.setInt(2, periodID);
            result = this.statUpdateName.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdatePeriodEvent(this.getPeriod(periodID)));
        }
        return result;
    }

    public boolean setPosition(Integer periodID, int position, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdatePosition.clearParameters();
            this.statUpdatePosition.setInt(1, position);
            this.statUpdatePosition.setInt(2, periodID);
            result = this.statUpdatePosition.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdatePeriodEvent(this.getPeriod(periodID)));
        }
        return result;
    }

    public ArrayList<PublishDate> getPublishDates(Integer periodID) throws KnowledgeBaseException {
        ArrayList<PublishDate> publishDateList = new ArrayList<PublishDate>();
        try {
            this.statSelectPublishDates.clearParameters();
            this.statSelectPublishDates.setInt(1, periodID);
            ResultSet rs = this.statSelectPublishDates.executeQuery();
            while (rs.next()) {
                publishDateList.add(UtilsDAO.getInstance().getPublishDate(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return publishDateList;
    }

    public boolean checkPeriod(String name) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckPeriodByName.clearParameters();
            this.statCheckPeriodByName.setString(1, name);
            ResultSet rs = this.statCheckPeriodByName.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public boolean checkPeriod(Integer idPeriod) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckPeriodById.clearParameters();
            this.statCheckPeriodById.setInt(1, idPeriod);
            ResultSet rs = this.statCheckPeriodById.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public int getMaxPosition() throws KnowledgeBaseException {
        int position = 0;
        try {
            this.statSelectMaxPosition.clearParameters();
            ResultSet rs = this.statSelectMaxPosition.executeQuery();
            if (rs.next()) {
                position = rs.getInt("maxPosition");
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return position;
    }

    public ArrayList<Period> refreshPeriods(ArrayList<Period> periodsToRefresh) throws KnowledgeBaseException {
        ArrayList<Period> periods = new ArrayList<Period>();
        int i = 0;
        if (!periodsToRefresh.isEmpty()) {
            String query = "SELECT * FROM Period WHERE idPeriod IN (" + periodsToRefresh.get(i).getPeriodID();
            for (i = 1; i < periodsToRefresh.size(); ++i) {
                query = query + ", " + periodsToRefresh.get(i).getPeriodID();
            }
            query = query + ");";
            try {
                Statement stat = this.kbm.getConnection().createStatement();
                ResultSet rs = stat.executeQuery(query);
                while (rs.next()) {
                    periods.add(UtilsDAO.getInstance().getPeriod(rs));
                }
                rs.close();
                stat.close();
            }
            catch (SQLException e) {
                throw new KnowledgeBaseException(e.getMessage(), e.getCause());
            }
        }
        return periods;
    }

    public Period refreshPeriod(Period periodToRefresh) throws KnowledgeBaseException {
        return this.getPeriod(periodToRefresh.getPeriodID());
    }
}

