/*
 * Decompiled with CFR 0.152.
 */
package scimat.model.knowledgebase.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.knowledgebaseevents.event.relation.DocumentRelationWordEvent;
import scimat.knowledgebaseevents.event.update.UpdateDocumentEvent;
import scimat.knowledgebaseevents.event.update.UpdateWordEvent;
import scimat.knowledgebaseevents.event.update.UpdateWordGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateWordWithoutGroupEvent;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.UtilsDAO;
import scimat.model.knowledgebase.dao.WordDAO;
import scimat.model.knowledgebase.entity.DocumentWord;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.entity.WordGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class DocumentWordDAO {
    private KnowledgeBaseManager kbm;
    private static final String __ADD_DOCUMENT_WORD = "INSERT INTO Document_Word(Document_idDocument,Word_idWord,isAuthorWord,isSourceWord,isAddedWord) VALUES(?,?,?,?,?);";
    private static final String __REMOVE_DOCUMENT_WORD = "DELETE FROM Document_Word WHERE Document_idDocument = ? AND       Word_idWord = ?;";
    private static final String __UPDATE_AUTHORKEYWORD = "UPDATE Document_Word SET isAuthorWord = ? WHERE Word_idWord = ? AND       Document_idDocument = ?;";
    private static final String __UPDATE_SOURCEKEYWORD = "UPDATE Document_Word SET isSourceWord = ? WHERE Word_idWord = ? AND Document_idDocument = ?;";
    private static final String __UPDATE_ADDEDKEYWORD = "UPDATE Document_Word SET isAddedWord = ? WHERE Word_idWord = ? AND       Document_idDocument = ?;";
    private static final String __SELECT_DOCUMENT_WORD = "SELECT d.*, w.*, dw.isAuthorWord, dw.isSourceWord, dw.isAddedWord FROM Document_Word dw, Document d, Word w WHERE w.idWord = ? AND       d.idDocument = ? AND       w.idWord = dw.Word_idWord AND       dw.Document_idDocument = d.idDocument;";
    private static final String __CHECK_DOCUMENT_WORD = "SELECT Document_idDocument FROM Document_Word WHERE Document_idDocument = ? AND Word_idWord = ?;";
    private PreparedStatement statAddDocumentWord;
    private PreparedStatement statCheckDocumentWord;
    private PreparedStatement statRemoveDocumentWord;
    private PreparedStatement statSelectDocumentWord;
    private PreparedStatement statUpdateAddedWord;
    private PreparedStatement statUpdateAuthorWord;
    private PreparedStatement statUpdateSourcedWord;

    public DocumentWordDAO(KnowledgeBaseManager kbm) throws KnowledgeBaseException {
        this.kbm = kbm;
        try {
            this.statAddDocumentWord = this.kbm.getConnection().prepareStatement(__ADD_DOCUMENT_WORD);
            this.statCheckDocumentWord = this.kbm.getConnection().prepareStatement(__CHECK_DOCUMENT_WORD);
            this.statRemoveDocumentWord = this.kbm.getConnection().prepareStatement(__REMOVE_DOCUMENT_WORD);
            this.statSelectDocumentWord = this.kbm.getConnection().prepareStatement(__SELECT_DOCUMENT_WORD);
            this.statUpdateAddedWord = this.kbm.getConnection().prepareStatement(__UPDATE_ADDEDKEYWORD);
            this.statUpdateAuthorWord = this.kbm.getConnection().prepareStatement(__UPDATE_AUTHORKEYWORD);
            this.statUpdateSourcedWord = this.kbm.getConnection().prepareStatement(__UPDATE_SOURCEKEYWORD);
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public boolean addDocumentWord(Integer documentID, Integer wordID, boolean isAuthorWord, boolean isSourceWord, boolean isAddedWord, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statAddDocumentWord.clearParameters();
            this.statAddDocumentWord.setInt(1, documentID);
            this.statAddDocumentWord.setInt(2, wordID);
            this.statAddDocumentWord.setBoolean(3, isAuthorWord);
            this.statAddDocumentWord.setBoolean(4, isSourceWord);
            this.statAddDocumentWord.setBoolean(5, isAddedWord);
            result = this.statAddDocumentWord.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            WordDAO wordDAO = new WordDAO(this.kbm);
            Word word = wordDAO.getWord(wordID);
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateDocumentEvent(CurrentProject.getInstance().getFactoryDAO().getDocumentDAO().getDocument(documentID)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateWordEvent(word));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new DocumentRelationWordEvent());
            WordGroup wordGroup = wordDAO.getWordGroup(wordID);
            if (wordGroup != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateWordGroupEvent(wordGroup));
            } else {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateWordWithoutGroupEvent(word));
            }
        }
        return result;
    }

    public boolean removeDocumentWord(Integer documentID, Integer wordID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statRemoveDocumentWord.clearParameters();
            this.statRemoveDocumentWord.setInt(1, documentID);
            this.statRemoveDocumentWord.setInt(2, wordID);
            result = this.statRemoveDocumentWord.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            WordDAO wordDAO = new WordDAO(this.kbm);
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateDocumentEvent(CurrentProject.getInstance().getFactoryDAO().getDocumentDAO().getDocument(documentID)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateWordEvent(wordDAO.getWord(wordID)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new DocumentRelationWordEvent());
            WordGroup wordGroup = wordDAO.getWordGroup(wordID);
            if (wordGroup != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateWordGroupEvent(wordGroup));
            }
        }
        return result;
    }

    public boolean setAuthorKeyword(Integer documentID, Integer wordID, boolean isAuthorWord, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateAuthorWord.clearParameters();
            this.statUpdateAuthorWord.setBoolean(1, isAuthorWord);
            this.statUpdateAuthorWord.setInt(2, wordID);
            this.statUpdateAuthorWord.setInt(3, documentID);
            result = this.statUpdateAuthorWord.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateDocumentEvent(CurrentProject.getInstance().getFactoryDAO().getDocumentDAO().getDocument(documentID)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateWordEvent(CurrentProject.getInstance().getFactoryDAO().getWordDAO().getWord(wordID)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new DocumentRelationWordEvent());
        }
        return result;
    }

    public boolean setSourceKeyword(Integer documentID, Integer wordID, boolean isSourceWord, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateSourcedWord.clearParameters();
            this.statUpdateSourcedWord.setBoolean(1, isSourceWord);
            this.statUpdateSourcedWord.setInt(2, wordID);
            this.statUpdateSourcedWord.setInt(3, documentID);
            result = this.statUpdateSourcedWord.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateDocumentEvent(CurrentProject.getInstance().getFactoryDAO().getDocumentDAO().getDocument(documentID)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateWordEvent(CurrentProject.getInstance().getFactoryDAO().getWordDAO().getWord(wordID)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new DocumentRelationWordEvent());
        }
        return result;
    }

    public boolean setAddedKeyword(Integer documentID, Integer wordID, boolean isAddedWord, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateAddedWord.clearParameters();
            this.statUpdateAddedWord.setBoolean(1, isAddedWord);
            this.statUpdateAddedWord.setInt(2, wordID);
            this.statUpdateAddedWord.setInt(3, documentID);
            result = this.statUpdateAddedWord.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateDocumentEvent(CurrentProject.getInstance().getFactoryDAO().getDocumentDAO().getDocument(documentID)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateWordEvent(CurrentProject.getInstance().getFactoryDAO().getWordDAO().getWord(wordID)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new DocumentRelationWordEvent());
        }
        return result;
    }

    public boolean checkDocumentWord(Integer idDocument, Integer idWord) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckDocumentWord.clearParameters();
            this.statCheckDocumentWord.setInt(1, idDocument);
            this.statCheckDocumentWord.setInt(2, idWord);
            ResultSet rs = this.statCheckDocumentWord.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public DocumentWord getDocumentWord(Integer documentID, Integer wordID) throws KnowledgeBaseException {
        DocumentWord documentWord = null;
        try {
            this.statSelectDocumentWord.clearParameters();
            this.statSelectDocumentWord.setInt(1, wordID);
            this.statSelectDocumentWord.setInt(2, documentID);
            ResultSet rs = this.statSelectDocumentWord.executeQuery();
            while (rs.next()) {
                documentWord = UtilsDAO.getInstance().getDocumentWord(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return documentWord;
    }
}

