/*
 * Decompiled with CFR 0.152.
 */
package scimat.model.knowledgebase.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.TreeSet;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.knowledgebaseevents.event.relation.DocumentRelationReferenceEvent;
import scimat.knowledgebaseevents.event.update.UpdateAuthorReferenceEvent;
import scimat.knowledgebaseevents.event.update.UpdateAuthorReferenceGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateDocumentEvent;
import scimat.knowledgebaseevents.event.update.UpdateReferenceEvent;
import scimat.knowledgebaseevents.event.update.UpdateReferenceGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateReferenceSourceEvent;
import scimat.knowledgebaseevents.event.update.UpdateReferenceSourceGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateReferenceWithoutGroupEvent;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.ReferenceDAO;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.entity.AuthorReferenceGroup;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.ReferenceGroup;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.entity.ReferenceSourceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class DocumentReferenceDAO {
    private KnowledgeBaseManager kbm;
    private static final String __ADD_DOCUMENT_REFERENCE = "INSERT INTO Document_Reference(Reference_idReference,Document_idDocument) VALUES(?,?);";
    private static final String __REMOVE_DOCUMENT_REFERENCE = "DELETE FROM Document_Reference WHERE Reference_idReference = ? AND       Document_idDocument = ?;";
    private static final String __CHECK_DOCUMENT_REFERENCE = "SELECT Document_idDocument FROM Document_Reference WHERE Document_idDocument = ? AND Reference_idReference = ?;";
    private PreparedStatement statAddDocumentReference;
    private PreparedStatement statCheckDocumentReference;
    private PreparedStatement statRemoveDocumentReference;

    public DocumentReferenceDAO(KnowledgeBaseManager kbm) throws KnowledgeBaseException {
        this.kbm = kbm;
        try {
            this.statAddDocumentReference = this.kbm.getConnection().prepareStatement(__ADD_DOCUMENT_REFERENCE);
            this.statCheckDocumentReference = this.kbm.getConnection().prepareStatement(__CHECK_DOCUMENT_REFERENCE);
            this.statRemoveDocumentReference = this.kbm.getConnection().prepareStatement(__REMOVE_DOCUMENT_REFERENCE);
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public boolean addDocumentReference(Integer documentID, Integer referenceID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statAddDocumentReference.clearParameters();
            this.statAddDocumentReference.setInt(1, referenceID);
            this.statAddDocumentReference.setInt(2, documentID);
            result = this.statAddDocumentReference.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            ReferenceDAO referenceDAO = new ReferenceDAO(this.kbm);
            Reference reference = referenceDAO.getReference(referenceID);
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateDocumentEvent(CurrentProject.getInstance().getFactoryDAO().getDocumentDAO().getDocument(documentID)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceEvent(reference));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new DocumentRelationReferenceEvent());
            ReferenceGroup referenceGroup = referenceDAO.getReferenceGroup(referenceID);
            if (referenceGroup != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceGroupEvent(referenceGroup));
            } else {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceWithoutGroupEvent(reference));
            }
            ArrayList<AuthorReference> authorReferences = referenceDAO.getAuthorReferences(referenceID);
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorReferenceEvent(authorReferences));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorReferenceEvent(referenceDAO.getAuthorReferencesWithoutGroup(referenceID)));
            TreeSet<AuthorReferenceGroup> authorReferenceGroups = new TreeSet<AuthorReferenceGroup>();
            for (int i = 0; i < authorReferences.size(); ++i) {
                AuthorReferenceGroup authorReferenceGroup = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO().getAuthorReferenceGroup(authorReferences.get(i).getAuthorReferenceID());
                if (authorReferenceGroup == null) continue;
                authorReferenceGroups.add(authorReferenceGroup);
            }
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorReferenceGroupEvent(new ArrayList<AuthorReferenceGroup>(authorReferenceGroups)));
            ReferenceSource referenceSource = referenceDAO.getReferenceSource(referenceID);
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceSourceEvent(referenceSource));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceSourceEvent(referenceDAO.getReferenceSourceWithoutGroup(referenceID)));
            ReferenceSourceGroup referenceSourceGroup = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO().getReferenceSourceGroup(referenceSource.getReferenceSourceID());
            if (referenceSourceGroup != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceSourceGroupEvent(referenceSourceGroup));
            }
        }
        return result;
    }

    public boolean removeDocumentReference(Integer documentID, Integer referenceID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statRemoveDocumentReference.clearParameters();
            this.statRemoveDocumentReference.setInt(1, referenceID);
            this.statRemoveDocumentReference.setInt(2, documentID);
            result = this.statRemoveDocumentReference.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            ReferenceDAO referenceDAO = new ReferenceDAO(this.kbm);
            Reference reference = referenceDAO.getReference(referenceID);
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateDocumentEvent(CurrentProject.getInstance().getFactoryDAO().getDocumentDAO().getDocument(documentID)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceEvent(reference));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new DocumentRelationReferenceEvent());
            ReferenceGroup referenceGroup = referenceDAO.getReferenceGroup(referenceID);
            if (referenceGroup != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceGroupEvent(referenceGroup));
            } else {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceWithoutGroupEvent(reference));
            }
            ArrayList<AuthorReference> authorReferences = referenceDAO.getAuthorReferences(referenceID);
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorReferenceEvent(authorReferences));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorReferenceEvent(referenceDAO.getAuthorReferencesWithoutGroup(referenceID)));
            TreeSet<AuthorReferenceGroup> authorReferenceGroups = new TreeSet<AuthorReferenceGroup>();
            for (int i = 0; i < authorReferences.size(); ++i) {
                AuthorReferenceGroup authorReferenceGroup = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO().getAuthorReferenceGroup(authorReferences.get(i).getAuthorReferenceID());
                if (authorReferenceGroup == null) continue;
                authorReferenceGroups.add(authorReferenceGroup);
            }
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorReferenceGroupEvent(new ArrayList<AuthorReferenceGroup>(authorReferenceGroups)));
            ReferenceSource referenceSource = referenceDAO.getReferenceSource(referenceID);
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceSourceEvent(referenceSource));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceSourceEvent(referenceDAO.getReferenceSourceWithoutGroup(referenceID)));
            ReferenceSourceGroup referenceSourceGroup = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO().getReferenceSourceGroup(referenceSource.getReferenceSourceID());
            if (referenceSourceGroup != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceSourceGroupEvent(referenceSourceGroup));
            }
        }
        return result;
    }

    public boolean checkDocumentReference(Integer idDocument, Integer idReference) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckDocumentReference.clearParameters();
            this.statCheckDocumentReference.setInt(1, idDocument);
            this.statCheckDocumentReference.setInt(2, idReference);
            ResultSet rs = this.statCheckDocumentReference.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }
}

