/*
 * Decompiled with CFR 0.152.
 */
package scimat.model.knowledgebase.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.knowledgebaseevents.event.relation.ReferenceRelationAuthorReferenceEvent;
import scimat.knowledgebaseevents.event.update.UpdateAuthorReferenceEvent;
import scimat.knowledgebaseevents.event.update.UpdateAuthorReferenceGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateReferenceEvent;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.UtilsDAO;
import scimat.model.knowledgebase.entity.AuthorReferenceGroup;
import scimat.model.knowledgebase.entity.AuthorReferenceReference;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class AuthorReferenceReferenceDAO {
    private KnowledgeBaseManager kbm;
    private static final String __ADD_AUTHORREFERENCE_REFERENCE = "INSERT INTO AuthorReference_Reference(AuthorReference_idAuthorReference,Reference_idReference,position) VALUES(?,?,?);";
    private static final String __REMOVE_AUTHORREFERENCE_REFERENCE = "DELETE FROM AuthorReference_Reference WHERE AuthorReference_idAuthorReference = ? AND       Reference_idReference = ?;";
    private static final String __UPDATE_POSITION = "UPDATE AuthorReference_Reference SET position = ? WHERE AuthorReference_idAuthorReference = ? AND       Reference_idReference = ?;";
    private static final String __SELECT_AUTHORREFERENCES_REFERENCE = "SELECT r.*, ar.*, arr.position FROM AuthorReference_Reference arr, AuthorReference ar, Reference r WHERE r.idReference = ? AND       arr.AuthorReference_idAuthorReference = ? AND      r.idReference = arr.Reference_idReference AND       arr.AuthorReference_idAuthorReference = ar.idAuthorReference;";
    private static final String __CHECK_AUTHORREFERENCE_REFERENCE = "SELECT AuthorReference_idAuthorReference FROM AuthorReference_Reference WHERE AuthorReference_idAuthorReference = ? AND Reference_idReference = ?;";
    private static final String __SELECT_MAX_POSITION = "SELECT MAX(position) AS maxPosition FROM AuthorReference_Reference WHERE Reference_idReference = ?;";
    private PreparedStatement statAddAuthorReferenceReference;
    private PreparedStatement statCheckAuthorReferenceReference;
    private PreparedStatement statRemoveAuthorReferenceReference;
    private PreparedStatement statSelectAuthorReferenceReference;
    private PreparedStatement statSelectMaxPosition;
    private PreparedStatement statUpdatePosition;

    public AuthorReferenceReferenceDAO(KnowledgeBaseManager kbm) throws KnowledgeBaseException {
        this.kbm = kbm;
        try {
            this.statAddAuthorReferenceReference = this.kbm.getConnection().prepareStatement(__ADD_AUTHORREFERENCE_REFERENCE);
            this.statCheckAuthorReferenceReference = this.kbm.getConnection().prepareStatement(__CHECK_AUTHORREFERENCE_REFERENCE);
            this.statRemoveAuthorReferenceReference = this.kbm.getConnection().prepareStatement(__REMOVE_AUTHORREFERENCE_REFERENCE);
            this.statSelectAuthorReferenceReference = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORREFERENCES_REFERENCE);
            this.statSelectMaxPosition = this.kbm.getConnection().prepareStatement(__SELECT_MAX_POSITION);
            this.statUpdatePosition = this.kbm.getConnection().prepareStatement(__UPDATE_POSITION);
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e);
        }
    }

    public boolean addAuthorReferenceReference(Integer referenceID, Integer authorReferenceID, int position, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statAddAuthorReferenceReference.clearParameters();
            this.statAddAuthorReferenceReference.setInt(1, authorReferenceID);
            this.statAddAuthorReferenceReference.setInt(2, referenceID);
            this.statAddAuthorReferenceReference.setInt(3, position);
            result = this.statAddAuthorReferenceReference.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorReferenceEvent(CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO().getAuthorReference(authorReferenceID)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceEvent(CurrentProject.getInstance().getFactoryDAO().getReferenceDAO().getReference(referenceID)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new ReferenceRelationAuthorReferenceEvent());
            AuthorReferenceGroup authorReferenceGroup = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO().getAuthorReferenceGroup(authorReferenceID);
            if (authorReferenceGroup != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorReferenceGroupEvent(authorReferenceGroup));
            }
        }
        return result;
    }

    public boolean removeAuthorReferenceReference(Integer referenceID, Integer authorReferenceID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statRemoveAuthorReferenceReference.clearParameters();
            this.statRemoveAuthorReferenceReference.setInt(1, authorReferenceID);
            this.statRemoveAuthorReferenceReference.setInt(2, referenceID);
            result = this.statRemoveAuthorReferenceReference.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorReferenceEvent(CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO().getAuthorReference(authorReferenceID)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateReferenceEvent(CurrentProject.getInstance().getFactoryDAO().getReferenceDAO().getReference(referenceID)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new ReferenceRelationAuthorReferenceEvent());
            AuthorReferenceGroup authorReferenceGroup = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO().getAuthorReferenceGroup(authorReferenceID);
            if (authorReferenceGroup != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorReferenceGroupEvent(authorReferenceGroup));
            }
        }
        return result;
    }

    public boolean setPosition(Integer referenceID, Integer authorReferenceID, int position, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdatePosition.clearParameters();
            this.statUpdatePosition.setInt(1, position);
            this.statUpdatePosition.setInt(2, authorReferenceID);
            this.statUpdatePosition.setInt(3, referenceID);
            result = this.statUpdatePosition.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new ReferenceRelationAuthorReferenceEvent());
        }
        return result;
    }

    public boolean checkAuthorReferenceReference(Integer idAuhtorReference, Integer idReference) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckAuthorReferenceReference.clearParameters();
            this.statCheckAuthorReferenceReference.setInt(1, idAuhtorReference);
            this.statCheckAuthorReferenceReference.setInt(2, idReference);
            ResultSet rs = this.statCheckAuthorReferenceReference.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public AuthorReferenceReference getAuthorReferenceReference(Integer referenceID, Integer authorReferenceID) throws KnowledgeBaseException {
        AuthorReferenceReference authorReferenceReference = null;
        try {
            this.statSelectAuthorReferenceReference.clearParameters();
            this.statSelectAuthorReferenceReference.setInt(1, referenceID);
            this.statSelectAuthorReferenceReference.setInt(2, authorReferenceID);
            ResultSet rs = this.statSelectAuthorReferenceReference.executeQuery();
            while (rs.next()) {
                authorReferenceReference = UtilsDAO.getInstance().getAuthorReferenceReference(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorReferenceReference;
    }

    public int getMaxPosition(Integer referenceID) throws KnowledgeBaseException {
        int position = 0;
        try {
            this.statSelectMaxPosition.clearParameters();
            this.statSelectMaxPosition.setInt(1, referenceID);
            ResultSet rs = this.statSelectMaxPosition.executeQuery();
            if (rs.next()) {
                position = rs.getInt("maxPosition");
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return position;
    }
}

