/*
 * Decompiled with CFR 0.152.
 */
package scimat.model.knowledgebase.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.knowledgebaseevents.event.add.AddAuthorReferenceGroupEvent;
import scimat.knowledgebaseevents.event.relation.AuthorReferenceGroupRelationAuthorReferenceEvent;
import scimat.knowledgebaseevents.event.remove.RemoveAuthorReferenceGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateAuthorReferenceGroupEvent;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.UtilsDAO;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.entity.AuthorReferenceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorReferenceGroupDAO {
    private KnowledgeBaseManager kbm;
    private static final String __INSERT_AUTHORREFERENCEGROUP = "INSERT INTO AuthorReferenceGroup(groupName,stopGroup) VALUES(?,?);";
    private static final String __INSERT_AUTHORREFERENCEGROUP_WITH_ID = "INSERT INTO AuthorReferenceGroup(idAuthorReferenceGroup,groupName,stopGroup) VALUES(?,?,?);";
    private static final String __REMOVE_AUTHORREFERENCEGROUP = "DELETE FROM AuthorReferenceGroup WHERE idAuthorReferenceGroup = ?;";
    private static final String __UPDATE_GROUPNAME = "UPDATE AuthorReferenceGroup SET groupName = ? WHERE idAuthorReferenceGroup = ?;";
    private static final String __UPDATE_STOPGROUP = "UPDATE AuthorReferenceGroup SET stopGroup = ? WHERE idAuthorReferenceGroup = ?;";
    private static final String __UPDATE_AUTHORREFERENCEGROUP = "UPDATE AuthorReferenceGroup SET groupName = ?,     stopGroup = ? WHERE idAuthorReferenceGroup = ?;";
    private static final String __SELECT_AUTHORREFERENCE = "SELECT a.* FROM AuthorReference a, AuthorReferenceGroup ag WHERE ag.idAuthorReferenceGroup = ? AND       a.AuthorReferenceGroup_idAuthorReferenceGroup = ag.idAuthorReferenceGroup;";
    private static final String __SELECT_AUTHORREFERENCE_ID = "SELECT a.idAuthorReference FROM AuthorReference a, AuthorReferenceGroup ag WHERE ag.idAuthorReferenceGroup = ? AND       a.AuthorReferenceGroup_idAuthorReferenceGroup = ag.idAuthorReferenceGroup;";
    private final String __SELECT_AUTHORREFERENCEGROUP_BY_ID = "SELECT * FROM AuthorReferenceGroup WHERE idAuthorReferenceGroup = ?;";
    private final String __SELECT_AUTHORREFERENCEGROUP_BY_NAME = "SELECT * FROM AuthorReferenceGroup WHERE groupName = ?;";
    private final String __SELECT_AUTHORREFERENCEGROUP_BY_STOPGROUP = "SELECT * FROM AuthorReferenceGroup WHERE stopGroup = ?;";
    private final String __SELECT_AUTHORREFERENCEGROUPS = "SELECT * FROM AuthorReferenceGroup;";
    private final String __SELECT_AUTHORREFERENCEGROUP_IDS = "SELECT idAuthorReferenceGroup FROM AuthorReferenceGroup;";
    private final String __CHECK_AUTHORREFERENCEGROUP_BY_NAME = "SELECT idAuthorReferenceGroup FROM AuthorReferenceGroup WHERE groupName = ?;";
    private final String __CHECK_AUTHORREFERENCEGROUP_BY_ID = "SELECT idAuthorReferenceGroup FROM AuthorReferenceGroup WHERE idAuthorReferenceGroup = ?;";
    private PreparedStatement statCheckAuthorReferenceById;
    private PreparedStatement statCheckAuthorReferenceByName;
    private PreparedStatement statAddAuthorRefefenceGroup;
    private PreparedStatement statAddAuthorRefefenceGroupWithId;
    private PreparedStatement statRemoveAuthorRefefenceGroup;
    private PreparedStatement statSelectAuthorReferences;
    private PreparedStatement statSelectAuthorReferenceGroups;
    private PreparedStatement statSelectAuthorReferenceGroupById;
    private PreparedStatement statSelectAuthorReferenceGroupByName;
    private PreparedStatement statSelectAuthorReferenceGroupByStopGroup;
    private PreparedStatement statSelectAuthorReferenceGroupIds;
    private PreparedStatement statSelectAuthorReferenceIds;
    private PreparedStatement statUpdateAuthorReferenceGroup;
    private PreparedStatement statUpdateGroupName;
    private PreparedStatement statUpdateStopGroup;

    public AuthorReferenceGroupDAO(KnowledgeBaseManager kbm) throws KnowledgeBaseException {
        this.kbm = kbm;
        try {
            this.statCheckAuthorReferenceById = this.kbm.getConnection().prepareStatement("SELECT idAuthorReferenceGroup FROM AuthorReferenceGroup WHERE idAuthorReferenceGroup = ?;");
            this.statCheckAuthorReferenceByName = this.kbm.getConnection().prepareStatement("SELECT idAuthorReferenceGroup FROM AuthorReferenceGroup WHERE groupName = ?;");
            this.statAddAuthorRefefenceGroup = this.kbm.getConnection().prepareStatement(__INSERT_AUTHORREFERENCEGROUP, 1);
            this.statAddAuthorRefefenceGroupWithId = this.kbm.getConnection().prepareStatement(__INSERT_AUTHORREFERENCEGROUP_WITH_ID);
            this.statRemoveAuthorRefefenceGroup = this.kbm.getConnection().prepareStatement(__REMOVE_AUTHORREFERENCEGROUP);
            this.statSelectAuthorReferences = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORREFERENCE);
            this.statSelectAuthorReferenceGroups = this.kbm.getConnection().prepareStatement("SELECT * FROM AuthorReferenceGroup;");
            this.statSelectAuthorReferenceGroupById = this.kbm.getConnection().prepareStatement("SELECT * FROM AuthorReferenceGroup WHERE idAuthorReferenceGroup = ?;");
            this.statSelectAuthorReferenceGroupByName = this.kbm.getConnection().prepareStatement("SELECT * FROM AuthorReferenceGroup WHERE groupName = ?;");
            this.statSelectAuthorReferenceGroupByStopGroup = this.kbm.getConnection().prepareStatement("SELECT * FROM AuthorReferenceGroup WHERE stopGroup = ?;");
            this.statSelectAuthorReferenceGroupIds = this.kbm.getConnection().prepareStatement("SELECT idAuthorReferenceGroup FROM AuthorReferenceGroup;");
            this.statSelectAuthorReferenceIds = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORREFERENCE_ID);
            this.statUpdateAuthorReferenceGroup = this.kbm.getConnection().prepareStatement(__UPDATE_AUTHORREFERENCEGROUP);
            this.statUpdateGroupName = this.kbm.getConnection().prepareStatement(__UPDATE_GROUPNAME);
            this.statUpdateStopGroup = this.kbm.getConnection().prepareStatement(__UPDATE_STOPGROUP);
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public Integer addAuthorReferenceGroup(String groupName, boolean stopGroup, boolean notifyObservers) throws KnowledgeBaseException {
        Integer id;
        try {
            this.statAddAuthorRefefenceGroup.clearParameters();
            this.statAddAuthorRefefenceGroup.setString(1, groupName);
            this.statAddAuthorRefefenceGroup.setBoolean(2, stopGroup);
            if (this.statAddAuthorRefefenceGroup.executeUpdate() == 1) {
                id = this.statAddAuthorRefefenceGroup.getGeneratedKeys().getInt(1);
                this.statAddAuthorRefefenceGroup.getGeneratedKeys().close();
            } else {
                id = null;
            }
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddAuthorReferenceGroupEvent(this.getAuthorReferenceGroup(id)));
        }
        return id;
    }

    public boolean addAuthorReferenceGroup(Integer authorReferenceGroupID, String groupName, boolean stopGroup, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statAddAuthorRefefenceGroupWithId.clearParameters();
            this.statAddAuthorRefefenceGroupWithId.setInt(1, authorReferenceGroupID);
            this.statAddAuthorRefefenceGroupWithId.setString(2, groupName);
            this.statAddAuthorRefefenceGroupWithId.setBoolean(3, stopGroup);
            result = this.statAddAuthorRefefenceGroupWithId.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddAuthorReferenceGroupEvent(this.getAuthorReferenceGroup(authorReferenceGroupID)));
        }
        return result;
    }

    public boolean addAuthorReferenceGroup(AuthorReferenceGroup authorReferenceGroup, boolean notifyObservers) throws KnowledgeBaseException {
        return this.addAuthorReferenceGroup(authorReferenceGroup.getAuthorReferenceGroupID(), authorReferenceGroup.getGroupName(), authorReferenceGroup.isStopGroup(), notifyObservers);
    }

    public AuthorReferenceGroup getAuthorReferenceGroup(Integer idAuthorReferenceGroup) throws KnowledgeBaseException {
        AuthorReferenceGroup authorReferenceGroup = null;
        try {
            this.statSelectAuthorReferenceGroupById.clearParameters();
            this.statSelectAuthorReferenceGroupById.setInt(1, idAuthorReferenceGroup);
            ResultSet rs = this.statSelectAuthorReferenceGroupById.executeQuery();
            if (rs.next()) {
                authorReferenceGroup = UtilsDAO.getInstance().getAuthorReferenceGroup(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorReferenceGroup;
    }

    public AuthorReferenceGroup getAuthorReferenceGroup(String groupName) throws KnowledgeBaseException {
        AuthorReferenceGroup authorReferenceGroup = null;
        try {
            this.statSelectAuthorReferenceGroupByName.clearParameters();
            this.statSelectAuthorReferenceGroupByName.setString(1, groupName);
            ResultSet rs = this.statSelectAuthorReferenceGroupByName.executeQuery();
            if (rs.next()) {
                authorReferenceGroup = UtilsDAO.getInstance().getAuthorReferenceGroup(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorReferenceGroup;
    }

    public ArrayList<AuthorReferenceGroup> getAuthorReferenceGroups(boolean stopGroup) throws KnowledgeBaseException {
        ArrayList<AuthorReferenceGroup> authorReferenceGroupList = new ArrayList<AuthorReferenceGroup>();
        AuthorReferenceGroup authorReferenceGroup = null;
        try {
            this.statSelectAuthorReferenceGroupByStopGroup.clearParameters();
            this.statSelectAuthorReferenceGroupByStopGroup.setBoolean(1, stopGroup);
            ResultSet rs = this.statSelectAuthorReferenceGroupByStopGroup.executeQuery();
            while (rs.next()) {
                authorReferenceGroup = UtilsDAO.getInstance().getAuthorReferenceGroup(rs);
                authorReferenceGroupList.add(authorReferenceGroup);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorReferenceGroupList;
    }

    public ArrayList<AuthorReferenceGroup> getAuthorReferenceGroups() throws KnowledgeBaseException {
        ArrayList<AuthorReferenceGroup> authorReferenceGroupList = new ArrayList<AuthorReferenceGroup>();
        AuthorReferenceGroup authorReferenceGroup = null;
        try {
            this.statSelectAuthorReferenceGroups.clearParameters();
            ResultSet rs = this.statSelectAuthorReferenceGroups.executeQuery();
            while (rs.next()) {
                authorReferenceGroup = UtilsDAO.getInstance().getAuthorReferenceGroup(rs);
                authorReferenceGroupList.add(authorReferenceGroup);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorReferenceGroupList;
    }

    public ArrayList<Integer> getAuthorReferenceGroupIDs() throws KnowledgeBaseException {
        ArrayList<Integer> authorReferenceGroupList = new ArrayList<Integer>();
        try {
            this.statSelectAuthorReferenceGroupIds.clearParameters();
            ResultSet rs = this.statSelectAuthorReferenceGroupIds.executeQuery();
            while (rs.next()) {
                authorReferenceGroupList.add(UtilsDAO.getInstance().getAuthorReferenceGroupID(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorReferenceGroupList;
    }

    public boolean removeAuthorReferenceGroup(Integer authorReferenceGroupID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        AuthorReferenceGroup authorReferenceGroup = null;
        if (notifyObservers) {
            authorReferenceGroup = this.getAuthorReferenceGroup(authorReferenceGroupID);
        }
        try {
            this.statRemoveAuthorRefefenceGroup.clearParameters();
            this.statRemoveAuthorRefefenceGroup.setInt(1, authorReferenceGroupID);
            result = this.statRemoveAuthorRefefenceGroup.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new RemoveAuthorReferenceGroupEvent(authorReferenceGroup));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AuthorReferenceGroupRelationAuthorReferenceEvent());
        }
        return result;
    }

    public boolean setGroupName(Integer authorReferenceGroupID, String goupName, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateGroupName.clearParameters();
            this.statUpdateGroupName.setString(1, goupName);
            this.statUpdateGroupName.setInt(2, authorReferenceGroupID);
            result = this.statUpdateGroupName.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorReferenceGroupEvent(this.getAuthorReferenceGroup(authorReferenceGroupID)));
        }
        return result;
    }

    public boolean setStopGroup(Integer authorReferenceGroupID, boolean stopGroup, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateStopGroup.clearParameters();
            this.statUpdateStopGroup.setBoolean(1, stopGroup);
            this.statUpdateStopGroup.setInt(2, authorReferenceGroupID);
            result = this.statUpdateStopGroup.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorReferenceGroupEvent(this.getAuthorReferenceGroup(authorReferenceGroupID)));
        }
        return result;
    }

    public boolean updateAuthorReferenceGroup(Integer authorReferenceGroupID, String groupName, boolean stopGroup, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateAuthorReferenceGroup.clearParameters();
            this.statUpdateAuthorReferenceGroup.setString(1, groupName);
            this.statUpdateAuthorReferenceGroup.setBoolean(2, stopGroup);
            this.statUpdateAuthorReferenceGroup.setInt(3, authorReferenceGroupID);
            result = this.statUpdateAuthorReferenceGroup.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorReferenceGroupEvent(this.getAuthorReferenceGroup(authorReferenceGroupID)));
        }
        return result;
    }

    public ArrayList<AuthorReference> getAuthorReferences(Integer authorReferenceGroupID) throws KnowledgeBaseException {
        ArrayList<AuthorReference> authorsReferenceList = new ArrayList<AuthorReference>();
        try {
            this.statSelectAuthorReferences.clearParameters();
            this.statSelectAuthorReferences.setInt(1, authorReferenceGroupID);
            ResultSet rs = this.statSelectAuthorReferences.executeQuery();
            while (rs.next()) {
                authorsReferenceList.add(UtilsDAO.getInstance().getAuthorReference(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorsReferenceList;
    }

    public ArrayList<Integer> getAuthorReferenceIDs(Integer authorReferenceGroupID) throws KnowledgeBaseException {
        ArrayList<Integer> authorsReferenceList = new ArrayList<Integer>();
        try {
            this.statSelectAuthorReferenceIds.clearParameters();
            this.statSelectAuthorReferenceIds.setInt(1, authorReferenceGroupID);
            ResultSet rs = this.statSelectAuthorReferenceIds.executeQuery();
            while (rs.next()) {
                authorsReferenceList.add(UtilsDAO.getInstance().getAuthorReferenceID(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorsReferenceList;
    }

    public boolean checkAuthorReferenceGroup(String groupName) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckAuthorReferenceByName.clearParameters();
            this.statCheckAuthorReferenceByName.setString(1, groupName);
            ResultSet rs = this.statCheckAuthorReferenceByName.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public boolean checkAuthorReferenceGroup(Integer idAuthorReferenceGroup) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckAuthorReferenceById.clearParameters();
            this.statCheckAuthorReferenceById.setInt(1, idAuthorReferenceGroup);
            ResultSet rs = this.statCheckAuthorReferenceById.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public ArrayList<AuthorReferenceGroup> refreshAuthorReferenceGroups(ArrayList<AuthorReferenceGroup> authorReferenceGroupsToRefresh) throws KnowledgeBaseException {
        ArrayList<AuthorReferenceGroup> authorReferenceGroups = new ArrayList<AuthorReferenceGroup>();
        int i = 0;
        if (!authorReferenceGroupsToRefresh.isEmpty()) {
            String query = "SELECT * FROM AuthorReferenceGroup WHERE idAuthorReferenceGroup IN (" + authorReferenceGroupsToRefresh.get(i).getAuthorReferenceGroupID();
            for (i = 1; i < authorReferenceGroupsToRefresh.size(); ++i) {
                query = query + ", " + authorReferenceGroupsToRefresh.get(i).getAuthorReferenceGroupID();
            }
            query = query + ");";
            try {
                Statement stat = this.kbm.getConnection().createStatement();
                ResultSet rs = stat.executeQuery(query);
                while (rs.next()) {
                    authorReferenceGroups.add(UtilsDAO.getInstance().getAuthorReferenceGroup(rs));
                }
                rs.close();
                stat.close();
            }
            catch (SQLException e) {
                throw new KnowledgeBaseException(e.getMessage(), e.getCause());
            }
        }
        return authorReferenceGroups;
    }

    public AuthorReferenceGroup refreshAuthorReferenceGroup(AuthorReferenceGroup authorReferenceGroupToRefresh) throws KnowledgeBaseException {
        return this.getAuthorReferenceGroup(authorReferenceGroupToRefresh.getAuthorReferenceGroupID());
    }
}

