/*
 * Decompiled with CFR 0.152.
 */
package scimat.model.knowledgebase.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.knowledgebaseevents.event.add.AddAuthorReferenceEvent;
import scimat.knowledgebaseevents.event.add.AddAuthorReferenceWithoutGroupEvent;
import scimat.knowledgebaseevents.event.relation.AuthorReferenceGroupRelationAuthorReferenceEvent;
import scimat.knowledgebaseevents.event.relation.AuthorRelationAuthorReferenceEvent;
import scimat.knowledgebaseevents.event.relation.ReferenceRelationAuthorReferenceEvent;
import scimat.knowledgebaseevents.event.remove.RemoveAuthorReferenceEvent;
import scimat.knowledgebaseevents.event.remove.RemoveAuthorReferenceWithoutGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateAuthorEvent;
import scimat.knowledgebaseevents.event.update.UpdateAuthorReferenceEvent;
import scimat.knowledgebaseevents.event.update.UpdateAuthorReferenceGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateAuthorReferenceWithoutGroupEvent;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.UtilsDAO;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.entity.AuthorReferenceGroup;
import scimat.model.knowledgebase.entity.AuthorReferenceReference;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorReferenceDAO {
    private KnowledgeBaseManager kbm;
    private static final String __INSERT_AUTHROR_REFERENCE = "INSERT INTO AuthorReference(authorName) VALUES(?);";
    private static final String __INSERT_AUTHROR_REFERENCE_WITH_ID = "INSERT INTO AuthorReference(idAuthorReference, authorName) VALUES(?,?);";
    private static final String __REMOVE_AUTHORREFERENCE = "DELETE FROM AuthorReference WHERE idAuthorReference = ?;";
    private static final String __UPDATE_AUTHORNAME = "UPDATE AuthorReference SET authorName = ? WHERE idAuthorReference = ?;";
    private static final String __UPDATE_AUTHORREFERENCEGROUP = "UPDATE AuthorReference SET AuthorReferenceGroup_idAuthorReferenceGroup = ? WHERE idAuthorReference = ?;";
    private static final String __UPDATE_AUTHOR = "UPDATE AuthorReference SET Author_idAuthor = ? WHERE idAuthorReference = ?;";
    private static final String __SELECT_AUTHORREFERENCEGROUP = "SELECT arg.* FROM AuthorReference ar, AuthorReferenceGroup arg WHERE ar.idAuthorReference = ? AND       ar.AuthorReferenceGroup_idAuthorReferenceGroup = arg.idAuthorReferenceGroup;";
    private static final String __SELECT_AUTHORREFERENCEGROUP_ID = "SELECT arg.idAuthorReferenceGroup FROM AuthorReference ar, AuthorReferenceGroup arg WHERE ar.idAuthorReference = ? AND       ar.AuthorReferenceGroup_idAuthorReferenceGroup = arg.idAuthorReferenceGroup;";
    private static final String __SELECT_AUTHOR = "SELECT a.* FROM AuthorReference ar, Author a WHERE ar.idAuthorReference = ? AND       ar.Author_idAuthor = a.idAuthor;";
    private static final String __SELECT_AUTHOR_ID = "SELECT a.idAuthor FROM AuthorReference ar, Author a WHERE ar.idAuthorReference = ? AND       ar.Author_idAuthor = a.idAuthor;";
    private static final String __SELECT_AUTHORREFERENCEREFERENCE = "SELECT r.*, ar.*, arr.position FROM AuthorReference_Reference arr, AuthorReference ar, Reference r WHERE ar.idAuthorReference = ? AND       ar.idAuthorReference = arr.AuthorReference_idAuthorReference AND       arr.Reference_idReference = r.idReference;";
    private static final String __SELECT_AUTHORREFERENCE_BY_ID = "SELECT * FROM AuthorReference WHERE idAuthorReference = ?;";
    private static final String __SELECT_AUTHORREFERENCE_BY_NAME = "SELECT * FROM AuthorReference WHERE authorName = ?;";
    private static final String __SELECT_AUTHORREFERENCES = "SELECT * FROM AuthorReference;";
    private static final String __SELECT_AUTHORREFERENCE_IDS = "SELECT idAuthorReference FROM AuthorReference;";
    private static final String __SELECT_AUTHORREFERENCES_WITHOUTGROUP = "SELECT * FROM AuthorReference WHERE AuthorReferenceGroup_idAuthorReferenceGroup IS NULL;";
    private static final String __SELECT_AUTHORREFERENCE_WITHOUTGROUP_IDS = "SELECT idAuthorReference FROM AuthorReference WHERE AuthorReferenceGroup_idAuthorReferenceGroup IS NULL;";
    private static final String __CHECK_AUTHORREFEFENCE_BY_NAME = "SELECT idAuthorReference FROM AuthorReference WHERE authorName = ?;";
    private static final String __CHECK_AUTHORREFERENCE_BY_ID = "SELECT idAuthorReference FROM AuthorReference WHERE idAuthorReference = ?;";
    private PreparedStatement statCheckAuthorReferenceByName;
    private PreparedStatement statCheckAuthorReferenceById;
    private PreparedStatement statAddAuthorReference;
    private PreparedStatement statAddAuthorReferenceWithId;
    private PreparedStatement statRemoveAuthorReference;
    private PreparedStatement statSelectAuthor;
    private PreparedStatement statSelectAuthorId;
    private PreparedStatement statSelectAuthorReferenceGroup;
    private PreparedStatement statSelectAuthorReferenceGroupId;
    private PreparedStatement statSelectAuthorReferenceReference;
    private PreparedStatement statSelectAuthorReferences;
    private PreparedStatement statSelectAuthorReferencesWithoutGroup;
    private PreparedStatement statSelectAuthorReferenceById;
    private PreparedStatement statSelectAuthorReferenceByName;
    private PreparedStatement statSelectAuthorReferenceIds;
    private PreparedStatement statSelectAuthorReferenceWithoutGroupIds;
    private PreparedStatement statUpdateAuthorName;
    private PreparedStatement statUpdateAuthor;
    private PreparedStatement statUpdateAuthorReferenceGroup;

    public AuthorReferenceDAO(KnowledgeBaseManager kbm) throws KnowledgeBaseException {
        this.kbm = kbm;
        try {
            this.statCheckAuthorReferenceByName = this.kbm.getConnection().prepareStatement(__CHECK_AUTHORREFEFENCE_BY_NAME);
            this.statCheckAuthorReferenceById = this.kbm.getConnection().prepareStatement(__CHECK_AUTHORREFERENCE_BY_ID);
            this.statAddAuthorReference = this.kbm.getConnection().prepareStatement(__INSERT_AUTHROR_REFERENCE, 1);
            this.statAddAuthorReferenceWithId = this.kbm.getConnection().prepareStatement(__INSERT_AUTHROR_REFERENCE_WITH_ID);
            this.statRemoveAuthorReference = this.kbm.getConnection().prepareStatement(__REMOVE_AUTHORREFERENCE);
            this.statSelectAuthor = this.kbm.getConnection().prepareStatement(__SELECT_AUTHOR);
            this.statSelectAuthorId = this.kbm.getConnection().prepareStatement(__SELECT_AUTHOR_ID);
            this.statSelectAuthorReferenceGroup = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORREFERENCEGROUP);
            this.statSelectAuthorReferenceGroupId = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORREFERENCEGROUP_ID);
            this.statSelectAuthorReferenceReference = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORREFERENCEREFERENCE);
            this.statSelectAuthorReferences = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORREFERENCES);
            this.statSelectAuthorReferencesWithoutGroup = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORREFERENCES_WITHOUTGROUP);
            this.statSelectAuthorReferenceById = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORREFERENCE_BY_ID);
            this.statSelectAuthorReferenceByName = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORREFERENCE_BY_NAME);
            this.statSelectAuthorReferenceIds = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORREFERENCE_IDS);
            this.statSelectAuthorReferenceWithoutGroupIds = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORREFERENCE_WITHOUTGROUP_IDS);
            this.statUpdateAuthorName = this.kbm.getConnection().prepareStatement(__UPDATE_AUTHORNAME);
            this.statUpdateAuthor = this.kbm.getConnection().prepareStatement(__UPDATE_AUTHOR);
            this.statUpdateAuthorReferenceGroup = this.kbm.getConnection().prepareStatement(__UPDATE_AUTHORREFERENCEGROUP);
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public Integer addAuthorReference(String authorName, boolean notifyObservers) throws KnowledgeBaseException {
        Integer id;
        try {
            this.statAddAuthorReference.clearParameters();
            this.statAddAuthorReference.setString(1, authorName);
            if (this.statAddAuthorReference.executeUpdate() == 1) {
                id = this.statAddAuthorReference.getGeneratedKeys().getInt(1);
                this.statAddAuthorReference.getGeneratedKeys().close();
            } else {
                id = null;
            }
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddAuthorReferenceEvent(this.getAuthorReference(id)));
        }
        return id;
    }

    public boolean addAuthorReference(Integer authorReferenceID, String authorName, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statAddAuthorReferenceWithId.clearParameters();
            this.statAddAuthorReferenceWithId.setInt(1, authorReferenceID);
            this.statAddAuthorReferenceWithId.setString(2, authorName);
            result = this.statAddAuthorReferenceWithId.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddAuthorReferenceEvent(this.getAuthorReference(authorReferenceID)));
        }
        return result;
    }

    public boolean addAuthorReference(AuthorReference authorReference, boolean notifyObservers) throws KnowledgeBaseException {
        return this.addAuthorReference(authorReference.getAuthorReferenceID(), authorReference.getAuthorName(), notifyObservers);
    }

    public boolean removeAuthorReference(Integer authorReferenceID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        AuthorReference authorReference = null;
        AuthorReferenceGroup authorReferenceGroup = null;
        if (notifyObservers) {
            authorReference = this.getAuthorReference(authorReferenceID);
            authorReferenceGroup = this.getAuthorReferenceGroup(authorReferenceID);
        }
        try {
            this.statRemoveAuthorReference.clearParameters();
            this.statRemoveAuthorReference.setInt(1, authorReferenceID);
            result = this.statRemoveAuthorReference.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new RemoveAuthorReferenceEvent(authorReference));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new ReferenceRelationAuthorReferenceEvent());
            if (authorReferenceGroup != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorReferenceGroupEvent(CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceGroupDAO().refreshAuthorReferenceGroup(authorReferenceGroup)));
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new AuthorReferenceGroupRelationAuthorReferenceEvent());
            } else {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new RemoveAuthorReferenceWithoutGroupEvent(authorReference));
            }
        }
        return result;
    }

    public AuthorReference getAuthorReference(Integer idAuthorReference) throws KnowledgeBaseException {
        AuthorReference authorReference = null;
        try {
            this.statSelectAuthorReferenceById.clearParameters();
            this.statSelectAuthorReferenceById.setInt(1, idAuthorReference);
            ResultSet rs = this.statSelectAuthorReferenceById.executeQuery();
            if (rs.next()) {
                authorReference = UtilsDAO.getInstance().getAuthorReference(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorReference;
    }

    public AuthorReference getAuthorReference(String authorName) throws KnowledgeBaseException {
        AuthorReference authorReference = null;
        try {
            this.statSelectAuthorReferenceByName.clearParameters();
            this.statSelectAuthorReferenceByName.setString(1, authorName);
            ResultSet rs = this.statSelectAuthorReferenceByName.executeQuery();
            if (rs.next()) {
                authorReference = UtilsDAO.getInstance().getAuthorReference(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorReference;
    }

    public ArrayList<AuthorReference> getAuthorReferences() throws KnowledgeBaseException {
        ArrayList<AuthorReference> authorReferenceList = new ArrayList<AuthorReference>();
        try {
            this.statSelectAuthorReferences.clearParameters();
            ResultSet rs = this.statSelectAuthorReferences.executeQuery();
            while (rs.next()) {
                authorReferenceList.add(UtilsDAO.getInstance().getAuthorReference(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorReferenceList;
    }

    public ArrayList<Integer> getAuthorReferenceIDs() throws KnowledgeBaseException {
        ArrayList<Integer> authorReferenceList = new ArrayList<Integer>();
        try {
            this.statSelectAuthorReferenceIds.clearParameters();
            ResultSet rs = this.statSelectAuthorReferenceIds.executeQuery();
            while (rs.next()) {
                authorReferenceList.add(UtilsDAO.getInstance().getAuthorReferenceID(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorReferenceList;
    }

    public ArrayList<AuthorReference> getAuthorReferencesWithoutGroup() throws KnowledgeBaseException {
        ArrayList<AuthorReference> authorReferenceList = new ArrayList<AuthorReference>();
        try {
            this.statSelectAuthorReferencesWithoutGroup.clearParameters();
            ResultSet rs = this.statSelectAuthorReferencesWithoutGroup.executeQuery();
            while (rs.next()) {
                authorReferenceList.add(UtilsDAO.getInstance().getAuthorReference(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorReferenceList;
    }

    public ArrayList<Integer> getAuthorReferenceIDsWithoutGroup() throws KnowledgeBaseException {
        ArrayList<Integer> authorReferenceList = new ArrayList<Integer>();
        try {
            this.statSelectAuthorReferenceWithoutGroupIds.clearParameters();
            ResultSet rs = this.statSelectAuthorReferenceWithoutGroupIds.executeQuery();
            while (rs.next()) {
                authorReferenceList.add(UtilsDAO.getInstance().getAuthorReferenceID(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorReferenceList;
    }

    public boolean setAuthorName(Integer authorReferenceID, String authorName, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateAuthorName.clearParameters();
            this.statUpdateAuthorName.setString(1, authorName);
            this.statUpdateAuthorName.setInt(2, authorReferenceID);
            result = this.statUpdateAuthorName.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            AuthorReference authorReference = this.getAuthorReference(authorReferenceID);
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorReferenceEvent(authorReference));
            if (this.getAuthorReferenceGroup(authorReferenceID) == null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorReferenceWithoutGroupEvent(authorReference));
            }
        }
        return result;
    }

    public boolean setAuthorReferenceGroup(Integer authorReferenceID, Integer authorReferenceGroupID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        AuthorReferenceGroup oldAuthorReferenceGroup = null;
        if (notifyObservers) {
            oldAuthorReferenceGroup = this.getAuthorReferenceGroup(authorReferenceID);
        }
        try {
            this.statUpdateAuthorReferenceGroup.clearParameters();
            if (authorReferenceGroupID != null) {
                this.statUpdateAuthorReferenceGroup.setInt(1, authorReferenceGroupID);
            } else {
                this.statUpdateAuthorReferenceGroup.setNull(1, 0);
            }
            this.statUpdateAuthorReferenceGroup.setInt(2, authorReferenceID);
            result = this.statUpdateAuthorReferenceGroup.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            if (oldAuthorReferenceGroup != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorReferenceGroupEvent(CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceGroupDAO().refreshAuthorReferenceGroup(oldAuthorReferenceGroup)));
                if (authorReferenceGroupID == null) {
                    KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddAuthorReferenceWithoutGroupEvent(this.getAuthorReference(authorReferenceID)));
                }
            } else if (authorReferenceGroupID != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new RemoveAuthorReferenceWithoutGroupEvent(this.getAuthorReference(authorReferenceID)));
            }
            if (authorReferenceGroupID != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorReferenceGroupEvent(this.getAuthorReferenceGroup(authorReferenceID)));
            }
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AuthorReferenceGroupRelationAuthorReferenceEvent());
        }
        return result;
    }

    public boolean setAuthor(Integer authorReferenceID, Integer authorID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateAuthor.clearParameters();
            this.statUpdateAuthor.setInt(1, authorID);
            this.statUpdateAuthor.setInt(2, authorReferenceID);
            result = this.statUpdateAuthor.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorEvent(this.getAuthor(authorReferenceID)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AuthorRelationAuthorReferenceEvent());
        }
        return result;
    }

    public AuthorReferenceGroup getAuthorReferenceGroup(Integer authorReferenceID) throws KnowledgeBaseException {
        AuthorReferenceGroup authorReferenceGroup = null;
        try {
            this.statSelectAuthorReferenceGroup.clearParameters();
            this.statSelectAuthorReferenceGroup.setInt(1, authorReferenceID);
            ResultSet rs = this.statSelectAuthorReferenceGroup.executeQuery();
            if (rs.next()) {
                authorReferenceGroup = UtilsDAO.getInstance().getAuthorReferenceGroup(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorReferenceGroup;
    }

    public Integer getAuthorReferenceGroupID(Integer authorReferenceID) throws KnowledgeBaseException {
        Integer authorReferenceGroupID = null;
        try {
            this.statSelectAuthorReferenceGroupId.clearParameters();
            this.statSelectAuthorReferenceGroupId.setInt(1, authorReferenceID);
            ResultSet rs = this.statSelectAuthorReferenceGroupId.executeQuery();
            if (rs.next()) {
                authorReferenceGroupID = UtilsDAO.getInstance().getAuthorReferenceGroupID(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorReferenceGroupID;
    }

    public Author getAuthor(Integer authorReferenceID) throws KnowledgeBaseException {
        Author author = null;
        try {
            this.statSelectAuthor.clearParameters();
            this.statSelectAuthor.setInt(1, authorReferenceID);
            ResultSet rs = this.statSelectAuthor.executeQuery();
            if (rs.next()) {
                author = UtilsDAO.getInstance().getAuthor(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return author;
    }

    public Integer getAuthorID(Integer authorReferenceID) throws KnowledgeBaseException {
        Integer authorID = null;
        try {
            this.statSelectAuthorId.clearParameters();
            this.statSelectAuthorId.setInt(1, authorReferenceID);
            ResultSet rs = this.statSelectAuthorId.executeQuery();
            if (rs.next()) {
                authorID = UtilsDAO.getInstance().getAuthorID(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorID;
    }

    public ArrayList<AuthorReferenceReference> getReferences(Integer authorReferenceID) throws KnowledgeBaseException {
        ArrayList<AuthorReferenceReference> referencesList = new ArrayList<AuthorReferenceReference>();
        try {
            this.statSelectAuthorReferenceReference.clearParameters();
            this.statSelectAuthorReferenceReference.setInt(1, authorReferenceID);
            ResultSet rs = this.statSelectAuthorReferenceReference.executeQuery();
            while (rs.next()) {
                referencesList.add(UtilsDAO.getInstance().getAuthorReferenceReference(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return referencesList;
    }

    public boolean checkAuthorReference(String authorName) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckAuthorReferenceByName.clearParameters();
            this.statCheckAuthorReferenceByName.setString(1, authorName);
            ResultSet rs = this.statCheckAuthorReferenceByName.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public boolean checkAuthorReference(Integer idAuthorReference) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckAuthorReferenceById.clearParameters();
            this.statCheckAuthorReferenceById.setInt(1, idAuthorReference);
            ResultSet rs = this.statCheckAuthorReferenceById.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public ArrayList<AuthorReference> refreshAuthorReferences(ArrayList<AuthorReference> authorReferencesToRefresh) throws KnowledgeBaseException {
        ArrayList<AuthorReference> authorReferences = new ArrayList<AuthorReference>();
        int i = 0;
        if (!authorReferencesToRefresh.isEmpty()) {
            String query = "SELECT * FROM AuthorReference WHERE idAuthorReference IN (" + authorReferencesToRefresh.get(i).getAuthorReferenceID();
            for (i = 1; i < authorReferencesToRefresh.size(); ++i) {
                query = query + ", " + authorReferencesToRefresh.get(i).getAuthorReferenceID();
            }
            query = query + ");";
            try {
                Statement stat = this.kbm.getConnection().createStatement();
                ResultSet rs = stat.executeQuery(query);
                while (rs.next()) {
                    authorReferences.add(UtilsDAO.getInstance().getAuthorReference(rs));
                }
                rs.close();
                stat.close();
            }
            catch (SQLException e) {
                throw new KnowledgeBaseException(e.getMessage(), e.getCause());
            }
        }
        return authorReferences;
    }

    public AuthorReference refreshAuthorReference(AuthorReference authorReferenceToRefresh) throws KnowledgeBaseException {
        return this.getAuthorReference(authorReferenceToRefresh.getAuthorReferenceID());
    }
}

