/*
 * Decompiled with CFR 0.152.
 */
package scimat.model.knowledgebase.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.knowledgebaseevents.event.add.AddAuthorGroupEvent;
import scimat.knowledgebaseevents.event.relation.AuthorGroupRelationAuthorEvent;
import scimat.knowledgebaseevents.event.remove.RemoveAuthorGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateAuthorGroupEvent;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.UtilsDAO;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.AuthorGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorGroupDAO {
    private KnowledgeBaseManager kbm;
    private static final String __INSERT_AUTHORGROUP = "INSERT INTO AuthorGroup(groupName,stopGroup) VALUES(?,?);";
    private static final String __INSERT_AUTHORGROUP_WITH_ID = "INSERT INTO AuthorGroup(idAuthorGroup,groupName,stopGroup) VALUES(?,?,?);";
    private static final String __REMOVE_AUTHORGROUP = "DELETE FROM AuthorGroup WHERE idAuthorGroup = ?;";
    private static final String __UPDATE_GROUPNAME = "UPDATE AuthorGroup SET groupName = ? WHERE idAuthorGroup = ?";
    private static final String __UPDATE_STOPGROUP = "UPDATE AuthorGroup SET stopGroup = ? WHERE idAuthorGroup = ?;";
    private static final String __UPDATE_AUTHORGROUP = "UPDATE AuthorGroup SET groupName = ?,     stopGroup = ? WHERE idAuthorGroup = ?;";
    private static final String __SELECT_AUTHORS = "SELECT a.* FROM Author a, AuthorGroup ag WHERE ag.idAuthorGroup = ? AND       a.AuthorGroup_idAuthorGroup = ag.idAuthorGroup;";
    private static final String __SELECT_AUTHOR_IDS = "SELECT a.idAuthor FROM Author a, AuthorGroup ag WHERE ag.idAuthorGroup = ? AND       a.AuthorGroup_idAuthorGroup = ag.idAuthorGroup;";
    private static final String __SELECT_AUTHORGROUP_BY_ID = "SELECT * FROM AuthorGroup WHERE idAuthorGroup = ?;";
    private static final String __SELECT_AUTHORGROUP_BY_GROUPNAME = "SELECT * FROM AuthorGroup WHERE groupName = ?;";
    private static final String __SELECT_AUTHORGROUP_BY_STOPGROUP = "SELECT * FROM AuthorGroup WHERE stopGroup = ?;";
    private static final String __SELECT_AUTHORGROUPS = "SELECT * FROM AuthorGroup;";
    private static final String __SELECT_AUTHORGROUP_IDS = "SELECT idAuthorGroup FROM AuthorGroup;";
    private static final String __CHECK_AUTHORGROUP_BY_GROUPNAME = "SELECT idAuthorGroup FROM AuthorGroup WHERE groupName = ?;";
    private static final String __CHECK_AUTHORGROUP_BY_ID = "SELECT idAuthorGroup FROM AuthorGroup WHERE idAuthorGroup = ?;";
    private PreparedStatement statCheckAuthorGroupByGroupName;
    private PreparedStatement statCheckAuthorGroupById;
    private PreparedStatement statAddAuthorGroup;
    private PreparedStatement statAddAuthorGroupWithId;
    private PreparedStatement statRemoveAuthorGroup;
    private PreparedStatement statSelectAuthors;
    private PreparedStatement statSelectAuthorGroups;
    private PreparedStatement statSelectAuthorGroupByGroupName;
    private PreparedStatement statSelectAuthorGroupById;
    private PreparedStatement statSelectAuthorGroupsByStopGroup;
    private PreparedStatement statSelectAuthorGroupIds;
    private PreparedStatement statSelectAuthorIds;
    private PreparedStatement statUpdateAuthorGroup;
    private PreparedStatement statUpdateGroupName;
    private PreparedStatement statUpdateStopGroup;

    public AuthorGroupDAO(KnowledgeBaseManager kbm) throws KnowledgeBaseException {
        this.kbm = kbm;
        try {
            this.statCheckAuthorGroupByGroupName = this.kbm.getConnection().prepareStatement(__CHECK_AUTHORGROUP_BY_GROUPNAME);
            this.statCheckAuthorGroupById = this.kbm.getConnection().prepareStatement(__CHECK_AUTHORGROUP_BY_ID);
            this.statAddAuthorGroup = this.kbm.getConnection().prepareStatement(__INSERT_AUTHORGROUP, 1);
            this.statAddAuthorGroupWithId = this.kbm.getConnection().prepareStatement(__INSERT_AUTHORGROUP_WITH_ID);
            this.statRemoveAuthorGroup = this.kbm.getConnection().prepareStatement(__REMOVE_AUTHORGROUP);
            this.statSelectAuthors = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORS);
            this.statSelectAuthorGroups = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORGROUPS);
            this.statSelectAuthorGroupByGroupName = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORGROUP_BY_GROUPNAME);
            this.statSelectAuthorGroupById = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORGROUP_BY_ID);
            this.statSelectAuthorGroupsByStopGroup = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORGROUP_BY_STOPGROUP);
            this.statSelectAuthorGroupIds = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORGROUP_IDS);
            this.statSelectAuthorIds = this.kbm.getConnection().prepareStatement(__SELECT_AUTHOR_IDS);
            this.statUpdateAuthorGroup = this.kbm.getConnection().prepareStatement(__UPDATE_AUTHORGROUP);
            this.statUpdateGroupName = this.kbm.getConnection().prepareStatement(__UPDATE_GROUPNAME);
            this.statUpdateStopGroup = this.kbm.getConnection().prepareStatement(__UPDATE_STOPGROUP);
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public Integer addAuthorGroup(String groupName, boolean stopGroup, boolean notifyObservers) throws KnowledgeBaseException {
        Integer id;
        try {
            this.statAddAuthorGroup.clearParameters();
            this.statAddAuthorGroup.setString(1, groupName);
            this.statAddAuthorGroup.setBoolean(2, stopGroup);
            if (this.statAddAuthorGroup.executeUpdate() == 1) {
                id = this.statAddAuthorGroup.getGeneratedKeys().getInt(1);
                this.statAddAuthorGroup.getGeneratedKeys().close();
            } else {
                id = null;
            }
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddAuthorGroupEvent(this.getAuthorGroup(id)));
        }
        return id;
    }

    public boolean addAuthorGroup(Integer authorGroupID, String groupName, boolean stopGroup, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statAddAuthorGroupWithId.clearParameters();
            this.statAddAuthorGroupWithId.setInt(1, authorGroupID);
            this.statAddAuthorGroupWithId.setString(2, groupName);
            this.statAddAuthorGroupWithId.setBoolean(3, stopGroup);
            result = this.statAddAuthorGroupWithId.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddAuthorGroupEvent(this.getAuthorGroup(authorGroupID)));
        }
        return result;
    }

    public boolean addAuthorGroup(AuthorGroup authorGroup, boolean notifyObservers) throws KnowledgeBaseException {
        return this.addAuthorGroup(authorGroup.getAuthorGroupID(), authorGroup.getGroupName(), authorGroup.isStopGroup(), notifyObservers);
    }

    public boolean removeAuthorGroup(Integer authorGroupID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        AuthorGroup authorGroup = null;
        if (notifyObservers) {
            authorGroup = this.getAuthorGroup(authorGroupID);
        }
        try {
            this.statRemoveAuthorGroup.clearParameters();
            this.statRemoveAuthorGroup.setInt(1, authorGroupID);
            result = this.statRemoveAuthorGroup.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new RemoveAuthorGroupEvent(authorGroup));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AuthorGroupRelationAuthorEvent());
        }
        return result;
    }

    public AuthorGroup getAuthorGroup(Integer idAuthorGroup) throws KnowledgeBaseException {
        AuthorGroup authorGroup = null;
        try {
            this.statSelectAuthorGroupById.clearParameters();
            this.statSelectAuthorGroupById.setInt(1, idAuthorGroup);
            ResultSet rs = this.statSelectAuthorGroupById.executeQuery();
            if (rs.next()) {
                authorGroup = UtilsDAO.getInstance().getAuthorGroup(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorGroup;
    }

    public AuthorGroup getAuthorGroup(String groupName) throws KnowledgeBaseException {
        AuthorGroup authorGroup = null;
        try {
            this.statSelectAuthorGroupByGroupName.clearParameters();
            this.statSelectAuthorGroupByGroupName.setString(1, groupName);
            ResultSet rs = this.statSelectAuthorGroupByGroupName.executeQuery();
            if (rs.next()) {
                authorGroup = UtilsDAO.getInstance().getAuthorGroup(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorGroup;
    }

    public ArrayList<AuthorGroup> getAuthorGroups(boolean stopGroup) throws KnowledgeBaseException {
        ArrayList<AuthorGroup> authorGroupList = new ArrayList<AuthorGroup>();
        AuthorGroup authorGroup = null;
        try {
            this.statSelectAuthorGroupsByStopGroup.clearParameters();
            this.statSelectAuthorGroupsByStopGroup.setBoolean(1, stopGroup);
            ResultSet rs = this.statSelectAuthorGroupsByStopGroup.executeQuery();
            while (rs.next()) {
                authorGroup = UtilsDAO.getInstance().getAuthorGroup(rs);
                authorGroupList.add(authorGroup);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorGroupList;
    }

    public ArrayList<AuthorGroup> getAuthorGroups() throws KnowledgeBaseException {
        ArrayList<AuthorGroup> authorGroupList = new ArrayList<AuthorGroup>();
        AuthorGroup authorGroup = null;
        try {
            this.statSelectAuthorGroups.clearParameters();
            ResultSet rs = this.statSelectAuthorGroups.executeQuery();
            while (rs.next()) {
                authorGroup = UtilsDAO.getInstance().getAuthorGroup(rs);
                authorGroupList.add(authorGroup);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorGroupList;
    }

    public ArrayList<Integer> getAuthorGroupIDs() throws KnowledgeBaseException {
        ArrayList<Integer> authorGroupList = new ArrayList<Integer>();
        try {
            this.statSelectAuthorGroupIds.clearParameters();
            ResultSet rs = this.statSelectAuthorGroupIds.executeQuery();
            while (rs.next()) {
                authorGroupList.add(UtilsDAO.getInstance().getAuthorGroupID(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorGroupList;
    }

    public boolean setGroupName(Integer authorGroupID, String goupName, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateGroupName.clearParameters();
            this.statUpdateGroupName.setString(1, goupName);
            this.statUpdateGroupName.setInt(2, authorGroupID);
            result = this.statUpdateGroupName.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorGroupEvent(this.getAuthorGroup(authorGroupID)));
        }
        return result;
    }

    public boolean setStopGroup(Integer authorGroupID, boolean stopGroup, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateStopGroup.clearParameters();
            this.statUpdateStopGroup.setBoolean(1, stopGroup);
            this.statUpdateStopGroup.setInt(2, authorGroupID);
            result = this.statUpdateStopGroup.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorGroupEvent(this.getAuthorGroup(authorGroupID)));
        }
        return result;
    }

    public boolean updateAuthorGroup(Integer authorGroupID, String groupName, boolean stopGroup, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateAuthorGroup.clearParameters();
            this.statUpdateAuthorGroup.setString(1, groupName);
            this.statUpdateAuthorGroup.setBoolean(2, stopGroup);
            this.statUpdateAuthorGroup.setInt(3, authorGroupID);
            result = this.statUpdateAuthorGroup.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorGroupEvent(this.getAuthorGroup(authorGroupID)));
        }
        return result;
    }

    public ArrayList<Author> getAuthors(Integer authorGroupID) throws KnowledgeBaseException {
        ArrayList<Author> authorsList = new ArrayList<Author>();
        try {
            this.statSelectAuthors.clearParameters();
            this.statSelectAuthors.setInt(1, authorGroupID);
            ResultSet rs = this.statSelectAuthors.executeQuery();
            while (rs.next()) {
                authorsList.add(UtilsDAO.getInstance().getAuthor(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorsList;
    }

    public ArrayList<Integer> getAuthorIDs(Integer authorGroupID) throws KnowledgeBaseException {
        ArrayList<Integer> authorsList = new ArrayList<Integer>();
        try {
            this.statSelectAuthorIds.clearParameters();
            this.statSelectAuthorIds.setInt(1, authorGroupID);
            ResultSet rs = this.statSelectAuthorIds.executeQuery();
            while (rs.next()) {
                authorsList.add(UtilsDAO.getInstance().getAuthorID(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorsList;
    }

    public boolean checkAuthorGroup(String groupName) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckAuthorGroupByGroupName.clearParameters();
            this.statCheckAuthorGroupByGroupName.setString(1, groupName);
            ResultSet rs = this.statCheckAuthorGroupByGroupName.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public boolean checkAuthorGroup(Integer idAuthorsGroup) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckAuthorGroupById.clearParameters();
            this.statCheckAuthorGroupById.setInt(1, idAuthorsGroup);
            ResultSet rs = this.statCheckAuthorGroupById.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public ArrayList<AuthorGroup> refreshAuthorGroups(ArrayList<AuthorGroup> authorGroupsToRefresh) throws KnowledgeBaseException {
        ArrayList<AuthorGroup> authorGroups = new ArrayList<AuthorGroup>();
        int i = 0;
        if (!authorGroupsToRefresh.isEmpty()) {
            String query = "SELECT * FROM AuthorGroup WHERE idAuthorGroup IN (" + authorGroupsToRefresh.get(i).getAuthorGroupID();
            for (i = 1; i < authorGroupsToRefresh.size(); ++i) {
                query = query + ", " + authorGroupsToRefresh.get(i).getAuthorGroupID();
            }
            query = query + ");";
            try {
                Statement stat = this.kbm.getConnection().createStatement();
                ResultSet rs = stat.executeQuery(query);
                while (rs.next()) {
                    authorGroups.add(UtilsDAO.getInstance().getAuthorGroup(rs));
                }
                rs.close();
                stat.close();
            }
            catch (SQLException e) {
                throw new KnowledgeBaseException(e.getMessage(), e.getCause());
            }
        }
        return authorGroups;
    }

    public AuthorGroup refreshAuthorGroup(AuthorGroup authorGroupToRefresh) throws KnowledgeBaseException {
        return this.getAuthorGroup(authorGroupToRefresh.getAuthorGroupID());
    }
}

