/*
 * Decompiled with CFR 0.152.
 */
package scimat.model.knowledgebase.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.knowledgebaseevents.event.add.AddAuthorEvent;
import scimat.knowledgebaseevents.event.add.AddAuthorWithoutGroupEvent;
import scimat.knowledgebaseevents.event.relation.AuthorGroupRelationAuthorEvent;
import scimat.knowledgebaseevents.event.relation.AuthorRelationAffiliationEvent;
import scimat.knowledgebaseevents.event.relation.DocumentRelationAuthorEvent;
import scimat.knowledgebaseevents.event.remove.RemoveAuthorEvent;
import scimat.knowledgebaseevents.event.remove.RemoveAuthorWithoutGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateAffiliationEvent;
import scimat.knowledgebaseevents.event.update.UpdateAuthorEvent;
import scimat.knowledgebaseevents.event.update.UpdateAuthorGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateAuthorWithoutGroupEvent;
import scimat.knowledgebaseevents.event.update.UpdateDocumentEvent;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.UtilsDAO;
import scimat.model.knowledgebase.entity.Affiliation;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.AuthorGroup;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.DocumentAuthor;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorDAO {
    private KnowledgeBaseManager kbm;
    private static final String __INSERT_AUTHOR = "INSERT INTO Author(authorName,fullAuthorName) VALUES(?,?);";
    private static final String __INSERT_AUTHOR_WITH_ID = "INSERT INTO Author(idAuthor,authorName,fullAuthorName) VALUES(?,?,?);";
    private static final String __REMOVE_AUTHOR = "DELETE FROM Author WHERE idAuthor = ?;";
    private static final String __UPDATE_AUTHORNAME = "UPDATE Author SET authorName = ? WHERE idAuthor = ?;";
    private static final String __UPDATE_FULLAUTHORNAME = "UPDATE Author SET fullAuthorName = ? WHERE idAuthor = ?;";
    private static final String __UPDATE_AUTHOR = "UPDATE Author SET authorName = ?,    fullAuthorName = ? WHERE idAuthor = ?;";
    private static final String __UPDATE_AUTHORGROUP = "UPDATE Author SET AuthorGroup_idAuthorGroup = ? WHERE idAuthor = ?;";
    private static final String __SELECT_AFFILIATION = "SELECT af.* FROM Author_Affiliation aa, Affiliation af WHERE aa.Author_idAuthor = ? AND       aa.Affiliation_idAffiliation = af.idAffiliation;";
    private static final String __SELECT_AFFILIATION_ID = "SELECT af.idAffiliation FROM Author_Affiliation aa, Affiliation af WHERE aa.Author_idAuthor = ? AND       aa.Affiliation_idAffiliation = af.idAffiliation;";
    private static final String __SELECT_AUTHORGROUP = "SELECT ag.* FROM Author a, AuthorGroup ag WHERE a.idAuthor = ? AND      a.AuthorGroup_idAuthorGroup = ag.idAuthorGroup;";
    private static final String __SELECT_AUTHORGROUP_ID = "SELECT ag.idAuthorGroup FROM Author a, AuthorGroup ag WHERE a.idAuthor = ? AND      a.AuthorGroup_idAuthorGroup = ag.idAuthorGroup;";
    private static final String __SELECT_DOCUMENT = "SELECT d.* FROM Document_Author da, Document d, Author a WHERE a.idAuthor = ? AND       a.idAuthor = da.Author_idAuthor AND       da.Document_idDocument = d.idDocument;";
    private static final String __SELECT_DOCUMENT_ID = "SELECT d.idDocument FROM Document_Author da, Document d, Author a WHERE a.idAuthor = ? AND       a.idAuthor = da.Author_idAuthor AND       da.Document_idDocument = d.idDocument;";
    private static final String __SELECT_DOCUMENTAUTHOR = "SELECT d.*, a.*, da.position FROM Document_Author da, Document d, Author a WHERE a.idAuthor = ? AND       a.idAuthor = da.Author_idAuthor AND       da.Document_idDocument = d.idDocument;";
    private static final String __SELECT_AUTHORREFERENCE = "SELECT ar.* FROM Author a, AuthorReference ar WHERE a.idAuthor = ? AND       ar.Author_idAuthor = a.idAuthor;";
    private static final String __SELECT_AUTHORREFERENCE_ID = "SELECT ar.idAuthorReference FROM Author a, AuthorReference ar WHERE a.idAuthor = ? AND       ar.Author_idAuthor = a.idAuthor;";
    private static final String __SELECT_AUTHOR_BY_ID = "SELECT * FROM Author WHERE idAuthor = ?";
    private static final String __SELECT_AUTHOR_BY_NAME = "SELECT * FROM Author WHERE authorName = ? AND fullAuthorName =?;";
    private static final String __SELECT_AUTHORS = "SELECT * FROM Author;";
    private static final String __SELECT_AUTHOR_IDS = "SELECT idAuthor FROM Author;";
    private static final String __SELECT_AUTHORS_WITHOUTGROUP = "SELECT * FROM Author WHERE AuthorGroup_idAuthorGroup IS NULL;";
    private static final String __SELECT_AUTHOR_WITHOUTGROUP_IDS = "SELECT idAuthor FROM Author WHERE AuthorGroup_idAuthorGroup IS NULL;";
    private static final String __CHECK_AUTHOR_BY_ID = "SELECT idAuthor FROM Author WHERE authorName = ? AND fullAuthorName = ?;";
    private static final String __CHECK_AUTHOR_BY_NAME = "SELECT idAuthor FROM Author WHERE idAuthor = ?;";
    private PreparedStatement statAddAuthor;
    private PreparedStatement statAddAuthorWithId;
    private PreparedStatement statRemoveAuthor;
    private PreparedStatement statSelectAffiliation;
    private PreparedStatement statSelectAffiliationId;
    private PreparedStatement statSelectAuthorGroup;
    private PreparedStatement statSelectAuthorGroupId;
    private PreparedStatement statSelectAuthorReference;
    private PreparedStatement statSelectAuthorReferenceId;
    private PreparedStatement statSelectDocument;
    private PreparedStatement statSelectDocumentAuthor;
    private PreparedStatement statSelectDocumentId;
    private PreparedStatement statUpdateAuthor;
    private PreparedStatement statUpdateAuthorGroup;
    private PreparedStatement statUpdateAuthorName;
    private PreparedStatement statUpdateFullAuthorName;
    private PreparedStatement statSelectAuthorById;
    private PreparedStatement statSelectAuthorByName;
    private PreparedStatement statSelectAuthors;
    private PreparedStatement statSelectAuthorIds;
    private PreparedStatement statSelectAuthorsWithoutGroup;
    private PreparedStatement statSelectAuthorWithoutGroupIds;
    private PreparedStatement statCheckAuthorById;
    private PreparedStatement statCheckAuthorByName;

    public AuthorDAO(KnowledgeBaseManager kbm) throws KnowledgeBaseException {
        this.kbm = kbm;
        try {
            this.statAddAuthor = this.kbm.getConnection().prepareStatement(__INSERT_AUTHOR, 1);
            this.statAddAuthorWithId = this.kbm.getConnection().prepareStatement(__INSERT_AUTHOR_WITH_ID);
            this.statRemoveAuthor = this.kbm.getConnection().prepareStatement(__REMOVE_AUTHOR);
            this.statSelectAffiliation = this.kbm.getConnection().prepareStatement(__SELECT_AFFILIATION);
            this.statSelectAffiliationId = this.kbm.getConnection().prepareStatement(__SELECT_AFFILIATION_ID);
            this.statSelectAuthorGroup = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORGROUP);
            this.statSelectAuthorGroupId = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORGROUP_ID);
            this.statSelectAuthorReference = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORREFERENCE);
            this.statSelectAuthorReferenceId = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORREFERENCE_ID);
            this.statSelectDocument = this.kbm.getConnection().prepareStatement(__SELECT_DOCUMENT);
            this.statSelectDocumentAuthor = this.kbm.getConnection().prepareStatement(__SELECT_DOCUMENTAUTHOR);
            this.statSelectDocumentId = this.kbm.getConnection().prepareStatement(__SELECT_DOCUMENT_ID);
            this.statUpdateAuthor = this.kbm.getConnection().prepareStatement(__UPDATE_AUTHOR);
            this.statUpdateAuthorGroup = this.kbm.getConnection().prepareStatement(__UPDATE_AUTHORGROUP);
            this.statUpdateAuthorName = this.kbm.getConnection().prepareStatement(__UPDATE_AUTHORNAME);
            this.statUpdateFullAuthorName = this.kbm.getConnection().prepareStatement(__UPDATE_FULLAUTHORNAME);
            this.statSelectAuthorById = this.kbm.getConnection().prepareStatement(__SELECT_AUTHOR_BY_ID);
            this.statSelectAuthorByName = this.kbm.getConnection().prepareStatement(__SELECT_AUTHOR_BY_NAME);
            this.statSelectAuthors = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORS);
            this.statSelectAuthorIds = this.kbm.getConnection().prepareStatement(__SELECT_AUTHOR_IDS);
            this.statSelectAuthorsWithoutGroup = this.kbm.getConnection().prepareStatement(__SELECT_AUTHORS_WITHOUTGROUP);
            this.statSelectAuthorWithoutGroupIds = this.kbm.getConnection().prepareStatement(__SELECT_AUTHOR_WITHOUTGROUP_IDS);
            this.statCheckAuthorById = this.kbm.getConnection().prepareStatement(__CHECK_AUTHOR_BY_ID);
            this.statCheckAuthorByName = this.kbm.getConnection().prepareStatement(__CHECK_AUTHOR_BY_NAME);
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public Integer addAuthor(String authorName, String fullAuthorName, boolean notifyObservers) throws KnowledgeBaseException {
        Integer id;
        try {
            this.statAddAuthor.clearParameters();
            this.statAddAuthor.setString(1, authorName);
            this.statAddAuthor.setString(2, fullAuthorName);
            if (this.statAddAuthor.executeUpdate() == 1) {
                id = this.statAddAuthor.getGeneratedKeys().getInt(1);
                this.statAddAuthor.getGeneratedKeys().close();
            } else {
                id = null;
            }
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddAuthorEvent(this.getAuthor(id)));
        }
        return id;
    }

    public boolean addAuthor(Integer authorID, String authorName, String fullAuthorName, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statAddAuthorWithId.clearParameters();
            this.statAddAuthorWithId.setInt(1, authorID);
            this.statAddAuthorWithId.setString(2, authorName);
            this.statAddAuthorWithId.setString(3, fullAuthorName);
            result = this.statAddAuthorWithId.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddAuthorEvent(this.getAuthor(authorID)));
        }
        return result;
    }

    public boolean addAuthor(Author author, boolean notifyObservers) throws KnowledgeBaseException {
        return this.addAuthor(author.getAuthorID(), author.getAuthorName(), author.getFullAuthorName(), notifyObservers);
    }

    public boolean removeAuthor(Integer authorID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        Author author = null;
        AuthorGroup authorGroup = null;
        ArrayList<Document> documents = null;
        ArrayList<Affiliation> affiliations = null;
        if (notifyObservers) {
            author = this.getAuthor(authorID);
            authorGroup = this.getAuthorGroup(authorID);
            documents = this.getDocuments(authorID);
            affiliations = this.getAffiliations(authorID);
        }
        try {
            this.statRemoveAuthor.clearParameters();
            this.statRemoveAuthor.setInt(1, authorID);
            result = this.statRemoveAuthor.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new RemoveAuthorEvent(author));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAffiliationEvent(CurrentProject.getInstance().getFactoryDAO().getAffiliationDAO().refreshAffiliations(affiliations)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AuthorRelationAffiliationEvent());
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateDocumentEvent(CurrentProject.getInstance().getFactoryDAO().getDocumentDAO().refreshDocuments(documents)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new DocumentRelationAuthorEvent());
            if (authorGroup != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorGroupEvent(CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO().refreshAuthorGroup(authorGroup)));
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new AuthorGroupRelationAuthorEvent());
            } else {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new RemoveAuthorWithoutGroupEvent(author));
            }
        }
        return result;
    }

    public Author getAuthor(Integer idAuthor) throws KnowledgeBaseException {
        Author author = null;
        try {
            this.statSelectAuthorById.clearParameters();
            this.statSelectAuthorById.setInt(1, idAuthor);
            ResultSet rs = this.statSelectAuthorById.executeQuery();
            if (rs.next()) {
                author = UtilsDAO.getInstance().getAuthor(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return author;
    }

    public Author getAuthor(String authorName, String fullAuthorName) throws KnowledgeBaseException {
        Author author = null;
        try {
            this.statSelectAuthorByName.clearParameters();
            this.statSelectAuthorByName.setString(1, authorName);
            this.statSelectAuthorByName.setString(2, fullAuthorName);
            ResultSet rs = this.statSelectAuthorByName.executeQuery();
            if (rs.next()) {
                author = UtilsDAO.getInstance().getAuthor(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return author;
    }

    public ArrayList<Author> getAuthors() throws KnowledgeBaseException {
        ArrayList<Author> authorList = new ArrayList<Author>();
        try {
            this.statSelectAuthors.clearParameters();
            ResultSet rs = this.statSelectAuthors.executeQuery();
            while (rs.next()) {
                authorList.add(UtilsDAO.getInstance().getAuthor(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorList;
    }

    public ArrayList<Integer> getAuthorIDs() throws KnowledgeBaseException {
        ArrayList<Integer> authorList = new ArrayList<Integer>();
        try {
            this.statSelectAuthorIds.clearParameters();
            ResultSet rs = this.statSelectAuthorIds.executeQuery();
            while (rs.next()) {
                authorList.add(UtilsDAO.getInstance().getAuthorID(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorList;
    }

    public ArrayList<Author> getAuthorsWithoutGroup() throws KnowledgeBaseException {
        ArrayList<Author> authorList = new ArrayList<Author>();
        try {
            this.statSelectAuthorsWithoutGroup.clearParameters();
            ResultSet rs = this.statSelectAuthorsWithoutGroup.executeQuery();
            while (rs.next()) {
                authorList.add(UtilsDAO.getInstance().getAuthor(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorList;
    }

    public ArrayList<Integer> getAuthorIDsWithoutGroup() throws KnowledgeBaseException {
        ArrayList<Integer> authorList = new ArrayList<Integer>();
        try {
            this.statSelectAuthorWithoutGroupIds.clearParameters();
            ResultSet rs = this.statSelectAuthorWithoutGroupIds.executeQuery();
            while (rs.next()) {
                authorList.add(UtilsDAO.getInstance().getAuthorID(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorList;
    }

    public boolean setAuthorName(Integer authorID, String authorName, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateAuthorName.clearParameters();
            this.statUpdateAuthorName.setString(1, authorName);
            this.statUpdateAuthorName.setInt(2, authorID);
            result = this.statUpdateAuthorName.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            Author author = this.getAuthor(authorID);
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorEvent(author));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateDocumentEvent(this.getDocuments(authorID)));
            if (this.getAuthorGroup(authorID) == null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorWithoutGroupEvent(author));
            }
        }
        return result;
    }

    public boolean setFullAuthorName(Integer authorID, String fullAuthorName, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateFullAuthorName.clearParameters();
            this.statUpdateFullAuthorName.setString(1, fullAuthorName);
            this.statUpdateFullAuthorName.setInt(2, authorID);
            result = this.statUpdateFullAuthorName.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            Author author = this.getAuthor(authorID);
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorEvent(author));
            if (this.getAuthorGroup(authorID) == null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorWithoutGroupEvent(author));
            }
        }
        return result;
    }

    public boolean setAuthorGroup(Integer authorID, Integer authorGroupID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        AuthorGroup oldAuthorGroup = null;
        if (notifyObservers) {
            oldAuthorGroup = this.getAuthorGroup(authorID);
        }
        try {
            this.statUpdateAuthorGroup.clearParameters();
            if (authorGroupID != null) {
                this.statUpdateAuthorGroup.setInt(1, authorGroupID);
            } else {
                this.statUpdateAuthorGroup.setNull(1, 0);
            }
            this.statUpdateAuthorGroup.setInt(2, authorID);
            result = this.statUpdateAuthorGroup.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            if (oldAuthorGroup != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorGroupEvent(CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO().refreshAuthorGroup(oldAuthorGroup)));
                if (authorGroupID == null) {
                    KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddAuthorWithoutGroupEvent(this.getAuthor(authorID)));
                }
            } else if (authorGroupID != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new RemoveAuthorWithoutGroupEvent(this.getAuthor(authorID)));
            }
            if (authorGroupID != null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorGroupEvent(this.getAuthorGroup(authorID)));
            }
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AuthorGroupRelationAuthorEvent());
        }
        return result;
    }

    public boolean updateAuthor(Integer authorID, String authorName, String fullAuthorName, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateAuthor.clearParameters();
            this.statUpdateAuthor.setString(1, authorName);
            this.statUpdateAuthor.setString(2, fullAuthorName);
            this.statUpdateAuthor.setInt(3, authorID);
            result = this.statUpdateAuthor.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            Author author = this.getAuthor(authorID);
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorEvent(author));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateDocumentEvent(this.getDocuments(authorID)));
            if (this.getAuthorGroup(authorID) == null) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorWithoutGroupEvent(author));
            }
        }
        return result;
    }

    public AuthorGroup getAuthorGroup(Integer authorID) throws KnowledgeBaseException {
        AuthorGroup authorGroup = null;
        try {
            this.statSelectAuthorGroup.clearParameters();
            this.statSelectAuthorGroup.setInt(1, authorID);
            ResultSet rs = this.statSelectAuthorGroup.executeQuery();
            if (rs.next()) {
                authorGroup = UtilsDAO.getInstance().getAuthorGroup(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorGroup;
    }

    public Integer getAuthorGroupID(Integer authorID) throws KnowledgeBaseException {
        Integer authorGroupID = null;
        try {
            this.statSelectAuthorGroupId.clearParameters();
            this.statSelectAuthorGroupId.setInt(1, authorID);
            ResultSet rs = this.statSelectAuthorGroupId.executeQuery();
            if (rs.next()) {
                authorGroupID = UtilsDAO.getInstance().getAuthorGroupID(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorGroupID;
    }

    public ArrayList<Affiliation> getAffiliations(Integer authorID) throws KnowledgeBaseException {
        ArrayList<Affiliation> affiliationList = new ArrayList<Affiliation>();
        try {
            this.statSelectAffiliation.clearParameters();
            this.statSelectAffiliation.setInt(1, authorID);
            ResultSet rs = this.statSelectAffiliation.executeQuery();
            while (rs.next()) {
                affiliationList.add(UtilsDAO.getInstance().getAffiliation(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return affiliationList;
    }

    public ArrayList<Integer> getAffiliationIDs(Integer authorID) throws KnowledgeBaseException {
        ArrayList<Integer> affiliationList = new ArrayList<Integer>();
        try {
            this.statSelectAffiliationId.clearParameters();
            this.statSelectAffiliationId.setInt(1, authorID);
            ResultSet rs = this.statSelectAffiliationId.executeQuery();
            while (rs.next()) {
                affiliationList.add(UtilsDAO.getInstance().getAffiliationID(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return affiliationList;
    }

    public ArrayList<DocumentAuthor> getDocumentAuthors(Integer authorID) throws KnowledgeBaseException {
        ArrayList<DocumentAuthor> documentsList = new ArrayList<DocumentAuthor>();
        try {
            this.statSelectDocumentAuthor.clearParameters();
            this.statSelectDocumentAuthor.setInt(1, authorID);
            ResultSet rs = this.statSelectDocumentAuthor.executeQuery();
            while (rs.next()) {
                documentsList.add(UtilsDAO.getInstance().getDocumentAuthor(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return documentsList;
    }

    public ArrayList<Document> getDocuments(Integer authorID) throws KnowledgeBaseException {
        ArrayList<Document> documentsList = new ArrayList<Document>();
        try {
            this.statSelectDocument.clearParameters();
            this.statSelectDocument.setInt(1, authorID);
            ResultSet rs = this.statSelectDocument.executeQuery();
            while (rs.next()) {
                documentsList.add(UtilsDAO.getInstance().getDocument(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return documentsList;
    }

    public ArrayList<Integer> getDocumentIDs(Integer authorID) throws KnowledgeBaseException {
        ArrayList<Integer> documentsList = new ArrayList<Integer>();
        try {
            this.statSelectDocumentId.clearParameters();
            this.statSelectDocumentId.setInt(1, authorID);
            ResultSet rs = this.statSelectDocumentId.executeQuery();
            while (rs.next()) {
                documentsList.add(UtilsDAO.getInstance().getDocumentID(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return documentsList;
    }

    public AuthorReference getAuthorReference(Integer authorID) throws KnowledgeBaseException {
        AuthorReference authorReference = null;
        try {
            this.statSelectAuthorReference.clearParameters();
            this.statSelectAuthorReference.setInt(1, authorID);
            ResultSet rs = this.statSelectAuthorReference.executeQuery();
            if (rs.next()) {
                authorReference = UtilsDAO.getInstance().getAuthorReference(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorReference;
    }

    public Integer getAuthorReferenceID(Integer authorID) throws KnowledgeBaseException {
        Integer authorReferenceID = null;
        try {
            this.statSelectAuthorReferenceId.clearParameters();
            this.statSelectAuthorReferenceId.setInt(1, authorID);
            ResultSet rs = this.statSelectAuthorReferenceId.executeQuery();
            if (rs.next()) {
                authorReferenceID = UtilsDAO.getInstance().getAuthorReferenceID(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorReferenceID;
    }

    public boolean checkAuthor(String authorName, String fullAthorName) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckAuthorById.clearParameters();
            this.statCheckAuthorById.setString(1, authorName);
            this.statCheckAuthorById.setString(2, fullAthorName);
            ResultSet rs = this.statCheckAuthorById.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public boolean checkAuthor(Integer idAuthor) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckAuthorByName.clearParameters();
            this.statCheckAuthorByName.setInt(1, idAuthor);
            ResultSet rs = this.statCheckAuthorByName.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public ArrayList<Author> refreshAuthors(ArrayList<Author> authorToRefresh) throws KnowledgeBaseException {
        ArrayList<Author> authors = new ArrayList<Author>();
        int i = 0;
        if (!authorToRefresh.isEmpty()) {
            String query = "SELECT * FROM Author WHERE idAuthor IN (" + authorToRefresh.get(i).getAuthorID();
            for (i = 1; i < authorToRefresh.size(); ++i) {
                query = query + ", " + authorToRefresh.get(i).getAuthorID();
            }
            query = query + ");";
            try {
                Statement stat = this.kbm.getConnection().createStatement();
                ResultSet rs = stat.executeQuery(query);
                while (rs.next()) {
                    authors.add(UtilsDAO.getInstance().getAuthor(rs));
                }
                rs.close();
                stat.close();
            }
            catch (SQLException e) {
                throw new KnowledgeBaseException(e.getMessage(), e.getCause());
            }
        }
        return authors;
    }

    public Author refreshAuthor(Author authorToRefresh) throws KnowledgeBaseException {
        return this.getAuthor(authorToRefresh.getAuthorID());
    }
}

