/*
 * Decompiled with CFR 0.152.
 */
package scimat.model.knowledgebase.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.knowledgebaseevents.event.relation.AuthorRelationAffiliationEvent;
import scimat.knowledgebaseevents.event.update.UpdateAffiliationEvent;
import scimat.knowledgebaseevents.event.update.UpdateAuthorEvent;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class AuthorAffiliationDAO {
    private KnowledgeBaseManager kbm;
    private static final String __ADD_AUTHOR_AFFILIATION = "INSERT INTO Author_Affiliation(Affiliation_idAffiliation,Author_idAuthor) VALUES(?,?);";
    private static final String __REMOVE_AUTHOR_AFFILIATION = "DELETE FROM Author_Affiliation WHERE Affiliation_idAffiliation = ? AND       Author_idAuthor = ?;";
    private static final String __CHECK_AUTHOR_AFFILIATION = "SELECT Author_idAuthor FROM Author_Affiliation WHERE Author_idAuthor = ? AND Affiliation_idAffiliation = ?;";
    private PreparedStatement statAddAuthorAffiliation;
    private PreparedStatement statRemoveAuthorAffiliation;
    private PreparedStatement statCheckAuthorAffiation;

    public AuthorAffiliationDAO(KnowledgeBaseManager kbm) throws KnowledgeBaseException {
        this.kbm = kbm;
        try {
            this.statAddAuthorAffiliation = this.kbm.getConnection().prepareStatement(__ADD_AUTHOR_AFFILIATION);
            this.statRemoveAuthorAffiliation = this.kbm.getConnection().prepareStatement(__REMOVE_AUTHOR_AFFILIATION);
            this.statCheckAuthorAffiation = this.kbm.getConnection().prepareStatement(__CHECK_AUTHOR_AFFILIATION);
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public boolean addAuthorAffiliation(Integer authorID, Integer affiliationID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statAddAuthorAffiliation.clearParameters();
            this.statAddAuthorAffiliation.setInt(1, affiliationID);
            this.statAddAuthorAffiliation.setInt(2, authorID);
            boolean bl = result = this.statAddAuthorAffiliation.executeUpdate() > 0;
            if (notifyObservers) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAffiliationEvent(CurrentProject.getInstance().getFactoryDAO().getAffiliationDAO().getAffiliation(affiliationID)));
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorEvent(CurrentProject.getInstance().getFactoryDAO().getAuthorDAO().getAuthor(authorID)));
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new AuthorRelationAffiliationEvent());
            }
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public boolean removeAuthorAffiliation(Integer authorID, Integer affiliationID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statRemoveAuthorAffiliation.clearParameters();
            this.statRemoveAuthorAffiliation.setInt(1, affiliationID);
            this.statRemoveAuthorAffiliation.setInt(2, authorID);
            boolean bl = result = this.statRemoveAuthorAffiliation.executeUpdate() > 0;
            if (notifyObservers) {
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAffiliationEvent(CurrentProject.getInstance().getFactoryDAO().getAffiliationDAO().getAffiliation(affiliationID)));
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorEvent(CurrentProject.getInstance().getFactoryDAO().getAuthorDAO().getAuthor(authorID)));
                KnowledgeBaseEventsReceiver.getInstance().addEvent(new AuthorRelationAffiliationEvent());
            }
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public boolean checkAuthorAffiliation(Integer idAuhtor, Integer idAffiliation) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckAuthorAffiation.clearParameters();
            this.statCheckAuthorAffiation.setInt(1, idAuhtor);
            this.statCheckAuthorAffiation.setInt(2, idAffiliation);
            ResultSet rs = this.statCheckAuthorAffiation.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }
}

