/*
 * Decompiled with CFR 0.152.
 */
package scimat.model.knowledgebase.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.knowledgebaseevents.event.add.AddAffiliationEvent;
import scimat.knowledgebaseevents.event.relation.AuthorRelationAffiliationEvent;
import scimat.knowledgebaseevents.event.relation.DocumentRelationAffiliationEvent;
import scimat.knowledgebaseevents.event.remove.RemoveAffiliationEvent;
import scimat.knowledgebaseevents.event.update.UpdateAffiliationEvent;
import scimat.knowledgebaseevents.event.update.UpdateAuthorEvent;
import scimat.knowledgebaseevents.event.update.UpdateDocumentEvent;
import scimat.model.knowledgebase.KnowledgeBaseManager;
import scimat.model.knowledgebase.dao.UtilsDAO;
import scimat.model.knowledgebase.entity.Affiliation;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AffiliationDAO {
    private KnowledgeBaseManager kbm;
    private static final String __INSERT_AFFILIATION = "INSERT INTO Affiliation(fullAffiliation) VALUES(?);";
    private static final String __INSERT_AFFILIATION_WITH_ID = "INSERT INTO Affiliation(idAffiliation,fullAffiliation) VALUES(?,?);";
    private static final String __REMOVE_AFFILIATION = "DELETE FROM Affiliation WHERE idAffiliation = ?;";
    private static final String __UPDATE_FULLAFILLILIATION = "UPDATE Affiliation SET fullAffiliation = ? WHERE idAffiliation = ?;";
    private static final String __SELECT_AUTHOR = "SELECT au.* FROM Author_Affiliation aa, Author au WHERE aa.Affiliation_idAffiliation = ? AND au.idAuthor = aa.Author_idAuthor;";
    private static final String __SELECT_AUTHOR_IDs = "SELECT au.idAuthor FROM Author_Affiliation aa, Author au WHERE aa.Affiliation_idAffiliation = ? AND au.idAuthor = aa.Author_idAuthor;";
    private static final String __SELECT_AUTHOR_WITHOUTGROUP = "SELECT au.* FROM Author_Affiliation aa, Author au WHERE aa.Affiliation_idAffiliation = ? AND au.idAuthor = aa.Author_idAuthor AND au.AuthorGroup_idAuthorGroup ISNULL;";
    private static final String __SELECT_AUTHOR_ID_WITHOUTGROUP = "SELECT au.idAuthor FROM Author_Affiliation aa, Author au WHERE aa.Affiliation_idAffiliation = ? AND au.idAuthor = aa.Author_idAuthor AND au.AuthorGroup_idAuthorGroup ISNULL;";
    private static final String __SELECT_DOCUMENTS = "SELECT d.* FROM Document_Affiliation da, Document d WHERE da.Affiliation_idAffiliation = ? AND d.idDocument = da.Document_idDocument;";
    private static final String __SELECT_DOCUMENT_ID = "SELECT d.idDocument FROM Document_Affiliation da, Document d WHERE da.Affiliation_idAffiliation = ? AND d.idDocument = da.Document_idDocument;";
    private static final String __SELECT_AFFILIATION_BY_ID = "SELECT * FROM Affiliation WHERE idAffiliation = ?;";
    private static final String __SELECT_AFFILIATION_BY_FULLAFFILIATION = "SELECT * FROM Affiliation WHERE fullAffiliation = ?;";
    private static final String __SELECT_AFFILIATIONS = "SELECT * FROM Affiliation;";
    private static final String __SELECT_AFFILIATION_IDS = "SELECT idAffiliation FROM Affiliation;";
    private static final String __CHECK_AFFILIATION_BY_FULLAFFILIATION = "SELECT idAffiliation FROM Affiliation WHERE fullAffiliation = ?;";
    private static final String __CHECK_AFFILIATION_BY_ID = "SELECT idAffiliation FROM Affiliation WHERE idAffiliation = ?;";
    private PreparedStatement statAddAffiliation;
    private PreparedStatement statAddAffiliationWithId;
    private PreparedStatement statRemoveAffiliation;
    private PreparedStatement statSelectAffiliationById;
    private PreparedStatement statSelectAffiliationByFullAffiliation;
    private PreparedStatement statSelectAffiliations;
    private PreparedStatement statSelectAffiliationIds;
    private PreparedStatement statCheckAffiliationById;
    private PreparedStatement statCheckAffiliationByFullAffiliation;
    private PreparedStatement statSelectAuthors;
    private PreparedStatement statSelectAuthorIds;
    private PreparedStatement statSelectAuthorWithoutGroup;
    private PreparedStatement statSelectAuthorWithoutGroupID;
    private PreparedStatement statSelectDocuments;
    private PreparedStatement statSelectDocumentId;
    private PreparedStatement statUpdateFullAffiliation;

    public AffiliationDAO(KnowledgeBaseManager kbm) throws KnowledgeBaseException {
        this.kbm = kbm;
        try {
            this.statAddAffiliation = this.kbm.getConnection().prepareStatement(__INSERT_AFFILIATION, 1);
            this.statAddAffiliationWithId = this.kbm.getConnection().prepareStatement(__INSERT_AFFILIATION_WITH_ID);
            this.statRemoveAffiliation = this.kbm.getConnection().prepareStatement(__REMOVE_AFFILIATION);
            this.statSelectAffiliationById = this.kbm.getConnection().prepareStatement(__SELECT_AFFILIATION_BY_ID);
            this.statSelectAffiliationByFullAffiliation = this.kbm.getConnection().prepareStatement(__SELECT_AFFILIATION_BY_FULLAFFILIATION);
            this.statSelectAffiliations = this.kbm.getConnection().prepareStatement(__SELECT_AFFILIATIONS);
            this.statSelectAffiliationIds = this.kbm.getConnection().prepareStatement(__SELECT_AFFILIATION_IDS);
            this.statCheckAffiliationById = this.kbm.getConnection().prepareStatement(__CHECK_AFFILIATION_BY_ID);
            this.statCheckAffiliationByFullAffiliation = this.kbm.getConnection().prepareStatement(__CHECK_AFFILIATION_BY_FULLAFFILIATION);
            this.statSelectAuthors = this.kbm.getConnection().prepareStatement(__SELECT_AUTHOR);
            this.statSelectAuthorIds = this.kbm.getConnection().prepareStatement(__SELECT_AUTHOR_IDs);
            this.statSelectAuthorWithoutGroup = this.kbm.getConnection().prepareStatement(__SELECT_AUTHOR_WITHOUTGROUP);
            this.statSelectAuthorWithoutGroupID = this.kbm.getConnection().prepareStatement(__SELECT_AUTHOR_ID_WITHOUTGROUP);
            this.statSelectDocuments = this.kbm.getConnection().prepareStatement(__SELECT_DOCUMENTS);
            this.statSelectDocumentId = this.kbm.getConnection().prepareStatement(__SELECT_DOCUMENT_ID);
            this.statUpdateFullAffiliation = this.kbm.getConnection().prepareStatement(__UPDATE_FULLAFILLILIATION);
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public Integer addAffiliation(String fullAffiliation, boolean notifyObservers) throws KnowledgeBaseException {
        Integer id;
        try {
            this.statAddAffiliation.clearParameters();
            this.statAddAffiliation.setString(1, fullAffiliation);
            if (this.statAddAffiliation.executeUpdate() == 1) {
                id = this.statAddAffiliation.getGeneratedKeys().getInt(1);
                this.statAddAffiliation.getGeneratedKeys().close();
            } else {
                id = null;
            }
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddAffiliationEvent(this.getAffiliation(id)));
        }
        return id;
    }

    public boolean addAffiliation(Integer affiliationID, String fullAffiliation, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statAddAffiliationWithId.clearParameters();
            this.statAddAffiliationWithId.setInt(1, affiliationID);
            this.statAddAffiliationWithId.setString(2, fullAffiliation);
            result = this.statAddAffiliationWithId.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AddAffiliationEvent(this.getAffiliation(affiliationID)));
        }
        return result;
    }

    public boolean addAffiliation(Affiliation affiliation, boolean notifyObservers) throws KnowledgeBaseException {
        return this.addAffiliation(affiliation.getAffiliationID(), affiliation.getFullAffiliation(), notifyObservers);
    }

    public boolean removeAffiliation(Integer affiliationID, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        Affiliation affiliation = null;
        ArrayList<Document> documents = null;
        ArrayList<Author> authors = null;
        ArrayList<Author> authorsWithoutGroup = null;
        if (notifyObservers) {
            affiliation = this.getAffiliation(affiliationID);
            documents = this.getDocuments(affiliationID);
            authors = this.getAuthors(affiliationID);
            authorsWithoutGroup = this.getAuthorWithoutGroups(affiliationID);
        }
        try {
            this.statRemoveAffiliation.clearParameters();
            this.statRemoveAffiliation.setInt(1, affiliationID);
            result = this.statRemoveAffiliation.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new RemoveAffiliationEvent(affiliation));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateDocumentEvent(CurrentProject.getInstance().getFactoryDAO().getDocumentDAO().refreshDocuments(documents)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new DocumentRelationAffiliationEvent());
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorEvent(CurrentProject.getInstance().getFactoryDAO().getAuthorDAO().refreshAuthors(authors)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAuthorEvent(CurrentProject.getInstance().getFactoryDAO().getAuthorDAO().refreshAuthors(authorsWithoutGroup)));
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new AuthorRelationAffiliationEvent());
        }
        return result;
    }

    public Affiliation getAffiliation(Integer idAffiliation) throws KnowledgeBaseException {
        Affiliation affiliation = null;
        try {
            this.statSelectAffiliationById.clearParameters();
            this.statSelectAffiliationById.setInt(1, idAffiliation);
            ResultSet rs = this.statSelectAffiliationById.executeQuery();
            if (rs.next()) {
                affiliation = UtilsDAO.getInstance().getAffiliation(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return affiliation;
    }

    public Affiliation getAffiliation(String fullAffiliation) throws KnowledgeBaseException {
        Affiliation affiliation = null;
        try {
            this.statSelectAffiliationByFullAffiliation.clearParameters();
            this.statSelectAffiliationByFullAffiliation.setString(1, fullAffiliation);
            ResultSet rs = this.statSelectAffiliationByFullAffiliation.executeQuery();
            if (rs.next()) {
                affiliation = UtilsDAO.getInstance().getAffiliation(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return affiliation;
    }

    public ArrayList<Affiliation> getAffiliations() throws KnowledgeBaseException {
        ArrayList<Affiliation> affiliationsList = new ArrayList<Affiliation>();
        try {
            this.statSelectAffiliations.clearParameters();
            ResultSet rs = this.statSelectAffiliations.executeQuery();
            while (rs.next()) {
                affiliationsList.add(UtilsDAO.getInstance().getAffiliation(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return affiliationsList;
    }

    public ArrayList<Integer> getAffiliationIDs() throws KnowledgeBaseException {
        ArrayList<Integer> affiliationIDs = new ArrayList<Integer>();
        try {
            this.statSelectAffiliationIds.clearParameters();
            ResultSet rs = this.statSelectAffiliationIds.executeQuery();
            while (rs.next()) {
                affiliationIDs.add(UtilsDAO.getInstance().getAffiliationID(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return affiliationIDs;
    }

    public boolean setFullAffiliation(Integer affiliationID, String fullAffilliation, boolean notifyObservers) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statUpdateFullAffiliation.clearParameters();
            this.statUpdateFullAffiliation.setString(1, fullAffilliation);
            this.statUpdateFullAffiliation.setInt(2, affiliationID);
            result = this.statUpdateFullAffiliation.executeUpdate() > 0;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        if (notifyObservers) {
            KnowledgeBaseEventsReceiver.getInstance().addEvent(new UpdateAffiliationEvent(this.getAffiliation(affiliationID)));
        }
        return result;
    }

    public ArrayList<Author> getAuthors(Integer affiliationID) throws KnowledgeBaseException {
        ArrayList<Author> authorsList = new ArrayList<Author>();
        try {
            this.statSelectAuthors.clearParameters();
            this.statSelectAuthors.setInt(1, affiliationID);
            ResultSet rs = this.statSelectAuthors.executeQuery();
            while (rs.next()) {
                authorsList.add(UtilsDAO.getInstance().getAuthor(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorsList;
    }

    public ArrayList<Integer> getAuthorIDs(Integer affiliationID) throws KnowledgeBaseException {
        ArrayList<Integer> authorsList = new ArrayList<Integer>();
        try {
            this.statSelectAuthorIds.clearParameters();
            this.statSelectAuthorIds.setInt(1, affiliationID);
            ResultSet rs = this.statSelectAuthorIds.executeQuery();
            while (rs.next()) {
                authorsList.add(UtilsDAO.getInstance().getAuthorID(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorsList;
    }

    public ArrayList<Author> getAuthorWithoutGroups(Integer affiliationID) throws KnowledgeBaseException {
        ArrayList<Author> authorsList = new ArrayList<Author>();
        try {
            this.statSelectAuthorWithoutGroup.clearParameters();
            this.statSelectAuthorWithoutGroup.setInt(1, affiliationID);
            ResultSet rs = this.statSelectAuthorWithoutGroup.executeQuery();
            while (rs.next()) {
                authorsList.add(UtilsDAO.getInstance().getAuthor(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorsList;
    }

    public ArrayList<Integer> getAuthorIDsWithoutGroup(Integer affiliationID) throws KnowledgeBaseException {
        ArrayList<Integer> authorsList = new ArrayList<Integer>();
        try {
            this.statSelectAuthorWithoutGroupID.clearParameters();
            this.statSelectAuthorWithoutGroupID.setInt(1, affiliationID);
            ResultSet rs = this.statSelectAuthorWithoutGroupID.executeQuery();
            while (rs.next()) {
                authorsList.add(UtilsDAO.getInstance().getAuthorID(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return authorsList;
    }

    public ArrayList<Document> getDocuments(Integer affiliationID) throws KnowledgeBaseException {
        ArrayList<Document> documentsList = new ArrayList<Document>();
        try {
            this.statSelectDocuments.clearParameters();
            this.statSelectDocuments.setInt(1, affiliationID);
            ResultSet rs = this.statSelectDocuments.executeQuery();
            while (rs.next()) {
                documentsList.add(UtilsDAO.getInstance().getDocument(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return documentsList;
    }

    public ArrayList<Integer> getDocumentIDs(Integer affiliationID) throws KnowledgeBaseException {
        ArrayList<Integer> documentsList = new ArrayList<Integer>();
        try {
            this.statSelectDocumentId.clearParameters();
            this.statSelectDocumentId.setInt(1, affiliationID);
            ResultSet rs = this.statSelectDocumentId.executeQuery();
            while (rs.next()) {
                documentsList.add(UtilsDAO.getInstance().getDocumentID(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
        return documentsList;
    }

    public boolean checkAffiliation(String fullAffiliation) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckAffiliationByFullAffiliation.clearParameters();
            this.statCheckAffiliationByFullAffiliation.setString(1, fullAffiliation);
            ResultSet rs = this.statCheckAffiliationByFullAffiliation.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public boolean checkAffiliation(Integer idAffiliation) throws KnowledgeBaseException {
        boolean result = false;
        try {
            this.statCheckAffiliationById.clearParameters();
            this.statCheckAffiliationById.setInt(1, idAffiliation);
            ResultSet rs = this.statCheckAffiliationById.executeQuery();
            result = rs.next();
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new KnowledgeBaseException(e.getMessage(), e.getCause());
        }
    }

    public ArrayList<Affiliation> refreshAffiliations(ArrayList<Affiliation> affiliationsToRefresh) throws KnowledgeBaseException {
        ArrayList<Affiliation> affiliations = new ArrayList<Affiliation>();
        int i = 0;
        if (!affiliationsToRefresh.isEmpty()) {
            String query = "SELECT * FROM Affiliation WHERE idAffiliation IN (" + affiliationsToRefresh.get(i).getAffiliationID();
            for (i = 1; i < affiliationsToRefresh.size(); ++i) {
                query = query + ", " + affiliationsToRefresh.get(i).getAffiliationID();
            }
            query = query + ");";
            try {
                Statement stat = this.kbm.getConnection().createStatement();
                ResultSet rs = stat.executeQuery(query);
                while (rs.next()) {
                    affiliations.add(UtilsDAO.getInstance().getAffiliation(rs));
                }
                rs.close();
                stat.close();
            }
            catch (SQLException e) {
                throw new KnowledgeBaseException(e.getMessage(), e.getCause());
            }
        }
        return affiliations;
    }

    public Affiliation refreshAffiliation(Affiliation affiliationToRefresh) throws KnowledgeBaseException {
        return this.getAffiliation(affiliationToRefresh.getAffiliationID());
    }
}

