/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.undostack;

import java.util.ArrayList;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import scimat.gui.undostack.UndoStackChangeObserver;

public class UndoStack {
    private static UndoStack __singleton = new UndoStack();
    private UndoManager undoManager = new UndoManager();
    private ArrayList<UndoStackChangeObserver> undoStackListeners = new ArrayList();

    private UndoStack() {
    }

    public static void addEdit(UndoableEdit edit) {
        UndoStack.__singleton.undoManager.addEdit(edit);
        __singleton.notifyUndoStackChanged();
    }

    public static void undo() {
        UndoStack.__singleton.undoManager.undo();
        __singleton.notifyUndoStackChanged();
    }

    public static void redo() {
        UndoStack.__singleton.undoManager.redo();
        __singleton.notifyUndoStackChanged();
    }

    private void notifyUndoStackChanged() {
        for (int i = 0; i < this.undoStackListeners.size(); ++i) {
            this.undoStackListeners.get(i).undoStackChanged(UndoStack.__singleton.undoManager.canUndo(), UndoStack.__singleton.undoManager.canRedo());
        }
    }

    public static void addUndoStackChangeObserver(UndoStackChangeObserver observer) {
        UndoStack.__singleton.undoStackListeners.add(observer);
        observer.undoStackChanged(UndoStack.__singleton.undoManager.canUndo(), UndoStack.__singleton.undoManager.canRedo());
    }
}

