/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.wizard;

import java.awt.Frame;
import javax.swing.JFrame;
import scimat.gui.components.wizard.Analysis.MakeAnalysisDialog;
import scimat.gui.components.wizard.NewProjectDialog;
import scimat.gui.components.wizard.UpgradeKnowledgeBaseDialog;

public class WizardManager {
    private NewProjectDialog newProjectDialog;
    private MakeAnalysisDialog makeAnalysisDialog;
    private UpgradeKnowledgeBaseDialog upgradeKnowledgeBaseDialog;

    private WizardManager() {
    }

    public static WizardManager getInstance() {
        return WizardManagerHolder.INSTANCE;
    }

    public void init(JFrame frame) {
        this.newProjectDialog = new NewProjectDialog((Frame)frame, true);
        this.makeAnalysisDialog = new MakeAnalysisDialog((Frame)frame, true);
        this.upgradeKnowledgeBaseDialog = new UpgradeKnowledgeBaseDialog((Frame)frame, true);
    }

    public void showNewProject() {
        this.newProjectDialog.refresh();
        this.newProjectDialog.setVisible(true);
    }

    public void showMakeAnalysis() {
        this.makeAnalysisDialog.refresh();
        this.makeAnalysisDialog.setVisible(true);
    }

    public void showUpdgradeKnowledgeBaseDialog(String oldKnowledgeBasePath) {
        this.upgradeKnowledgeBaseDialog.refresh(oldKnowledgeBasePath);
        this.upgradeKnowledgeBaseDialog.setVisible(true);
    }

    private static class WizardManagerHolder {
        private static final WizardManager INSTANCE = new WizardManager();

        private WizardManagerHolder() {
        }
    }
}

