/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.wizard;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import scimat.gui.commands.task.NewProjectTask;

public class NewProjectDialog
extends JDialog {
    private JButton acceptButton;
    private JButton browseButton;
    private JButton cancelButton;
    private JLabel fileNameLabel;
    private JTextField fileNameTextField;
    private JLabel pathLabel;
    private JTextField pathTextField;
    private JSeparator separator;

    public NewProjectDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.pathTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                NewProjectDialog.this.enableAcceptButton();
            }

            public void removeUpdate(DocumentEvent e) {
                NewProjectDialog.this.enableAcceptButton();
            }

            public void changedUpdate(DocumentEvent e) {
                NewProjectDialog.this.enableAcceptButton();
            }
        });
        this.fileNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                NewProjectDialog.this.enableAcceptButton();
            }

            public void removeUpdate(DocumentEvent e) {
                NewProjectDialog.this.enableAcceptButton();
            }

            public void changedUpdate(DocumentEvent e) {
                NewProjectDialog.this.enableAcceptButton();
            }
        });
    }

    public void refresh() {
        this.pathTextField.setText("");
        this.fileNameTextField.setText("");
        this.enableAcceptButton();
    }

    private void enableAcceptButton() {
        this.acceptButton.setEnabled(!this.pathTextField.getText().isEmpty() && !this.fileNameTextField.getText().isEmpty());
    }

    private void initComponents() {
        this.pathLabel = new JLabel();
        this.pathTextField = new JTextField();
        this.browseButton = new JButton();
        this.fileNameLabel = new JLabel();
        this.fileNameTextField = new JTextField();
        this.separator = new JSeparator();
        this.acceptButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("New project");
        this.pathLabel.setLabelFor(this.pathTextField);
        this.pathLabel.setText("Path:");
        this.pathTextField.setEditable(false);
        this.browseButton.setText("Browse");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewProjectDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.fileNameLabel.setLabelFor(this.fileNameTextField);
        this.fileNameLabel.setText("File name:");
        this.acceptButton.setText("Accept");
        this.acceptButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewProjectDialog.this.acceptButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewProjectDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.separator, -1, 383, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileNameLabel).addComponent(this.pathLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.pathTextField, -2, 251, -2).addComponent(this.fileNameTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.acceptButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pathLabel).addComponent(this.pathTextField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileNameLabel).addComponent(this.fileNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.acceptButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Select a directory");
        fileChooser.setFileSelectionMode(1);
        fileChooser.setMultiSelectionEnabled(false);
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.pathTextField.setText(fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void acceptButtonActionPerformed(ActionEvent evt) {
        NewProjectTask task = new NewProjectTask(this.pathTextField.getText(), this.fileNameTextField.getText(), this.rootPane);
        task.execute();
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

