/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.wizard.Analysis;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import scimat.analysis.UnitOfAnalysisEnum;
import scimat.gui.components.wizard.GenericWizardStepPanel;

public class SelectUnitOfAnalysisPanel
extends GenericWizardStepPanel {
    private JCheckBox addedWordsCheckBox;
    private JRadioButton authorReferencesRadioButton;
    private JCheckBox authorWordsCheckBox;
    private JRadioButton authorsRadioButton;
    private JRadioButton referencesRadioButton;
    private JRadioButton sourceReferencesRadioButton;
    private JCheckBox sourceWordsCheckBox;
    private ButtonGroup unitOfAnalysisButtonGroup;
    private JRadioButton wordsRadioButton;

    public SelectUnitOfAnalysisPanel() {
        this.initComponents();
    }

    public void refresh() {
        this.authorWordsCheckBox.setEnabled(false);
        this.sourceWordsCheckBox.setEnabled(false);
        this.addedWordsCheckBox.setEnabled(false);
        this.authorWordsCheckBox.setSelected(false);
        this.sourceWordsCheckBox.setSelected(false);
        this.addedWordsCheckBox.setSelected(false);
        this.unitOfAnalysisButtonGroup.clearSelection();
        this.fireIncorrectDataObservers();
    }

    public void fireIncorrectDataObservers() {
        if (this.unitOfAnalysisButtonGroup.getSelection() != null) {
            if (this.wordsRadioButton.isSelected()) {
                if (this.authorWordsCheckBox.isSelected() || this.sourceWordsCheckBox.isSelected() || this.addedWordsCheckBox.isSelected()) {
                    this.notifyIncorrectDataObservers(true, "");
                } else {
                    this.notifyIncorrectDataObservers(false, "A kinds of word must be selected");
                }
            } else {
                this.notifyIncorrectDataObservers(true, "");
            }
        } else {
            this.notifyIncorrectDataObservers(false, "A unit of analysis must be selected.");
        }
    }

    public UnitOfAnalysisEnum getSelectedUnitOfAnalysis() {
        UnitOfAnalysisEnum unitOfAnalyss = null;
        if (this.authorsRadioButton.isSelected()) {
            unitOfAnalyss = UnitOfAnalysisEnum.Authors;
        } else if (this.wordsRadioButton.isSelected()) {
            unitOfAnalyss = UnitOfAnalysisEnum.Words;
        } else if (this.referencesRadioButton.isSelected()) {
            unitOfAnalyss = UnitOfAnalysisEnum.References;
        } else if (this.authorReferencesRadioButton.isSelected()) {
            unitOfAnalyss = UnitOfAnalysisEnum.AuthorsReference;
        } else if (this.sourceReferencesRadioButton.isSelected()) {
            unitOfAnalyss = UnitOfAnalysisEnum.ReferenceSources;
        }
        return unitOfAnalyss;
    }

    public boolean isAuthorWordsSelected() {
        return this.authorWordsCheckBox.isSelected();
    }

    public boolean isSourceWordsSelected() {
        return this.sourceWordsCheckBox.isSelected();
    }

    public boolean isAddedWordsSelected() {
        return this.addedWordsCheckBox.isSelected();
    }

    private void initComponents() {
        this.unitOfAnalysisButtonGroup = new ButtonGroup();
        this.authorsRadioButton = new JRadioButton();
        this.wordsRadioButton = new JRadioButton();
        this.authorWordsCheckBox = new JCheckBox();
        this.sourceWordsCheckBox = new JCheckBox();
        this.addedWordsCheckBox = new JCheckBox();
        this.referencesRadioButton = new JRadioButton();
        this.authorReferencesRadioButton = new JRadioButton();
        this.sourceReferencesRadioButton = new JRadioButton();
        this.unitOfAnalysisButtonGroup.add(this.authorsRadioButton);
        this.authorsRadioButton.setText("Authors");
        this.authorsRadioButton.setDoubleBuffered(true);
        this.authorsRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectUnitOfAnalysisPanel.this.authorsRadioButtonActionPerformed(evt);
            }
        });
        this.unitOfAnalysisButtonGroup.add(this.wordsRadioButton);
        this.wordsRadioButton.setText("Words");
        this.wordsRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectUnitOfAnalysisPanel.this.wordsRadioButtonActionPerformed(evt);
            }
        });
        this.authorWordsCheckBox.setText("Author's words");
        this.authorWordsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectUnitOfAnalysisPanel.this.authorWordsCheckBoxActionPerformed(evt);
            }
        });
        this.sourceWordsCheckBox.setText("Source's words");
        this.sourceWordsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectUnitOfAnalysisPanel.this.sourceWordsCheckBoxActionPerformed(evt);
            }
        });
        this.addedWordsCheckBox.setText("Added words");
        this.addedWordsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectUnitOfAnalysisPanel.this.addedWordsCheckBoxActionPerformed(evt);
            }
        });
        this.unitOfAnalysisButtonGroup.add(this.referencesRadioButton);
        this.referencesRadioButton.setText("References");
        this.referencesRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectUnitOfAnalysisPanel.this.referencesRadioButtonActionPerformed(evt);
            }
        });
        this.unitOfAnalysisButtonGroup.add(this.authorReferencesRadioButton);
        this.authorReferencesRadioButton.setText("Authors-reference");
        this.authorReferencesRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectUnitOfAnalysisPanel.this.authorReferencesRadioButtonActionPerformed(evt);
            }
        });
        this.unitOfAnalysisButtonGroup.add(this.sourceReferencesRadioButton);
        this.sourceReferencesRadioButton.setText("Sources-reference");
        this.sourceReferencesRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectUnitOfAnalysisPanel.this.sourceReferencesRadioButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.authorsRadioButton).addComponent(this.wordsRadioButton).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.authorWordsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceWordsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addedWordsCheckBox)).addComponent(this.referencesRadioButton).addComponent(this.authorReferencesRadioButton).addComponent(this.sourceReferencesRadioButton)).addContainerGap(22, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.authorsRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wordsRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.authorWordsCheckBox).addComponent(this.sourceWordsCheckBox).addComponent(this.addedWordsCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.referencesRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.authorReferencesRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceReferencesRadioButton)));
    }

    private void authorsRadioButtonActionPerformed(ActionEvent evt) {
        this.fireIncorrectDataObservers();
    }

    private void wordsRadioButtonActionPerformed(ActionEvent evt) {
        this.fireIncorrectDataObservers();
        if (this.wordsRadioButton.isSelected()) {
            this.authorWordsCheckBox.setEnabled(true);
            this.sourceWordsCheckBox.setEnabled(true);
            this.addedWordsCheckBox.setEnabled(true);
        } else {
            this.authorWordsCheckBox.setEnabled(false);
            this.sourceWordsCheckBox.setEnabled(false);
            this.addedWordsCheckBox.setEnabled(false);
        }
    }

    private void referencesRadioButtonActionPerformed(ActionEvent evt) {
        this.fireIncorrectDataObservers();
    }

    private void authorReferencesRadioButtonActionPerformed(ActionEvent evt) {
        this.fireIncorrectDataObservers();
    }

    private void sourceReferencesRadioButtonActionPerformed(ActionEvent evt) {
        this.fireIncorrectDataObservers();
    }

    private void authorWordsCheckBoxActionPerformed(ActionEvent evt) {
        this.fireIncorrectDataObservers();
    }

    private void sourceWordsCheckBoxActionPerformed(ActionEvent evt) {
        this.fireIncorrectDataObservers();
    }

    private void addedWordsCheckBoxActionPerformed(ActionEvent evt) {
        this.fireIncorrectDataObservers();
    }
}

