/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.wizard.Analysis;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import scimat.analysis.SimilarityMeasuresEnum;
import scimat.gui.components.wizard.GenericWizardStepPanel;

public class SelectSimilarityMeasurePanel
extends GenericWizardStepPanel {
    private JRadioButton associationStrengthRadioButton;
    private JRadioButton equivalenceIndexRadioButton;
    private JRadioButton inclusionIndexRadioButton;
    private JRadioButton jaccardIndexRadioButton;
    private ButtonGroup normalizationMeasuresButtonGroup;
    private JRadioButton saltonCosineRadioButton;

    public SelectSimilarityMeasurePanel() {
        this.initComponents();
    }

    public void refresh() {
        this.normalizationMeasuresButtonGroup.clearSelection();
        this.fireIncorrectDataObservers();
    }

    public void fireIncorrectDataObservers() {
        if (this.normalizationMeasuresButtonGroup.getSelection() != null) {
            this.notifyIncorrectDataObservers(true, "");
        } else {
            this.notifyIncorrectDataObservers(false, "A similarity measure must be selected.");
        }
    }

    public SimilarityMeasuresEnum getSelectedNormalizationMeasures() {
        SimilarityMeasuresEnum normalizationMeasures = null;
        if (this.associationStrengthRadioButton.isSelected()) {
            normalizationMeasures = SimilarityMeasuresEnum.AssociationStrength;
        } else if (this.equivalenceIndexRadioButton.isSelected()) {
            normalizationMeasures = SimilarityMeasuresEnum.EquivalenceIndex;
        } else if (this.inclusionIndexRadioButton.isSelected()) {
            normalizationMeasures = SimilarityMeasuresEnum.InclusionIndex;
        } else if (this.jaccardIndexRadioButton.isSelected()) {
            normalizationMeasures = SimilarityMeasuresEnum.JaccardIndex;
        } else if (this.saltonCosineRadioButton.isSelected()) {
            normalizationMeasures = SimilarityMeasuresEnum.SaltonCosine;
        }
        return normalizationMeasures;
    }

    private void initComponents() {
        this.normalizationMeasuresButtonGroup = new ButtonGroup();
        this.associationStrengthRadioButton = new JRadioButton();
        this.equivalenceIndexRadioButton = new JRadioButton();
        this.inclusionIndexRadioButton = new JRadioButton();
        this.jaccardIndexRadioButton = new JRadioButton();
        this.saltonCosineRadioButton = new JRadioButton();
        this.normalizationMeasuresButtonGroup.add(this.associationStrengthRadioButton);
        this.associationStrengthRadioButton.setText("Association strength");
        this.associationStrengthRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectSimilarityMeasurePanel.this.associationStrengthRadioButtonActionPerformed(evt);
            }
        });
        this.normalizationMeasuresButtonGroup.add(this.equivalenceIndexRadioButton);
        this.equivalenceIndexRadioButton.setText("Equivalence index");
        this.equivalenceIndexRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectSimilarityMeasurePanel.this.equivalenceIndexRadioButtonActionPerformed(evt);
            }
        });
        this.normalizationMeasuresButtonGroup.add(this.inclusionIndexRadioButton);
        this.inclusionIndexRadioButton.setText("Inclussion index");
        this.inclusionIndexRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectSimilarityMeasurePanel.this.inclusionIndexRadioButtonActionPerformed(evt);
            }
        });
        this.normalizationMeasuresButtonGroup.add(this.jaccardIndexRadioButton);
        this.jaccardIndexRadioButton.setText("Jaccard's index");
        this.jaccardIndexRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectSimilarityMeasurePanel.this.jaccardIndexRadioButtonActionPerformed(evt);
            }
        });
        this.normalizationMeasuresButtonGroup.add(this.saltonCosineRadioButton);
        this.saltonCosineRadioButton.setText("Salton's cosine");
        this.saltonCosineRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectSimilarityMeasurePanel.this.saltonCosineRadioButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.associationStrengthRadioButton).addComponent(this.equivalenceIndexRadioButton).addComponent(this.inclusionIndexRadioButton).addComponent(this.jaccardIndexRadioButton).addComponent(this.saltonCosineRadioButton));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.associationStrengthRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.equivalenceIndexRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inclusionIndexRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jaccardIndexRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saltonCosineRadioButton)));
    }

    private void associationStrengthRadioButtonActionPerformed(ActionEvent evt) {
        this.fireIncorrectDataObservers();
    }

    private void equivalenceIndexRadioButtonActionPerformed(ActionEvent evt) {
        this.fireIncorrectDataObservers();
    }

    private void inclusionIndexRadioButtonActionPerformed(ActionEvent evt) {
        this.fireIncorrectDataObservers();
    }

    private void jaccardIndexRadioButtonActionPerformed(ActionEvent evt) {
        this.fireIncorrectDataObservers();
    }

    private void saltonCosineRadioButtonActionPerformed(ActionEvent evt) {
        this.fireIncorrectDataObservers();
    }
}

