/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.wizard.Analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.BoxLayout;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.itemslist.GenericDynamicItemsListPanel;
import scimat.gui.components.itemslist.GenericSelectManyItemsPanel;
import scimat.gui.components.observer.ElementsCountObserver;
import scimat.gui.components.tablemodel.PeriodsTableModel;
import scimat.gui.components.wizard.GenericWizardStepPanel;
import scimat.model.knowledgebase.entity.Period;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectPeriodsPanel
extends GenericWizardStepPanel
implements ElementsCountObserver {
    private GenericSelectManyItemsPanel<Period> genericSelectManyItemsPanel = new GenericSelectManyItemsPanel<Period>(new GenericDynamicItemsListPanel<Period>(new PeriodsTableModel()), new GenericDynamicItemsListPanel<Period>(new PeriodsTableModel()));
    private int targetElementCount;

    public SelectPeriodsPanel() {
        this.initComponents();
        this.genericSelectManyItemsPanel.addTargetElementsCountObserver(this);
        this.add(this.genericSelectManyItemsPanel);
    }

    @Override
    public void refresh() {
        try {
            this.genericSelectManyItemsPanel.refreshData(CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().getPeriods());
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
    }

    @Override
    public void fireIncorrectDataObservers() {
        boolean correct = true;
        String message = "";
        if (this.targetElementCount == 0) {
            correct = false;
            message = "You need to select a set of periods.";
        }
        this.notifyIncorrectDataObservers(correct, message);
    }

    @Override
    public void elementsCountChanged(int newElementsCount) {
        this.targetElementCount = newElementsCount;
        this.fireIncorrectDataObservers();
    }

    public ArrayList<Period> getSelectedPeriods() {
        ArrayList<Period> periods = new ArrayList();
        periods = this.genericSelectManyItemsPanel.getTargetItems();
        Collections.sort(periods, new Comparator<Period>(){

            @Override
            public int compare(Period o1, Period o2) {
                return Integer.valueOf(o1.getPosition()).compareTo(o2.getPosition());
            }
        });
        return periods;
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 2));
    }
}

