/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.wizard.Analysis;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import scimat.analysis.KindOfMatrixEnum;
import scimat.gui.components.wizard.GenericWizardStepPanel;

public class SelectMatrixBuilderPanel
extends GenericWizardStepPanel {
    private JRadioButton aggregatedCouplingBasedOnAuthorsRadioButton;
    private JRadioButton aggregatedCouplingBasedOnJournalsReferencesRadioButton;
    private JRadioButton basicCouplingRadioButton;
    private JRadioButton coOccurrenceRadioButton;
    private ButtonGroup kindOfMatrixButtonGroup;

    public SelectMatrixBuilderPanel() {
        this.initComponents();
    }

    public void refresh() {
        this.kindOfMatrixButtonGroup.clearSelection();
        this.fireIncorrectDataObservers();
    }

    public void fireIncorrectDataObservers() {
        if (this.kindOfMatrixButtonGroup.getSelection() != null) {
            this.notifyIncorrectDataObservers(true, "");
        } else {
            this.notifyIncorrectDataObservers(false, "A kind of matrix must be selected.");
        }
    }

    public KindOfMatrixEnum getSelectedKindOfMatrix() {
        KindOfMatrixEnum kindOfMatrix = null;
        if (this.coOccurrenceRadioButton.isSelected()) {
            kindOfMatrix = KindOfMatrixEnum.CoOccurrence;
        } else if (this.basicCouplingRadioButton.isSelected()) {
            kindOfMatrix = KindOfMatrixEnum.BasicCoupling;
        } else if (this.aggregatedCouplingBasedOnAuthorsRadioButton.isSelected()) {
            kindOfMatrix = KindOfMatrixEnum.AggregatedCouplingBasedOnAuthor;
        } else if (this.aggregatedCouplingBasedOnJournalsReferencesRadioButton.isSelected()) {
            kindOfMatrix = KindOfMatrixEnum.AggregatedCouplingBasedOnJournal;
        }
        return kindOfMatrix;
    }

    private void initComponents() {
        this.kindOfMatrixButtonGroup = new ButtonGroup();
        this.coOccurrenceRadioButton = new JRadioButton();
        this.basicCouplingRadioButton = new JRadioButton();
        this.aggregatedCouplingBasedOnAuthorsRadioButton = new JRadioButton();
        this.aggregatedCouplingBasedOnJournalsReferencesRadioButton = new JRadioButton();
        this.kindOfMatrixButtonGroup.add(this.coOccurrenceRadioButton);
        this.coOccurrenceRadioButton.setText("Co-occurrence");
        this.coOccurrenceRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectMatrixBuilderPanel.this.coOccurrenceRadioButtonActionPerformed(evt);
            }
        });
        this.kindOfMatrixButtonGroup.add(this.basicCouplingRadioButton);
        this.basicCouplingRadioButton.setText("Basic coupling");
        this.basicCouplingRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectMatrixBuilderPanel.this.basicCouplingRadioButtonActionPerformed(evt);
            }
        });
        this.kindOfMatrixButtonGroup.add(this.aggregatedCouplingBasedOnAuthorsRadioButton);
        this.aggregatedCouplingBasedOnAuthorsRadioButton.setText("Aggregated coupling based on authors");
        this.aggregatedCouplingBasedOnAuthorsRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectMatrixBuilderPanel.this.aggregatedCouplingBasedOnAuthorsRadioButtonActionPerformed(evt);
            }
        });
        this.kindOfMatrixButtonGroup.add(this.aggregatedCouplingBasedOnJournalsReferencesRadioButton);
        this.aggregatedCouplingBasedOnJournalsReferencesRadioButton.setText("Aggregated coupling based on journals");
        this.aggregatedCouplingBasedOnJournalsReferencesRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectMatrixBuilderPanel.this.aggregatedCouplingBasedOnJournalsReferencesRadioButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.coOccurrenceRadioButton).addComponent(this.basicCouplingRadioButton).addComponent(this.aggregatedCouplingBasedOnAuthorsRadioButton).addComponent(this.aggregatedCouplingBasedOnJournalsReferencesRadioButton)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.coOccurrenceRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.basicCouplingRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.aggregatedCouplingBasedOnAuthorsRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.aggregatedCouplingBasedOnJournalsReferencesRadioButton)));
    }

    private void coOccurrenceRadioButtonActionPerformed(ActionEvent evt) {
        this.fireIncorrectDataObservers();
    }

    private void basicCouplingRadioButtonActionPerformed(ActionEvent evt) {
        this.fireIncorrectDataObservers();
    }

    private void aggregatedCouplingBasedOnAuthorsRadioButtonActionPerformed(ActionEvent evt) {
        this.fireIncorrectDataObservers();
    }

    private void aggregatedCouplingBasedOnJournalsReferencesRadioButtonActionPerformed(ActionEvent evt) {
        this.fireIncorrectDataObservers();
    }
}

