/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.wizard.Analysis;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import scimat.gui.components.wizard.GenericWizardStepPanel;

public class SelectDocumentMappersPanel
extends GenericWizardStepPanel {
    private JCheckBox coreMapperCheckBox;
    private JCheckBox intersectionMapperCheckBox;
    private JCheckBox kCoreMapperCheckBox;
    private JLabel kDescriptionLabel;
    private JSpinner kSpinner;
    private JCheckBox secondaryMapperCheckBox;
    private JCheckBox unionMapperCheckBox;
    private int documentMappersSelected = 0;

    public SelectDocumentMappersPanel() {
        this.initComponents();
    }

    public void refresh() {
        this.documentMappersSelected = 0;
        this.coreMapperCheckBox.setSelected(false);
        this.intersectionMapperCheckBox.setSelected(false);
        this.kCoreMapperCheckBox.setSelected(false);
        this.kSpinner.setEnabled(false);
        this.secondaryMapperCheckBox.setSelected(false);
        this.unionMapperCheckBox.setSelected(false);
    }

    public void fireIncorrectDataObservers() {
        if (this.documentMappersSelected > 0) {
            this.notifyIncorrectDataObservers(true, "");
        } else {
            this.notifyIncorrectDataObservers(false, "A set of document mappers must be selected");
        }
    }

    public boolean isCoreMapperSelected() {
        return this.coreMapperCheckBox.isSelected();
    }

    public boolean isIntersectionMapperSelected() {
        return this.intersectionMapperCheckBox.isSelected();
    }

    public boolean isKCoreMapperSelected() {
        return this.kCoreMapperCheckBox.isSelected();
    }

    public int getKCore() {
        return (Integer)this.kSpinner.getModel().getValue();
    }

    public boolean isSecondaryMapperSelected() {
        return this.secondaryMapperCheckBox.isSelected();
    }

    public boolean isUnionMapperSelected() {
        return this.unionMapperCheckBox.isSelected();
    }

    private void initComponents() {
        this.coreMapperCheckBox = new JCheckBox();
        this.intersectionMapperCheckBox = new JCheckBox();
        this.kCoreMapperCheckBox = new JCheckBox();
        this.kDescriptionLabel = new JLabel();
        this.kSpinner = new JSpinner();
        this.secondaryMapperCheckBox = new JCheckBox();
        this.unionMapperCheckBox = new JCheckBox();
        this.coreMapperCheckBox.setText("Core mapper");
        this.coreMapperCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectDocumentMappersPanel.this.coreMapperCheckBoxActionPerformed(evt);
            }
        });
        this.intersectionMapperCheckBox.setText("Intersection mapper");
        this.intersectionMapperCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectDocumentMappersPanel.this.intersectionMapperCheckBoxActionPerformed(evt);
            }
        });
        this.kCoreMapperCheckBox.setText("K-core mapper");
        this.kCoreMapperCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectDocumentMappersPanel.this.kCoreMapperCheckBoxActionPerformed(evt);
            }
        });
        this.kDescriptionLabel.setText("K:");
        this.kSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.kSpinner.setEnabled(false);
        this.secondaryMapperCheckBox.setText("Secondary mapper");
        this.secondaryMapperCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectDocumentMappersPanel.this.secondaryMapperCheckBoxActionPerformed(evt);
            }
        });
        this.unionMapperCheckBox.setText("Union mapper");
        this.unionMapperCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectDocumentMappersPanel.this.unionMapperCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.coreMapperCheckBox).addComponent(this.intersectionMapperCheckBox).addComponent(this.kCoreMapperCheckBox).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.kDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.kSpinner, -2, 50, -2)).addComponent(this.secondaryMapperCheckBox).addComponent(this.unionMapperCheckBox));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.coreMapperCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.intersectionMapperCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.kCoreMapperCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.kDescriptionLabel).addComponent(this.kSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.secondaryMapperCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unionMapperCheckBox)));
    }

    private void kCoreMapperCheckBoxActionPerformed(ActionEvent evt) {
        if (this.kCoreMapperCheckBox.isSelected()) {
            ++this.documentMappersSelected;
            this.kSpinner.setEnabled(true);
        } else {
            --this.documentMappersSelected;
            this.kSpinner.setEnabled(false);
        }
        this.fireIncorrectDataObservers();
    }

    private void coreMapperCheckBoxActionPerformed(ActionEvent evt) {
        this.documentMappersSelected = this.coreMapperCheckBox.isSelected() ? ++this.documentMappersSelected : --this.documentMappersSelected;
        this.fireIncorrectDataObservers();
    }

    private void intersectionMapperCheckBoxActionPerformed(ActionEvent evt) {
        this.documentMappersSelected = this.intersectionMapperCheckBox.isSelected() ? ++this.documentMappersSelected : --this.documentMappersSelected;
        this.fireIncorrectDataObservers();
    }

    private void secondaryMapperCheckBoxActionPerformed(ActionEvent evt) {
        this.documentMappersSelected = this.secondaryMapperCheckBox.isSelected() ? ++this.documentMappersSelected : --this.documentMappersSelected;
        this.fireIncorrectDataObservers();
    }

    private void unionMapperCheckBoxActionPerformed(ActionEvent evt) {
        this.documentMappersSelected = this.unionMapperCheckBox.isSelected() ? ++this.documentMappersSelected : --this.documentMappersSelected;
        this.fireIncorrectDataObservers();
    }
}

