/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.wizard.Analysis;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import scimat.analysis.ClusteringAlgorithmEnum;
import scimat.gui.components.wizard.GenericWizardStepPanel;

public class SelectClusteringAlgorithmPanel
extends GenericWizardStepPanel {
    private JRadioButton averageLinkRadioButton;
    private ButtonGroup clusteringAlgorithmbuttonGroup;
    private JRadioButton completeLinkRadioButton;
    private JLabel cutOffDescriptionLabel;
    private JSpinner cutOffSpinner;
    private JLabel maxNetworkSizeDescriptionLabel;
    private JSpinner maxNetworkSizeSpinner;
    private JLabel minNetworkSizeDescriptionLabel;
    private JSpinner minNetworkSizeSpinner;
    private JSeparator separator1;
    private JRadioButton simpleCentersAlgorithmRadioButton;
    private JRadioButton singleLinkRadioButton;
    private JRadioButton sumLinkRadioButton;

    public SelectClusteringAlgorithmPanel() {
        this.initComponents();
        this.maxNetworkSizeSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int max = (Integer)SelectClusteringAlgorithmPanel.this.maxNetworkSizeSpinner.getModel().getValue();
                int currentValue = (Integer)SelectClusteringAlgorithmPanel.this.minNetworkSizeSpinner.getModel().getValue();
                SelectClusteringAlgorithmPanel.this.minNetworkSizeSpinner.setModel(new SpinnerNumberModel(currentValue, 1, max, 1));
            }
        });
        this.minNetworkSizeSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int min = (Integer)SelectClusteringAlgorithmPanel.this.minNetworkSizeSpinner.getModel().getValue();
                int currentValue = (Integer)SelectClusteringAlgorithmPanel.this.maxNetworkSizeSpinner.getModel().getValue();
                SelectClusteringAlgorithmPanel.this.maxNetworkSizeSpinner.setModel(new SpinnerNumberModel((Number)currentValue, Integer.valueOf(min), null, (Number)1));
            }
        });
    }

    public void refresh() {
        this.clusteringAlgorithmbuttonGroup.clearSelection();
        this.minNetworkSizeSpinner.setEnabled(false);
        this.maxNetworkSizeSpinner.setEnabled(false);
        this.cutOffSpinner.setEnabled(false);
        this.fireIncorrectDataObservers();
    }

    public void fireIncorrectDataObservers() {
        if (this.clusteringAlgorithmbuttonGroup.getSelection() != null) {
            this.notifyIncorrectDataObservers(true, "");
        } else {
            this.notifyIncorrectDataObservers(false, "A clustering algorithm must be selected");
        }
    }

    public ClusteringAlgorithmEnum getSelectedClusteringAlgorithm() {
        ClusteringAlgorithmEnum clusteringAlgorithm = null;
        if (this.simpleCentersAlgorithmRadioButton.isSelected()) {
            clusteringAlgorithm = ClusteringAlgorithmEnum.CentersSimples;
        } else if (this.singleLinkRadioButton.isSelected()) {
            clusteringAlgorithm = ClusteringAlgorithmEnum.SingleLink;
        } else if (this.averageLinkRadioButton.isSelected()) {
            clusteringAlgorithm = ClusteringAlgorithmEnum.AverageLink;
        } else if (this.completeLinkRadioButton.isSelected()) {
            clusteringAlgorithm = ClusteringAlgorithmEnum.CompleteLink;
        } else if (this.sumLinkRadioButton.isSelected()) {
            clusteringAlgorithm = ClusteringAlgorithmEnum.SumLink;
        }
        return clusteringAlgorithm;
    }

    public int getMaxNetworkSize() {
        return (Integer)this.maxNetworkSizeSpinner.getModel().getValue();
    }

    public int getMinNetworkSize() {
        return (Integer)this.minNetworkSizeSpinner.getModel().getValue();
    }

    public double getCutOff() {
        return (Double)this.cutOffSpinner.getModel().getValue();
    }

    private void initComponents() {
        this.clusteringAlgorithmbuttonGroup = new ButtonGroup();
        this.simpleCentersAlgorithmRadioButton = new JRadioButton();
        this.singleLinkRadioButton = new JRadioButton();
        this.completeLinkRadioButton = new JRadioButton();
        this.averageLinkRadioButton = new JRadioButton();
        this.sumLinkRadioButton = new JRadioButton();
        this.separator1 = new JSeparator();
        this.minNetworkSizeSpinner = new JSpinner();
        this.maxNetworkSizeSpinner = new JSpinner();
        this.minNetworkSizeDescriptionLabel = new JLabel();
        this.maxNetworkSizeDescriptionLabel = new JLabel();
        this.cutOffDescriptionLabel = new JLabel();
        this.cutOffSpinner = new JSpinner();
        this.clusteringAlgorithmbuttonGroup.add(this.simpleCentersAlgorithmRadioButton);
        this.simpleCentersAlgorithmRadioButton.setText("Simple centers algorithm");
        this.simpleCentersAlgorithmRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectClusteringAlgorithmPanel.this.simpleCentersAlgorithmRadioButtonActionPerformed(evt);
            }
        });
        this.clusteringAlgorithmbuttonGroup.add(this.singleLinkRadioButton);
        this.singleLinkRadioButton.setText("Single link clustering algorithm");
        this.singleLinkRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectClusteringAlgorithmPanel.this.singleLinkRadioButtonActionPerformed(evt);
            }
        });
        this.clusteringAlgorithmbuttonGroup.add(this.completeLinkRadioButton);
        this.completeLinkRadioButton.setText("Complete link clustering algorithm");
        this.completeLinkRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectClusteringAlgorithmPanel.this.completeLinkRadioButtonActionPerformed(evt);
            }
        });
        this.clusteringAlgorithmbuttonGroup.add(this.averageLinkRadioButton);
        this.averageLinkRadioButton.setText("Average link clustering algorithm");
        this.averageLinkRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectClusteringAlgorithmPanel.this.averageLinkRadioButtonActionPerformed(evt);
            }
        });
        this.clusteringAlgorithmbuttonGroup.add(this.sumLinkRadioButton);
        this.sumLinkRadioButton.setText("Sum link clustering algorithm");
        this.sumLinkRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectClusteringAlgorithmPanel.this.sumLinkRadioButtonActionPerformed(evt);
            }
        });
        this.minNetworkSizeSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.minNetworkSizeSpinner.setEnabled(false);
        this.maxNetworkSizeSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.maxNetworkSizeSpinner.setEnabled(false);
        this.minNetworkSizeDescriptionLabel.setLabelFor(this.minNetworkSizeSpinner);
        this.minNetworkSizeDescriptionLabel.setText("Minimum network size:");
        this.maxNetworkSizeDescriptionLabel.setLabelFor(this.maxNetworkSizeSpinner);
        this.maxNetworkSizeDescriptionLabel.setText("Maximum network size:");
        this.cutOffDescriptionLabel.setText("Cut off:");
        this.cutOffSpinner.setModel(new SpinnerNumberModel((Number)0.0, Double.valueOf(0.0), null, (Number)0.1));
        this.cutOffSpinner.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.singleLinkRadioButton).addComponent(this.sumLinkRadioButton).addComponent(this.averageLinkRadioButton).addComponent(this.completeLinkRadioButton).addComponent(this.simpleCentersAlgorithmRadioButton).addComponent(this.separator1, -1, 185, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.minNetworkSizeDescriptionLabel).addComponent(this.maxNetworkSizeDescriptionLabel).addComponent(this.cutOffDescriptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.maxNetworkSizeSpinner, -1, 54, Short.MAX_VALUE).addComponent(this.minNetworkSizeSpinner, -1, 54, Short.MAX_VALUE).addComponent(this.cutOffSpinner, -1, 54, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.simpleCentersAlgorithmRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.singleLinkRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.completeLinkRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.averageLinkRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sumLinkRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxNetworkSizeDescriptionLabel).addComponent(this.maxNetworkSizeSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minNetworkSizeDescriptionLabel).addComponent(this.minNetworkSizeSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cutOffDescriptionLabel).addComponent(this.cutOffSpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void simpleCentersAlgorithmRadioButtonActionPerformed(ActionEvent evt) {
        this.minNetworkSizeSpinner.setEnabled(true);
        this.maxNetworkSizeSpinner.setEnabled(true);
        if (this.getSelectedClusteringAlgorithm().equals(ClusteringAlgorithmEnum.CentersSimples)) {
            this.cutOffSpinner.setEnabled(false);
        } else {
            this.cutOffSpinner.setEnabled(true);
        }
        this.fireIncorrectDataObservers();
    }

    private void singleLinkRadioButtonActionPerformed(ActionEvent evt) {
        this.minNetworkSizeSpinner.setEnabled(true);
        this.maxNetworkSizeSpinner.setEnabled(true);
        this.cutOffSpinner.setEnabled(true);
        this.fireIncorrectDataObservers();
    }

    private void completeLinkRadioButtonActionPerformed(ActionEvent evt) {
        this.minNetworkSizeSpinner.setEnabled(true);
        this.maxNetworkSizeSpinner.setEnabled(true);
        this.cutOffSpinner.setEnabled(true);
        this.fireIncorrectDataObservers();
    }

    private void averageLinkRadioButtonActionPerformed(ActionEvent evt) {
        this.minNetworkSizeSpinner.setEnabled(true);
        this.maxNetworkSizeSpinner.setEnabled(true);
        this.cutOffSpinner.setEnabled(true);
        this.fireIncorrectDataObservers();
    }

    private void sumLinkRadioButtonActionPerformed(ActionEvent evt) {
        this.minNetworkSizeSpinner.setEnabled(true);
        this.maxNetworkSizeSpinner.setEnabled(true);
        this.cutOffSpinner.setEnabled(true);
        this.fireIncorrectDataObservers();
    }
}

