/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.wizard.Analysis;

import java.util.concurrent.ExecutionException;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import scimat.analysis.AnalysisConfiguration;
import scimat.analysis.CurrentAnalysis;
import scimat.analysis.DoAnalysisWorker;
import scimat.analysis.GlobalAnalysisResult;
import scimat.gui.commands.task.SaveAnalysisTask;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.analysisview.AnalysisViewManager;
import scimat.observabletask.ProgressTaskObserver;
import scimat.observabletask.StatusTaskObserver;
import scimat.observabletask.TaskStatus;
import scimat.project.CurrentProject;

public class DoAnalysisPanel
extends JPanel
implements StatusTaskObserver,
ProgressTaskObserver {
    private JLabel currentPeriodLabel;
    private JProgressBar globalProgressBar;
    private JLabel globalProgressDescriptionLabel;
    private DoAnalysisWorker worker;
    private GlobalAnalysisResult result;
    private JDialog dialog;

    public DoAnalysisPanel(JDialog dialog) {
        this.dialog = dialog;
        this.initComponents();
    }

    public void refreh() {
        this.globalProgressBar.setValue(0);
    }

    public void execute(AnalysisConfiguration analysisConfiguration) {
        this.worker = new DoAnalysisWorker(CurrentProject.getInstance().getKnowledgeBase(), analysisConfiguration);
        this.worker.addProgressTaskObserver(this);
        this.worker.addStatusTaskObserver(this);
        this.worker.execute();
    }

    public void statusTaskChanged(TaskStatus status) {
        switch (status) {
            case STARTED: {
                System.out.println("Task started");
                break;
            }
            case DONE: {
                System.out.println("Task done");
                try {
                    this.result = (GlobalAnalysisResult)this.worker.get();
                }
                catch (ExecutionException e) {
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                this.dialog.dispose();
                CurrentAnalysis.getInstance().setResults(this.result);
                new SaveAnalysisTask(this).execute();
                AnalysisViewManager.getInstance().showAnalysisViewDialog();
                break;
            }
            case CANCELLED: {
                this.dialog.dispose();
                break;
            }
            case EXCEPTION: {
                Exception e = this.worker.getException();
                ErrorDialogManager.getInstance().showException(e);
            }
        }
    }

    public void progressChanged(boolean determinateMode, int value) {
        this.globalProgressBar.setIndeterminate(!determinateMode);
        this.globalProgressBar.setValue(value);
    }

    public void cancelTask() {
        if (this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(true);
        }
    }

    private void initComponents() {
        this.currentPeriodLabel = new JLabel();
        this.globalProgressDescriptionLabel = new JLabel();
        this.globalProgressBar = new JProgressBar();
        this.globalProgressDescriptionLabel.setText("Global progress:");
        this.globalProgressBar.setStringPainted(true);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(80, 80, 80).addComponent(this.currentPeriodLabel).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.globalProgressDescriptionLabel).addContainerGap(166, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.globalProgressBar, -1, 234, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.currentPeriodLabel).addComponent(this.globalProgressDescriptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.globalProgressBar, -2, 40, -2)));
    }
}

