/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.tablemodel;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import scimat.gui.components.tablemodel.GenericTableModel;
import scimat.model.statistic.entity.StatisticPerPeriod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticPerPeriodTableModel
extends GenericTableModel<StatisticPerPeriod> {
    private NumberFormat numberFormatter = new DecimalFormat("0.##");

    public StatisticPerPeriodTableModel() {
        super(new String[]{"Period", "Documents", "Units", "Max", "Min", "Mean", "Median", "Standard desviation", "Variance"});
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            StatisticPerPeriod stat = (StatisticPerPeriod)this.getItem(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return stat.getPeriod().getName();
                }
                case 1: {
                    return stat.getPeriod().getDocumentsCount();
                }
                case 2: {
                    return stat.getUniqueGroupsCount();
                }
                case 3: {
                    return stat.getMax();
                }
                case 4: {
                    return stat.getMin();
                }
                case 5: {
                    return this.numberFormatter.format(stat.getMean());
                }
                case 6: {
                    return this.numberFormatter.format(stat.getMedian());
                }
                case 7: {
                    return this.numberFormatter.format(stat.getStandardDesviation());
                }
                case 8: {
                    return this.numberFormatter.format(stat.getVariance());
                }
            }
            return "";
        }
        return "";
    }
}

