/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.tablemodel;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import scimat.gui.components.observer.ElementsCountObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericTableModel<E>
extends AbstractTableModel {
    private String[] columnNames;
    protected ArrayList<E> data;
    private ArrayList<ElementsCountObserver> elementsCountObservers;

    public GenericTableModel(String[] columnNames) {
        this.columnNames = columnNames;
        this.data = new ArrayList();
        this.elementsCountObservers = new ArrayList();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.getRowCount() > 0) {
            return this.getValueAt(0, columnIndex).getClass();
        }
        return Void.class;
    }

    @Override
    public String getColumnName(int column) {
        if (column >= 0 && column < this.columnNames.length) {
            return this.columnNames[column];
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public E getItem(int rowIndex) {
        return this.data.get(rowIndex);
    }

    public ArrayList<E> getItems() {
        return new ArrayList<E>(this.data);
    }

    public void refreshItems(ArrayList<E> items) {
        this.data = items;
        this.fireTableDataChanged();
        this.fireElementsCountChange();
    }

    public void addElementsCountObserver(ElementsCountObserver observer) {
        this.elementsCountObservers.add(observer);
    }

    public void fireElementsCountChange() {
        for (int i = 0; i < this.elementsCountObservers.size(); ++i) {
            this.elementsCountObservers.get(i).elementsCountChanged(this.data.size());
        }
    }
}

