/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.tablemodel;

import java.util.ArrayList;
import java.util.Collections;
import scimat.gui.components.tablemodel.GenericTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericDynamicTableModel<E extends Comparable<E>>
extends GenericTableModel<E> {
    public GenericDynamicTableModel(String[] columnNames) {
        super(columnNames);
    }

    public void addItems(ArrayList<E> items) {
        for (int i = 0; i < items.size(); ++i) {
            Comparable item = (Comparable)items.get(i);
            int position = Collections.binarySearch(this.data, item);
            if (position >= 0) continue;
            position = -position - 1;
            this.data.add(position, item);
            this.fireTableRowsInserted(position, position);
            this.fireElementsCountChange();
        }
    }

    public void removeItems(ArrayList<E> items) {
        for (int i = 0; i < items.size(); ++i) {
            Comparable item = (Comparable)items.get(i);
            int position = Collections.binarySearch(this.data, item);
            if (position < 0) continue;
            this.data.remove(position);
            this.fireTableRowsDeleted(position, position);
            this.fireElementsCountChange();
        }
    }

    public void updateItems(ArrayList<E> items) {
        for (int i = 0; i < items.size(); ++i) {
            Comparable item = (Comparable)items.get(i);
            int position = Collections.binarySearch(this.data, item);
            if (position < 0) continue;
            this.data.set(position, item);
            this.fireTableRowsUpdated(position, position);
        }
    }
}

