/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.tablemodel;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import scimat.api.mapping.clustering.result.Cluster;
import scimat.api.utils.property.Property;
import scimat.gui.components.tablemodel.GenericTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterTableModel
extends GenericTableModel<Cluster> {
    private NumberFormat numberFormatter = new DecimalFormat(",##0.##");

    public ClusterTableModel() {
        super(new String[]{"Cluster", "Centrality", "Centrality range", "Density", "Density range"});
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            switch (columnIndex) {
                case 0: {
                    Property property = ((Cluster)this.getItem(rowIndex)).getProperties().getProperty("clusterName");
                    return property != null ? property.toString() : "";
                }
                case 1: {
                    Property property = ((Cluster)this.getItem(rowIndex)).getProperties().getProperty("callonCentrality");
                    return property != null ? Double.valueOf(this.numberFormatter.format((Double)property.getValue())) : "";
                }
                case 2: {
                    Property property = ((Cluster)this.getItem(rowIndex)).getProperties().getProperty("callonCentralityRange");
                    return property != null ? Double.valueOf(this.numberFormatter.format((Double)property.getValue())) : "";
                }
                case 3: {
                    Property property = ((Cluster)this.getItem(rowIndex)).getProperties().getProperty("callonDensity");
                    return property != null ? Double.valueOf(this.numberFormatter.format((Double)property.getValue())) : "";
                }
                case 4: {
                    Property property = ((Cluster)this.getItem(rowIndex)).getProperties().getProperty("callonDensityRange");
                    return property != null ? Double.valueOf(this.numberFormatter.format((Double)property.getValue())) : "";
                }
            }
            return "";
        }
        return "";
    }
}

