/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.statistic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import scimat.model.statistic.entity.StatisticPerPeriod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticBarChartPanel
extends JPanel {
    private JPanel barChartPanel;
    private JRadioButton documentsCountRadioButton;
    private JRadioButton maxRadioButton;
    private JRadioButton meanRadioButton;
    private JRadioButton medianRadioButton;
    private JRadioButton minRadioButton;
    private JRadioButton standarDesviationRadioButton;
    private ButtonGroup statButtonGroup;
    private JRadioButton unitsCountRadioButton;
    private JRadioButton varianceRadioButton;
    private ArrayList<StatisticPerPeriod> stats;
    private ChartPanel chartPanel;
    private JFreeChart chart;
    private DefaultCategoryDataset dataset;

    public StatisticBarChartPanel() {
        this.initComponents();
        this.dataset = new DefaultCategoryDataset();
        this.chart = ChartFactory.createBarChart((String)"", (String)"", (String)"", (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        this.chartPanel = new ChartPanel(this.chart);
        this.barChartPanel.add((Component)this.chartPanel);
    }

    public void refresh(ArrayList<StatisticPerPeriod> stats) {
        this.stats = stats;
        this.documentsCountRadioButton.doClick();
    }

    private void refreshChart(SelectedChart selection) {
        String label;
        String title;
        this.dataset = new DefaultCategoryDataset();
        switch (selection) {
            case Documents: {
                title = "Documents per period";
                label = "Documents";
                break;
            }
            case Units: {
                title = "Unique units of analysis";
                label = "Units";
                break;
            }
            case Max: {
                title = "Max units per document";
                label = "Units";
                break;
            }
            case Min: {
                title = "Min units per document";
                label = "Units";
                break;
            }
            case Mean: {
                title = "Average of units per document";
                label = "Units";
                break;
            }
            case Median: {
                title = "Median units per document";
                label = "Units";
                break;
            }
            case StandardDesviation: {
                title = "Standar desviation of units per document";
                label = "Units";
                break;
            }
            case Variance: {
                title = "Variance of units per document";
                label = "Units";
                break;
            }
            default: {
                title = "";
                label = "";
            }
        }
        block20: for (int i = 0; i < this.stats.size(); ++i) {
            StatisticPerPeriod stat = this.stats.get(i);
            switch (selection) {
                case Documents: {
                    this.dataset.addValue((double)stat.getPeriod().getDocumentsCount(), (Comparable)((Object)"Period"), (Comparable)((Object)stat.getPeriod().getName()));
                    continue block20;
                }
                case Units: {
                    this.dataset.addValue((double)stat.getUniqueGroupsCount(), (Comparable)((Object)"Period"), (Comparable)((Object)stat.getPeriod().getName()));
                    continue block20;
                }
                case Max: {
                    this.dataset.addValue((double)stat.getMax(), (Comparable)((Object)"Period"), (Comparable)((Object)stat.getPeriod().getName()));
                    continue block20;
                }
                case Min: {
                    this.dataset.addValue((double)stat.getMin(), (Comparable)((Object)"Period"), (Comparable)((Object)stat.getPeriod().getName()));
                    continue block20;
                }
                case Mean: {
                    this.dataset.addValue(stat.getMean(), (Comparable)((Object)"Period"), (Comparable)((Object)stat.getPeriod().getName()));
                    continue block20;
                }
                case Median: {
                    this.dataset.addValue(stat.getMedian(), (Comparable)((Object)"Period"), (Comparable)((Object)stat.getPeriod().getName()));
                    continue block20;
                }
                case StandardDesviation: {
                    this.dataset.addValue(stat.getStandardDesviation(), (Comparable)((Object)"Period"), (Comparable)((Object)stat.getPeriod().getName()));
                    continue block20;
                }
                case Variance: {
                    this.dataset.addValue(stat.getVariance(), (Comparable)((Object)"Period"), (Comparable)((Object)stat.getPeriod().getName()));
                }
            }
        }
        this.chart = ChartFactory.createBarChart((String)title, (String)"", (String)label, (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        this.chart.getCategoryPlot().getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.STANDARD);
        this.chartPanel.setChart(this.chart);
        this.chart.fireChartChanged();
    }

    private void initComponents() {
        this.statButtonGroup = new ButtonGroup();
        this.documentsCountRadioButton = new JRadioButton();
        this.unitsCountRadioButton = new JRadioButton();
        this.maxRadioButton = new JRadioButton();
        this.minRadioButton = new JRadioButton();
        this.meanRadioButton = new JRadioButton();
        this.medianRadioButton = new JRadioButton();
        this.standarDesviationRadioButton = new JRadioButton();
        this.varianceRadioButton = new JRadioButton();
        this.barChartPanel = new JPanel();
        this.statButtonGroup.add(this.documentsCountRadioButton);
        this.documentsCountRadioButton.setText("Documents");
        this.documentsCountRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StatisticBarChartPanel.this.documentsCountRadioButtonActionPerformed(evt);
            }
        });
        this.statButtonGroup.add(this.unitsCountRadioButton);
        this.unitsCountRadioButton.setText("Unique units");
        this.unitsCountRadioButton.setToolTipText("Unique units of analysis");
        this.unitsCountRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StatisticBarChartPanel.this.unitsCountRadioButtonActionPerformed(evt);
            }
        });
        this.statButtonGroup.add(this.maxRadioButton);
        this.maxRadioButton.setText("Max");
        this.maxRadioButton.setToolTipText("Max unit per document");
        this.maxRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StatisticBarChartPanel.this.maxRadioButtonActionPerformed(evt);
            }
        });
        this.statButtonGroup.add(this.minRadioButton);
        this.minRadioButton.setText("Min");
        this.minRadioButton.setToolTipText("Min unit per document");
        this.minRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StatisticBarChartPanel.this.minRadioButtonActionPerformed(evt);
            }
        });
        this.statButtonGroup.add(this.meanRadioButton);
        this.meanRadioButton.setText("Average");
        this.meanRadioButton.setToolTipText("Average number of unit per document");
        this.meanRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StatisticBarChartPanel.this.meanRadioButtonActionPerformed(evt);
            }
        });
        this.statButtonGroup.add(this.medianRadioButton);
        this.medianRadioButton.setText("Median");
        this.medianRadioButton.setToolTipText("Median of unit per document");
        this.medianRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StatisticBarChartPanel.this.medianRadioButtonActionPerformed(evt);
            }
        });
        this.statButtonGroup.add(this.standarDesviationRadioButton);
        this.standarDesviationRadioButton.setText("Standard desviation");
        this.standarDesviationRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StatisticBarChartPanel.this.standarDesviationRadioButtonActionPerformed(evt);
            }
        });
        this.statButtonGroup.add(this.varianceRadioButton);
        this.varianceRadioButton.setText("Variance");
        this.varianceRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StatisticBarChartPanel.this.varianceRadioButtonActionPerformed(evt);
            }
        });
        this.barChartPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.minRadioButton).addComponent(this.meanRadioButton).addComponent(this.documentsCountRadioButton).addComponent(this.unitsCountRadioButton).addComponent(this.medianRadioButton).addComponent(this.standarDesviationRadioButton).addComponent(this.varianceRadioButton).addComponent(this.maxRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.barChartPanel, -1, 234, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.documentsCountRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unitsCountRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxRadioButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.meanRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.medianRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.standarDesviationRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.varianceRadioButton).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.barChartPanel, -1, 191, Short.MAX_VALUE));
    }

    private void documentsCountRadioButtonActionPerformed(ActionEvent evt) {
        this.refreshChart(SelectedChart.Documents);
    }

    private void unitsCountRadioButtonActionPerformed(ActionEvent evt) {
        this.refreshChart(SelectedChart.Units);
    }

    private void maxRadioButtonActionPerformed(ActionEvent evt) {
        this.refreshChart(SelectedChart.Max);
    }

    private void minRadioButtonActionPerformed(ActionEvent evt) {
        this.refreshChart(SelectedChart.Min);
    }

    private void meanRadioButtonActionPerformed(ActionEvent evt) {
        this.refreshChart(SelectedChart.Mean);
    }

    private void medianRadioButtonActionPerformed(ActionEvent evt) {
        this.refreshChart(SelectedChart.Median);
    }

    private void standarDesviationRadioButtonActionPerformed(ActionEvent evt) {
        this.refreshChart(SelectedChart.StandardDesviation);
    }

    private void varianceRadioButtonActionPerformed(ActionEvent evt) {
        this.refreshChart(SelectedChart.Variance);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SelectedChart {
        Documents,
        Units,
        Max,
        Min,
        Mean,
        Median,
        StandardDesviation,
        Variance;

    }
}

