/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.statistic;

import java.awt.Frame;
import java.util.ArrayList;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.statistic.GenericStatisticDialog;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceGroupStatisticDialog
extends GenericStatisticDialog {
    public ReferenceGroupStatisticDialog(Frame parent) {
        super(parent, "Reference groups statistics");
    }

    @Override
    public int getUniqueGroups(Integer periodID) {
        int result;
        try {
            result = CurrentProject.getInstance().getFactoryDAO().getStatisticDAO().getUniqueReferenceGroupsCount(periodID);
        }
        catch (KnowledgeBaseException e) {
            result = 0;
            ErrorDialogManager.getInstance().showException(e);
        }
        return result;
    }

    @Override
    public ArrayList<Integer> retrieveStatistic(Integer periodID) {
        ArrayList<Integer> freqs;
        try {
            freqs = CurrentProject.getInstance().getFactoryDAO().getStatisticDAO().getReferenceGroupsCountPerDocument(periodID);
        }
        catch (KnowledgeBaseException e) {
            freqs = new ArrayList();
            ErrorDialogManager.getInstance().showException(e);
        }
        return freqs;
    }
}

