/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.statistic;

import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import scimat.api.analysis.statistic.StatisticBasedFrequency;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.itemslist.StatisticPerPeriodListPanel;
import scimat.gui.components.statistic.FrequencyDistributionPanel;
import scimat.gui.components.statistic.StatisticBarChartPanel;
import scimat.model.knowledgebase.entity.Period;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.model.statistic.entity.FrequencyDistributionPerPeriod;
import scimat.model.statistic.entity.StatisticPerPeriod;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericStatisticDialog
extends JDialog {
    private JPanel chartPanel;
    private FrequencyDistributionPanel frequencyDistributionPanel;
    private StatisticBarChartPanel statisticBarChartPanel;
    private JPanel statisticPanel;
    private StatisticPerPeriodListPanel statisticPerPeriodListPanel;

    public GenericStatisticDialog(Frame parent, String title) {
        super(parent, true);
        this.initComponents();
        this.setTitle("SciMAT v1.1 - " + title);
    }

    public void refresh() {
        ArrayList<StatisticPerPeriod> stats = new ArrayList<StatisticPerPeriod>();
        ArrayList<FrequencyDistributionPerPeriod> freqs = new ArrayList<FrequencyDistributionPerPeriod>();
        try {
            ArrayList<Period> periods = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().getPeriods();
            for (int i = 0; i < periods.size(); ++i) {
                Period period = periods.get(i);
                StatisticBasedFrequency stat = new StatisticBasedFrequency(this.retrieveStatistic(period.getPeriodID()));
                stats.add(new StatisticPerPeriod(period, this.getUniqueGroups(period.getPeriodID()), stat.getMax(), stat.getMin(), stat.getMean(), stat.getMedian(), stat.getStandardDesviation(), stat.getVariance()));
                freqs.add(new FrequencyDistributionPerPeriod(period, stat));
            }
            this.statisticPerPeriodListPanel.refreshItems(stats);
            this.statisticBarChartPanel.refresh(stats);
            this.frequencyDistributionPanel.refresh(freqs);
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
    }

    public abstract ArrayList<Integer> retrieveStatistic(Integer var1);

    public abstract int getUniqueGroups(Integer var1);

    private void initComponents() {
        this.statisticPanel = new JPanel();
        this.statisticPerPeriodListPanel = new StatisticPerPeriodListPanel();
        this.chartPanel = new JPanel();
        this.statisticBarChartPanel = new StatisticBarChartPanel();
        this.frequencyDistributionPanel = new FrequencyDistributionPanel();
        this.setDefaultCloseOperation(2);
        this.statisticPanel.setBorder(BorderFactory.createTitledBorder("Statistic information"));
        GroupLayout statisticPanelLayout = new GroupLayout(this.statisticPanel);
        this.statisticPanel.setLayout(statisticPanelLayout);
        statisticPanelLayout.setHorizontalGroup(statisticPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statisticPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statisticPerPeriodListPanel, -1, 815, Short.MAX_VALUE).addContainerGap()));
        statisticPanelLayout.setVerticalGroup(statisticPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statisticPanelLayout.createSequentialGroup().addComponent(this.statisticPerPeriodListPanel, -2, 152, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.chartPanel.setBorder(BorderFactory.createTitledBorder("Charts"));
        GroupLayout chartPanelLayout = new GroupLayout(this.chartPanel);
        this.chartPanel.setLayout(chartPanelLayout);
        chartPanelLayout.setHorizontalGroup(chartPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(chartPanelLayout.createSequentialGroup().addComponent(this.statisticBarChartPanel, -1, 461, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.frequencyDistributionPanel, -1, 368, Short.MAX_VALUE)));
        chartPanelLayout.setVerticalGroup(chartPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.frequencyDistributionPanel, -1, 191, Short.MAX_VALUE).addComponent(this.statisticBarChartPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.statisticPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.chartPanel, GroupLayout.Alignment.LEADING, -2, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.statisticPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chartPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }
}

