/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.statistic;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import scimat.model.statistic.entity.FrequencyDistributionPerPeriod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrequencyDistributionPanel
extends JPanel {
    private ArrayList<FrequencyDistributionPerPeriod> frequencies;
    private ChartPanel chartPanel;
    private JFreeChart chart;
    private XYSeriesCollection dataset;

    public FrequencyDistributionPanel() {
        this.initComponents();
        this.dataset = new XYSeriesCollection();
        this.chart = ChartFactory.createXYLineChart((String)"Frequency distribution", (String)"Units", (String)"Documents", (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        this.chartPanel = new ChartPanel(this.chart);
        this.add((Component)this.chartPanel);
    }

    public void refresh(ArrayList<FrequencyDistributionPerPeriod> frequencies) {
        this.frequencies = frequencies;
        this.refreshChart();
    }

    private void refreshChart() {
        this.dataset.removeAllSeries();
        for (int i = 0; i < this.frequencies.size(); ++i) {
            FrequencyDistributionPerPeriod periodFrequency = this.frequencies.get(i);
            XYSeries xySeries = new XYSeries((Comparable)((Object)periodFrequency.getPeriod().getName()));
            long maxFreq = periodFrequency.getStats().getMaxFrequency();
            int j = 1;
            while ((long)j <= maxFreq) {
                xySeries.add((double)j, (double)periodFrequency.getStats().getCumFrequency(j));
                ++j;
            }
            this.dataset.addSeries(xySeries);
        }
        this.chart = ChartFactory.createXYLineChart((String)"Frequency distribution", (String)"", (String)"Documents", (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.chartPanel.setChart(this.chart);
        this.chart.fireChartChanged();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 2));
    }
}

