/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.slavepanel;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.slavepanel.GenericOneSlaveItemPanel;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.entity.WordGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;
import scimat.project.observer.EntityObserver;
import scimat.project.observer.WordGroupRelationWordObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordSlaveWordGroupPanel
extends GenericOneSlaveItemPanel
implements WordGroupRelationWordObserver,
EntityObserver<WordGroup> {
    private JLabel groupNameDescriptionLabel;
    private JTextField groupNameTextField;
    private JCheckBox stopGroupCheckBox;
    private Word word = null;
    private WordGroup wordGroup = null;

    public WordSlaveWordGroupPanel() {
        this.initComponents();
        CurrentProject.getInstance().getKbObserver().addWordGroupRelationWordsObserver(this);
        CurrentProject.getInstance().getKbObserver().addWordGroupObserver(this);
    }

    private void refresh() {
        if (this.wordGroup != null) {
            this.groupNameTextField.setText(this.wordGroup.getGroupName());
            this.stopGroupCheckBox.setSelected(this.wordGroup.isStopGroup());
            this.fireSlaveItemObserver(true);
        } else {
            this.groupNameTextField.setText("");
            this.stopGroupCheckBox.setSelected(false);
        }
    }

    public void setMasterItem(Word word) {
        this.word = word;
        try {
            if (this.word != null) {
                this.relationChanged();
            } else {
                this.wordGroup = null;
                this.refresh();
            }
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
    }

    @Override
    public void relationChanged() throws KnowledgeBaseException {
        this.wordGroup = this.word != null ? CurrentProject.getInstance().getFactoryDAO().getWordDAO().getWordGroup(this.word.getWordID()) : null;
        this.refresh();
    }

    @Override
    public void entityAdded(ArrayList<WordGroup> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRefresh() throws KnowledgeBaseException {
        if (this.wordGroup != null) {
            this.wordGroup = CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO().getWordGroup(this.wordGroup.getWordGroupID());
            this.refresh();
        }
    }

    @Override
    public void entityRemoved(ArrayList<WordGroup> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityUpdated(ArrayList<WordGroup> items) throws KnowledgeBaseException {
        int position;
        if (this.wordGroup != null && (position = items.indexOf(this.wordGroup)) != -1) {
            this.wordGroup = items.get(position);
        }
    }

    private void initComponents() {
        this.groupNameDescriptionLabel = new JLabel();
        this.groupNameTextField = new JTextField();
        this.stopGroupCheckBox = new JCheckBox();
        this.groupNameDescriptionLabel.setText("Group name:");
        this.groupNameTextField.setEditable(false);
        this.stopGroupCheckBox.setText("is stop group?");
        this.stopGroupCheckBox.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.groupNameDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.groupNameTextField, -1, 245, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.stopGroupCheckBox).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.groupNameDescriptionLabel).addComponent(this.groupNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopGroupCheckBox)));
    }
}

