/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.slavepanel;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.slavepanel.GenericOneSlaveItemPanel;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.entity.ReferenceSourceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;
import scimat.project.observer.EntityObserver;
import scimat.project.observer.ReferenceSourceGroupRelationReferenceSourceObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceSourceSlaveReferenceSourceGroupPanel
extends GenericOneSlaveItemPanel
implements ReferenceSourceGroupRelationReferenceSourceObserver,
EntityObserver<ReferenceSourceGroup> {
    private JLabel groupNameDescriptionLabel;
    private JTextField groupNameTextField;
    private JCheckBox stopGroupCheckBox;
    private ReferenceSource referenceSource = null;
    private ReferenceSourceGroup referenceSourceGroup = null;

    public ReferenceSourceSlaveReferenceSourceGroupPanel() {
        this.initComponents();
        CurrentProject.getInstance().getKbObserver().addReferenceSourceGroupRelationReferenceSourcesObserver(this);
        CurrentProject.getInstance().getKbObserver().addReferenceSourceGroupObserver(this);
    }

    private void refresh() {
        if (this.referenceSourceGroup != null) {
            this.groupNameTextField.setText(this.referenceSourceGroup.getGroupName());
            this.stopGroupCheckBox.setSelected(this.referenceSourceGroup.isStopGroup());
            this.fireSlaveItemObserver(true);
        } else {
            this.groupNameTextField.setText("");
            this.stopGroupCheckBox.setSelected(false);
        }
    }

    public void setMasterItem(ReferenceSource referenceSource) {
        this.referenceSource = referenceSource;
        try {
            if (this.referenceSource != null) {
                this.relationChanged();
            } else {
                this.referenceSourceGroup = null;
                this.refresh();
            }
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
    }

    @Override
    public void relationChanged() throws KnowledgeBaseException {
        this.referenceSourceGroup = this.referenceSource != null ? CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO().getReferenceSourceGroup(this.referenceSource.getReferenceSourceID()) : null;
        this.refresh();
    }

    @Override
    public void entityAdded(ArrayList<ReferenceSourceGroup> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRefresh() throws KnowledgeBaseException {
        if (this.referenceSourceGroup != null) {
            this.referenceSourceGroup = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceGroupDAO().getReferenceSourceGroup(this.referenceSourceGroup.getReferenceSourceGroupID());
            this.refresh();
        }
    }

    @Override
    public void entityRemoved(ArrayList<ReferenceSourceGroup> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityUpdated(ArrayList<ReferenceSourceGroup> items) throws KnowledgeBaseException {
        int position;
        if (this.referenceSourceGroup != null && (position = items.indexOf(this.referenceSourceGroup)) != -1) {
            this.referenceSourceGroup = items.get(position);
        }
    }

    private void initComponents() {
        this.groupNameDescriptionLabel = new JLabel();
        this.groupNameTextField = new JTextField();
        this.stopGroupCheckBox = new JCheckBox();
        this.groupNameDescriptionLabel.setText("Group name:");
        this.groupNameTextField.setEditable(false);
        this.stopGroupCheckBox.setText("is stop group?");
        this.stopGroupCheckBox.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.groupNameDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.groupNameTextField, -1, 245, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.stopGroupCheckBox).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.groupNameDescriptionLabel).addComponent(this.groupNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopGroupCheckBox)));
    }
}

