/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.slavepanel;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.slavepanel.GenericOneSlaveItemPanel;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;
import scimat.project.observer.EntityObserver;
import scimat.project.observer.ReferenceSourceRelationReferenceObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceSlaveReferenceSourcePanel
extends GenericOneSlaveItemPanel
implements ReferenceSourceRelationReferenceObserver,
EntityObserver<ReferenceSource> {
    private JLabel sourceDescriptionLabel;
    private JTextField sourceTextField;
    private Reference reference = null;
    private ReferenceSource referenceSource = null;

    public ReferenceSlaveReferenceSourcePanel() {
        this.initComponents();
    }

    private void refresh() {
        if (this.referenceSource != null) {
            this.sourceTextField.setText(this.referenceSource.getSource());
            this.fireSlaveItemObserver(true);
        } else {
            this.sourceTextField.setText("");
        }
    }

    public void setMasterItem(Reference reference) {
        this.reference = reference;
        try {
            if (this.reference != null) {
                this.relationChanged();
            } else {
                this.referenceSource = null;
                this.refresh();
            }
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
    }

    @Override
    public void relationChanged() throws KnowledgeBaseException {
        this.referenceSource = this.reference != null ? CurrentProject.getInstance().getFactoryDAO().getReferenceDAO().getReferenceSource(this.reference.getReferenceID()) : null;
        this.refresh();
    }

    @Override
    public void entityAdded(ArrayList<ReferenceSource> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRefresh() throws KnowledgeBaseException {
        if (this.referenceSource != null) {
            this.referenceSource = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO().getReferenceSource(this.reference.getReferenceID());
            this.refresh();
        }
    }

    @Override
    public void entityRemoved(ArrayList<ReferenceSource> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityUpdated(ArrayList<ReferenceSource> items) throws KnowledgeBaseException {
        int position;
        if (this.referenceSource != null && (position = items.indexOf(this.referenceSource)) != -1) {
            this.referenceSource = items.get(position);
        }
    }

    private void initComponents() {
        this.sourceDescriptionLabel = new JLabel();
        this.sourceTextField = new JTextField();
        this.sourceDescriptionLabel.setLabelFor(this.sourceTextField);
        this.sourceDescriptionLabel.setText("Source:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.sourceDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceTextField, -1, 175, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sourceDescriptionLabel).addComponent(this.sourceTextField, -2, -1, -2)));
    }
}

