/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.slavepanel;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.slavepanel.GenericOneSlaveItemPanel;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.ReferenceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;
import scimat.project.observer.EntityObserver;
import scimat.project.observer.ReferenceGroupRelationReferenceObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceSlaveReferenceGroupPanel
extends GenericOneSlaveItemPanel
implements ReferenceGroupRelationReferenceObserver,
EntityObserver<ReferenceGroup> {
    private JLabel groupNameDescriptionLabel;
    private JTextField groupNameTextField;
    private JCheckBox stopGroupCheckBox;
    private Reference reference = null;
    private ReferenceGroup referenceGroup = null;

    public ReferenceSlaveReferenceGroupPanel() {
        this.initComponents();
        CurrentProject.getInstance().getKbObserver().addReferenceGroupRelationReferencesObserver(this);
        CurrentProject.getInstance().getKbObserver().addReferenceGroupObserver(this);
    }

    private void refresh() {
        if (this.referenceGroup != null) {
            this.groupNameTextField.setText(this.referenceGroup.getGroupName());
            this.stopGroupCheckBox.setSelected(this.referenceGroup.isStopGroup());
            this.fireSlaveItemObserver(true);
        } else {
            this.groupNameTextField.setText("");
            this.stopGroupCheckBox.setSelected(false);
        }
    }

    public void setMasterItem(Reference reference) {
        this.reference = reference;
        try {
            if (this.reference != null) {
                this.relationChanged();
            } else {
                this.referenceGroup = null;
                this.refresh();
            }
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
    }

    @Override
    public void relationChanged() throws KnowledgeBaseException {
        this.referenceGroup = this.reference != null ? CurrentProject.getInstance().getFactoryDAO().getReferenceDAO().getReferenceGroup(this.reference.getReferenceID()) : null;
        this.refresh();
    }

    @Override
    public void entityAdded(ArrayList<ReferenceGroup> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRefresh() throws KnowledgeBaseException {
        if (this.referenceGroup != null) {
            this.referenceGroup = CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO().getReferenceGroup(this.referenceGroup.getReferenceGroupID());
            this.refresh();
        }
    }

    @Override
    public void entityRemoved(ArrayList<ReferenceGroup> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityUpdated(ArrayList<ReferenceGroup> items) throws KnowledgeBaseException {
        int position;
        if (this.referenceGroup != null && (position = items.indexOf(this.referenceGroup)) != -1) {
            this.referenceGroup = items.get(position);
        }
    }

    private void initComponents() {
        this.groupNameDescriptionLabel = new JLabel();
        this.groupNameTextField = new JTextField();
        this.stopGroupCheckBox = new JCheckBox();
        this.groupNameDescriptionLabel.setText("Group name:");
        this.groupNameTextField.setEditable(false);
        this.stopGroupCheckBox.setText("is stop group?");
        this.stopGroupCheckBox.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.groupNameDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.groupNameTextField, -1, 245, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.stopGroupCheckBox).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.groupNameDescriptionLabel).addComponent(this.groupNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopGroupCheckBox)));
    }
}

