/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.slavepanel;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import scimat.gui.components.observer.ElementsCountObserver;
import scimat.gui.components.observer.SelectionObserver;
import scimat.gui.components.tablemodel.GenericTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericSlaveListPanel<M, S>
extends JPanel
implements ElementsCountObserver {
    private JLabel itemsCountDescriptionLabel;
    private JLabel itemsCountLabel;
    private JScrollPane scrollPane;
    private JTable table;
    protected M masterItem;
    private GenericTableModel<S> tableModel;
    private ArrayList<SelectionObserver> selectionObservers;
    private TableRowSorter<GenericTableModel<S>> tableRowSorter;
    private int[] selectedRows;

    public GenericSlaveListPanel(GenericTableModel<S> tableModel) {
        this.tableModel = tableModel;
        this.tableRowSorter = new TableRowSorter<GenericTableModel<S>>(tableModel);
        this.tableModel.addElementsCountObserver(this);
        this.selectionObservers = new ArrayList();
        this.selectedRows = new int[0];
        this.masterItem = null;
        this.initComponents();
        this.table.setModel(tableModel);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    GenericSlaveListPanel.this.notifySelectionObserver(GenericSlaveListPanel.this.table.getSelectedRows());
                }
            }
        });
    }

    public abstract void setMasterItem(M var1);

    public M getMasterItem() {
        return this.masterItem;
    }

    public void refreshData(ArrayList<S> items) {
        this.tableModel.refreshItems(items);
    }

    public S getItem(int rowIndex) {
        return this.tableModel.getItem(rowIndex);
    }

    public ArrayList<S> getSelectedItems() {
        ArrayList<S> items = new ArrayList<S>();
        for (int i = 0; i < this.selectedRows.length; ++i) {
            items.add(this.getItem(this.selectedRows[i]));
        }
        return items;
    }

    public int[] getSelectedRows() {
        return this.selectedRows;
    }

    public void addSelectionObserver(SelectionObserver o) {
        this.selectionObservers.add(o);
    }

    private void notifySelectionObserver(int[] selection) {
        int i;
        this.selectedRows = new int[selection.length];
        for (i = 0; i < selection.length; ++i) {
            this.selectedRows[i] = this.table.convertRowIndexToModel(selection[i]);
        }
        for (i = 0; i < this.selectionObservers.size(); ++i) {
            this.selectionObservers.get(i).selectionChangeHappened(this.selectedRows);
        }
    }

    @Override
    public void elementsCountChanged(int newElementsCount) {
        this.itemsCountLabel.setText(String.valueOf(newElementsCount));
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.table = new JTable();
        this.itemsCountDescriptionLabel = new JLabel();
        this.itemsCountLabel = new JLabel();
        this.table.setRowSorter(this.tableRowSorter);
        this.scrollPane.setViewportView(this.table);
        this.itemsCountDescriptionLabel.setText("Items:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 261, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.itemsCountDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.itemsCountLabel)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.scrollPane, -1, 100, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.itemsCountLabel).addComponent(this.itemsCountDescriptionLabel))));
    }
}

