/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.slavepanel;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.slavepanel.GenericOneSlaveItemPanel;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;
import scimat.project.observer.EntityObserver;
import scimat.project.observer.PublishDateRelationDocumentObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentSlavePublishDatePanel
extends GenericOneSlaveItemPanel
implements PublishDateRelationDocumentObserver,
EntityObserver<PublishDate> {
    private JLabel dateDescriptionLabel;
    private JTextField dateTextField;
    private JLabel yearDescriptionLabel;
    private JTextField yearTextField;
    private Document document = null;
    private PublishDate publishDate = null;

    public DocumentSlavePublishDatePanel() {
        this.initComponents();
        CurrentProject.getInstance().getKbObserver().addPublishDateRelationDocumentsObserver(this);
        CurrentProject.getInstance().getKbObserver().addPublishDateObserver(this);
    }

    private void refresh() {
        if (this.publishDate != null) {
            this.yearTextField.setText(this.publishDate.getYear());
            this.dateTextField.setText(this.publishDate.getDate());
            this.fireSlaveItemObserver(true);
        } else {
            this.yearTextField.setText("");
            this.dateTextField.setText("");
        }
    }

    public void setMasterItem(Document document) {
        this.document = document;
        try {
            if (this.document != null) {
                this.relationChanged();
            } else {
                this.publishDate = null;
                this.refresh();
            }
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
    }

    @Override
    public void relationChanged() throws KnowledgeBaseException {
        this.publishDate = this.document != null ? CurrentProject.getInstance().getFactoryDAO().getDocumentDAO().getPublishDate(this.document.getDocumentID()) : null;
        this.refresh();
    }

    @Override
    public void entityAdded(ArrayList<PublishDate> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRefresh() throws KnowledgeBaseException {
        if (this.publishDate != null) {
            this.publishDate = CurrentProject.getInstance().getFactoryDAO().getPublishDateDAO().getPublishDate(this.document.getDocumentID());
            this.refresh();
        }
    }

    @Override
    public void entityRemoved(ArrayList<PublishDate> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityUpdated(ArrayList<PublishDate> items) throws KnowledgeBaseException {
        int position;
        if (this.publishDate != null && (position = items.indexOf(this.publishDate)) != -1) {
            this.publishDate = items.get(position);
        }
    }

    private void initComponents() {
        this.yearDescriptionLabel = new JLabel();
        this.yearTextField = new JTextField();
        this.dateDescriptionLabel = new JLabel();
        this.dateTextField = new JTextField();
        this.yearDescriptionLabel.setText("Year:");
        this.yearTextField.setEditable(false);
        this.dateDescriptionLabel.setText("Date:");
        this.dateTextField.setEditable(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.yearDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yearTextField, -1, 100, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dateDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dateTextField, -1, 101, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.yearDescriptionLabel).addComponent(this.yearTextField, -2, -1, -2).addComponent(this.dateDescriptionLabel).addComponent(this.dateTextField, -2, -1, -2)));
    }
}

