/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.slavepanel;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.slavepanel.GenericOneSlaveItemPanel;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.Journal;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;
import scimat.project.observer.EntityObserver;
import scimat.project.observer.JournalRelationDocumentObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentSlaveJournalPanel
extends GenericOneSlaveItemPanel
implements JournalRelationDocumentObserver,
EntityObserver<Journal> {
    private JLabel sourceDescriptionLabel;
    private JTextField sourceTextField;
    private Document document = null;
    private Journal journal = null;

    public DocumentSlaveJournalPanel() {
        this.initComponents();
        CurrentProject.getInstance().getKbObserver().addJournalRelationDocumentsObserver(this);
        CurrentProject.getInstance().getKbObserver().addJournalObserver(this);
    }

    private void refresh() {
        if (this.journal != null) {
            this.sourceTextField.setText(this.journal.getSource());
            this.fireSlaveItemObserver(true);
        } else {
            this.sourceTextField.setText("");
            this.fireSlaveItemObserver(false);
        }
    }

    public void setMasterItem(Document document) {
        this.document = document;
        try {
            if (this.document != null) {
                this.relationChanged();
            } else {
                this.journal = null;
                this.refresh();
            }
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
    }

    @Override
    public void relationChanged() throws KnowledgeBaseException {
        this.journal = this.document != null ? CurrentProject.getInstance().getFactoryDAO().getDocumentDAO().getJournal(this.document.getDocumentID()) : null;
        this.refresh();
    }

    @Override
    public void entityAdded(ArrayList<Journal> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRefresh() throws KnowledgeBaseException {
        if (this.journal != null) {
            this.journal = CurrentProject.getInstance().getFactoryDAO().getJournalDAO().getJournal(this.document.getDocumentID());
            this.refresh();
        }
    }

    @Override
    public void entityRemoved(ArrayList<Journal> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityUpdated(ArrayList<Journal> items) throws KnowledgeBaseException {
        int position;
        if (this.journal != null && (position = items.indexOf(this.journal)) != -1) {
            this.journal = items.get(position);
        }
    }

    private void initComponents() {
        this.sourceDescriptionLabel = new JLabel();
        this.sourceTextField = new JTextField();
        this.sourceDescriptionLabel.setText("Source:");
        this.sourceTextField.setEditable(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.sourceDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceTextField, -1, 263, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sourceDescriptionLabel).addComponent(this.sourceTextField, -2, -1, -2)));
    }
}

