/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.slavepanel;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.slavepanel.GenericOneSlaveItemPanel;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.AuthorGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;
import scimat.project.observer.AuthorGroupRelationAuthorObserver;
import scimat.project.observer.EntityObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorSlaveAuthorGroupPanel
extends GenericOneSlaveItemPanel
implements AuthorGroupRelationAuthorObserver,
EntityObserver<AuthorGroup> {
    private JLabel groupNameDescriptionLabel;
    private JTextField groupNameTextField;
    private JCheckBox stopGroupCheckBox;
    private Author author = null;
    private AuthorGroup authorGroup = null;

    public AuthorSlaveAuthorGroupPanel() {
        this.initComponents();
        CurrentProject.getInstance().getKbObserver().addAuthorGroupRelationAuthorsObserver(this);
        CurrentProject.getInstance().getKbObserver().addAuthorGroupObserver(this);
    }

    private void refresh() {
        if (this.authorGroup != null) {
            this.groupNameTextField.setText(this.authorGroup.getGroupName());
            this.stopGroupCheckBox.setSelected(this.authorGroup.isStopGroup());
            this.fireSlaveItemObserver(true);
        } else {
            this.groupNameTextField.setText("");
            this.stopGroupCheckBox.setSelected(false);
        }
    }

    public void setMasterItem(Author author) {
        this.author = author;
        try {
            if (this.author != null) {
                this.relationChanged();
            } else {
                this.authorGroup = null;
                this.refresh();
            }
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
    }

    @Override
    public void relationChanged() throws KnowledgeBaseException {
        this.authorGroup = this.author != null ? CurrentProject.getInstance().getFactoryDAO().getAuthorDAO().getAuthorGroup(this.author.getAuthorID()) : null;
        this.refresh();
    }

    @Override
    public void entityAdded(ArrayList<AuthorGroup> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRefresh() throws KnowledgeBaseException {
        if (this.authorGroup != null) {
            this.authorGroup = CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO().getAuthorGroup(this.authorGroup.getAuthorGroupID());
            this.refresh();
        }
    }

    @Override
    public void entityRemoved(ArrayList<AuthorGroup> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityUpdated(ArrayList<AuthorGroup> items) throws KnowledgeBaseException {
        int position;
        if (this.authorGroup != null && (position = items.indexOf(this.authorGroup)) != -1) {
            this.authorGroup = items.get(position);
        }
    }

    private void initComponents() {
        this.groupNameDescriptionLabel = new JLabel();
        this.groupNameTextField = new JTextField();
        this.stopGroupCheckBox = new JCheckBox();
        this.groupNameDescriptionLabel.setText("Group name:");
        this.groupNameTextField.setEditable(false);
        this.stopGroupCheckBox.setText("is stop group?");
        this.stopGroupCheckBox.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.groupNameDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.groupNameTextField, -1, 245, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.stopGroupCheckBox).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.groupNameDescriptionLabel).addComponent(this.groupNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopGroupCheckBox)));
    }
}

