/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.slavepanel;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.slavepanel.GenericOneSlaveItemPanel;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.entity.AuthorReferenceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;
import scimat.project.observer.AuthorReferenceGroupRelationAuthorReferenceObserver;
import scimat.project.observer.EntityObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorReferenceSlaveAuthorReferenceGroupPanel
extends GenericOneSlaveItemPanel
implements AuthorReferenceGroupRelationAuthorReferenceObserver,
EntityObserver<AuthorReferenceGroup> {
    private JLabel groupNameDescriptionLabel;
    private JTextField groupNameTextField;
    private JCheckBox stopGroupCheckBox;
    private AuthorReference authorReference = null;
    private AuthorReferenceGroup authorReferenceGroup = null;

    public AuthorReferenceSlaveAuthorReferenceGroupPanel() {
        this.initComponents();
        CurrentProject.getInstance().getKbObserver().addAuthorReferenceGroupRelationAuthorReferenceObserver(this);
        CurrentProject.getInstance().getKbObserver().addAuthorReferenceGroupObserver(this);
    }

    private void refresh() {
        if (this.authorReferenceGroup != null) {
            this.groupNameTextField.setText(this.authorReferenceGroup.getGroupName());
            this.stopGroupCheckBox.setSelected(this.authorReferenceGroup.isStopGroup());
            this.fireSlaveItemObserver(true);
        } else {
            this.groupNameTextField.setText("");
            this.stopGroupCheckBox.setSelected(false);
        }
    }

    public void setMasterItem(AuthorReference authorReference) {
        this.authorReference = authorReference;
        try {
            if (this.authorReference != null) {
                this.relationChanged();
            } else {
                this.authorReferenceGroup = null;
                this.refresh();
            }
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
    }

    @Override
    public void relationChanged() throws KnowledgeBaseException {
        this.authorReferenceGroup = this.authorReference != null ? CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO().getAuthorReferenceGroup(this.authorReference.getAuthorReferenceID()) : null;
        this.refresh();
    }

    @Override
    public void entityAdded(ArrayList<AuthorReferenceGroup> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRefresh() throws KnowledgeBaseException {
        if (this.authorReferenceGroup != null) {
            this.authorReferenceGroup = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceGroupDAO().getAuthorReferenceGroup(this.authorReferenceGroup.getAuthorReferenceGroupID());
            this.refresh();
        }
    }

    @Override
    public void entityRemoved(ArrayList<AuthorReferenceGroup> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityUpdated(ArrayList<AuthorReferenceGroup> items) throws KnowledgeBaseException {
        int position;
        if (this.authorReferenceGroup != null && (position = items.indexOf(this.authorReferenceGroup)) != -1) {
            this.authorReferenceGroup = items.get(position);
        }
    }

    private void initComponents() {
        this.groupNameDescriptionLabel = new JLabel();
        this.groupNameTextField = new JTextField();
        this.stopGroupCheckBox = new JCheckBox();
        this.groupNameDescriptionLabel.setText("Group name:");
        this.groupNameTextField.setEditable(false);
        this.stopGroupCheckBox.setText("is stop group?");
        this.stopGroupCheckBox.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.groupNameDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.groupNameTextField, -1, 245, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.stopGroupCheckBox).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.groupNameDescriptionLabel).addComponent(this.groupNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopGroupCheckBox)));
    }
}

