/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.slavepanel;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import scimat.gui.components.ErrorDialogManager;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;
import scimat.project.observer.AuthorRelationAuthorReferenceObserver;
import scimat.project.observer.EntityObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorReferenceSlaveAuthorPanel
extends JPanel
implements AuthorRelationAuthorReferenceObserver,
EntityObserver<Author> {
    private JLabel fullNameDescriptionLabel;
    private JTextField fullNameTextField;
    private JLabel nameDescriptionLabel;
    private JTextField nameTextField;
    private AuthorReference authorReference = null;
    private Author author = null;

    public AuthorReferenceSlaveAuthorPanel() {
        this.initComponents();
        CurrentProject.getInstance().getKbObserver().addAuthorObserver(this);
    }

    private void refresh() {
        if (this.author != null) {
            this.nameTextField.setText(this.author.getAuthorName());
            this.fullNameTextField.setText(this.author.getFullAuthorName());
        } else {
            this.nameTextField.setText("");
            this.fullNameTextField.setText("");
        }
    }

    public void setMasterItem(AuthorReference authorReference) {
        this.authorReference = authorReference;
        try {
            if (this.authorReference != null) {
                this.relationChanged();
            } else {
                this.author = null;
                this.refresh();
            }
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
    }

    @Override
    public void relationChanged() throws KnowledgeBaseException {
        this.author = this.authorReference != null ? CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO().getAuthor(this.authorReference.getAuthorReferenceID()) : null;
        this.refresh();
    }

    @Override
    public void entityAdded(ArrayList<Author> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityRefresh() throws KnowledgeBaseException {
        if (this.author != null) {
            this.author = CurrentProject.getInstance().getFactoryDAO().getAuthorDAO().getAuthor(this.authorReference.getAuthorReferenceID());
            this.refresh();
        }
    }

    @Override
    public void entityRemoved(ArrayList<Author> items) throws KnowledgeBaseException {
    }

    @Override
    public void entityUpdated(ArrayList<Author> items) throws KnowledgeBaseException {
        int position;
        if (this.author != null && (position = items.indexOf(this.author)) != -1) {
            this.author = items.get(position);
        }
    }

    private void initComponents() {
        this.nameDescriptionLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.fullNameDescriptionLabel = new JLabel();
        this.fullNameTextField = new JTextField();
        this.nameDescriptionLabel.setText("Name:");
        this.nameTextField.setEditable(false);
        this.fullNameDescriptionLabel.setText("Full name:");
        this.fullNameTextField.setEditable(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fullNameDescriptionLabel).addComponent(this.nameDescriptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fullNameTextField, -1, 347, Short.MAX_VALUE).addComponent(this.nameTextField, -1, 347, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameDescriptionLabel).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fullNameDescriptionLabel).addComponent(this.fullNameTextField, -2, -1, -2))));
    }
}

