/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.movetogroup;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import scimat.gui.components.itemslist.GenericItemsListPanel;
import scimat.gui.components.observer.SelectionObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericMoveToGroupDialog<E>
extends JDialog
implements SelectionObserver {
    private JButton cancelButton;
    private JLabel groupNameDescriptionLabel;
    private JTextField groupNameTextField;
    private JPanel itemsPanel;
    private JSeparator jSeparator1;
    private JButton moveButton;
    private GenericItemsListPanel<E> itemsPanelList;

    public GenericMoveToGroupDialog(Frame parent, GenericItemsListPanel<E> itemsPanelList) {
        super(parent, true);
        this.itemsPanelList = itemsPanelList;
        this.initComponents();
        this.itemsPanelList.setSelectionMode(0);
        this.groupNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                GenericMoveToGroupDialog.this.enableMoveButton();
            }

            public void removeUpdate(DocumentEvent e) {
                GenericMoveToGroupDialog.this.enableMoveButton();
            }

            public void changedUpdate(DocumentEvent e) {
                GenericMoveToGroupDialog.this.enableMoveButton();
            }
        });
        this.itemsPanelList.addSelectionObserver(this);
        this.itemsPanel.add(this.itemsPanelList);
    }

    public void reset() {
        this.groupNameTextField.setText("");
        this.moveButton.setEnabled(false);
        this.itemsPanelList.refreshItems(new ArrayList());
    }

    public void refreshData(ArrayList<E> items) {
        this.itemsPanelList.refreshItems(items);
    }

    @Override
    public void selectionChangeHappened(int[] selection) {
        if (selection.length == 1) {
            this.setGroupNameFromItem(this.itemsPanelList.getSelectedItems().get(0));
        } else {
            this.setGroupNameFromItem(null);
        }
    }

    public void setGroupNameText(String groupName) {
        this.groupNameTextField.setText(groupName);
    }

    private void enableMoveButton() {
        this.moveButton.setEnabled(!this.groupNameTextField.getText().isEmpty());
    }

    public abstract void setGroupNameFromItem(E var1);

    public abstract void moveAction(ArrayList<E> var1, String var2);

    private void initComponents() {
        this.groupNameDescriptionLabel = new JLabel();
        this.groupNameTextField = new JTextField();
        this.itemsPanel = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.moveButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Move to group");
        this.groupNameDescriptionLabel.setText("Group name:");
        this.itemsPanel.setLayout(new BoxLayout(this.itemsPanel, 2));
        this.moveButton.setText("Move");
        this.moveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericMoveToGroupDialog.this.moveButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericMoveToGroupDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.itemsPanel, -1, 380, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.groupNameDescriptionLabel).addPreferredGap(0).add((Component)this.groupNameTextField, -1, 314, Short.MAX_VALUE)).add(2, (Component)this.jSeparator1, -1, 380, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.moveButton).addPreferredGap(0).add((Component)this.cancelButton))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.groupNameDescriptionLabel).add((Component)this.groupNameTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.itemsPanel, -1, 206, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cancelButton).add((Component)this.moveButton)).addContainerGap()));
        this.pack();
    }

    private void moveButtonActionPerformed(ActionEvent evt) {
        this.moveAction(this.itemsPanelList.getItems(), this.groupNameTextField.getText());
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

