/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.components.movetogroup;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import scimat.gui.components.SelectionObserverButton;
import scimat.gui.components.itemslist.GenericDynamicItemsListPanel;
import scimat.gui.components.observer.SelectionObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericMoveSimilarItemToGroupDialog<E extends Comparable<E>>
extends JDialog
implements SelectionObserver {
    private JButton cancelButton;
    private SelectionObserverButton deleteItemsToAddButton;
    private JButton discardButton;
    private JLabel groupNameDescriptionLabel;
    private JTextField groupNameTextField;
    private JPanel itemsPanel;
    private JButton moveButton;
    private JSeparator separator;
    private GenericDynamicItemsListPanel<E> itemsPanelList;
    private boolean cancelled;

    public GenericMoveSimilarItemToGroupDialog(Frame parent, GenericDynamicItemsListPanel<E> itemsPanelList) {
        super(parent, true);
        this.itemsPanelList = itemsPanelList;
        this.initComponents();
        this.itemsPanelList.setSelectionMode(0);
        this.groupNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                GenericMoveSimilarItemToGroupDialog.this.enableMoveButton();
            }

            public void removeUpdate(DocumentEvent e) {
                GenericMoveSimilarItemToGroupDialog.this.enableMoveButton();
            }

            public void changedUpdate(DocumentEvent e) {
                GenericMoveSimilarItemToGroupDialog.this.enableMoveButton();
            }
        });
        this.itemsPanelList.addSelectionObserver(this);
        this.itemsPanel.add(this.itemsPanelList);
    }

    public void reset() {
        this.groupNameTextField.setText("");
        this.moveButton.setEnabled(false);
        this.itemsPanelList.refreshItems(new ArrayList());
        this.deleteItemsToAddButton.setEnabled(false);
        this.cancelled = false;
    }

    public void refreshData(ArrayList<E> items) {
        this.itemsPanelList.refreshItems(items);
    }

    @Override
    public void selectionChangeHappened(int[] selection) {
        if (selection.length == 1) {
            this.setGroupNameFromItem((Comparable)this.itemsPanelList.getSelectedItems().get(0));
        } else {
            this.setGroupNameFromItem(null);
        }
    }

    public void setGroupNameText(String groupName) {
        this.groupNameTextField.setText(groupName);
    }

    private void enableMoveButton() {
        this.moveButton.setEnabled(!this.groupNameTextField.getText().isEmpty() && this.itemsPanelList.getItems().size() > 0);
    }

    public ArrayList<E> getItems() {
        ArrayList itemsList = new ArrayList();
        itemsList = this.itemsPanelList.getItems();
        return itemsList;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public abstract void setGroupNameFromItem(E var1);

    public abstract void moveAction(ArrayList<E> var1, String var2);

    private void initComponents() {
        this.groupNameDescriptionLabel = new JLabel();
        this.groupNameTextField = new JTextField();
        this.itemsPanel = new JPanel();
        this.separator = new JSeparator();
        this.moveButton = new JButton();
        this.cancelButton = new JButton();
        this.discardButton = new JButton();
        this.deleteItemsToAddButton = new SelectionObserverButton(1, -1);
        this.setDefaultCloseOperation(2);
        this.setTitle("Move to group");
        this.groupNameDescriptionLabel.setText("Group name:");
        this.itemsPanel.setLayout(new BoxLayout(this.itemsPanel, 2));
        this.moveButton.setText("Move");
        this.moveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericMoveSimilarItemToGroupDialog.this.moveButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericMoveSimilarItemToGroupDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.discardButton.setText("Discard");
        this.discardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericMoveSimilarItemToGroupDialog.this.discardButtonActionPerformed(evt);
            }
        });
        this.deleteItemsToAddButton.setIcon(new ImageIcon(this.getClass().getResource("/images/delete-icon-16x16.png")));
        this.deleteItemsToAddButton.setText("");
        this.itemsPanelList.addSelectionObserver(this.deleteItemsToAddButton);
        this.deleteItemsToAddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericMoveSimilarItemToGroupDialog.this.deleteItemsToAddButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.itemsPanel, -1, 380, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.groupNameDescriptionLabel).addPreferredGap(0).add((Component)this.groupNameTextField, -1, 314, Short.MAX_VALUE)).add((Component)this.separator, -1, 380, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.discardButton).addPreferredGap(0).add((Component)this.moveButton).addPreferredGap(0).add((Component)this.cancelButton)).add((Component)this.deleteItemsToAddButton, -2, -1, -2)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.groupNameDescriptionLabel).add((Component)this.groupNameTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.itemsPanel, -1, 173, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.deleteItemsToAddButton, -2, -1, -2).addPreferredGap(0).add((Component)this.separator, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cancelButton).add((Component)this.moveButton).add((Component)this.discardButton)).addContainerGap()));
        this.pack();
    }

    private void moveButtonActionPerformed(ActionEvent evt) {
        this.moveAction(this.itemsPanelList.getItems(), this.groupNameTextField.getText());
        this.cancelled = false;
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.dispose();
    }

    private void deleteItemsToAddButtonActionPerformed(ActionEvent evt) {
        this.itemsPanelList.removeItems(this.itemsPanelList.getSelectedItems());
        this.enableMoveButton();
    }

    private void discardButtonActionPerformed(ActionEvent evt) {
        this.cancelled = false;
        this.dispose();
    }
}

